/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseVirtualFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final String PROTOCOL = "das";
    private static final String SRC_PREFIX = "src:";
    private static final String PROTOCOL_SEPARATOR = ":/";

    public static DatabaseVirtualFileSystem getDatabaseFileSystem() {
        return (DatabaseVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DatabaseVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(Project project) {
        super.onProjectOpened(project);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DatabaseEditorHelper.installEditorFactoryListener(project));
        DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/vfs/DatabaseVirtualFileSystem$1", "dataSourceAdded"));
                }
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/vfs/DatabaseVirtualFileSystem$1", "dataSourceRemoved"));
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.clearInvalidFiles(), app.getDisposed());
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null || dataSource.isInBatch()) {
                    return;
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.updateReadonlyFlag(dataSource), app.getDisposed());
            }
        });
    }

    protected String getPresentableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "getPresentableUrl"));
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        return super.getPresentableUrl(file);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "findFileByPathInner"));
        }
        boolean source = path.startsWith(SRC_PREFIX);
        int separatorIdx = path.indexOf(PROTOCOL_SEPARATOR);
        if (separatorIdx == -1) {
            return null;
        }
        int separatorEnd = separatorIdx + PROTOCOL_SEPARATOR.length();
        String elementType = path.substring(source ? SRC_PREFIX.length() : 0, separatorIdx);
        int projectIdEnd = path.indexOf(47, separatorEnd);
        String projectId = path.substring(separatorEnd, projectIdEnd);
        int dataSourceEnd = path.indexOf(47, projectIdEnd + 1);
        if (dataSourceEnd == -1) {
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        if (nameStart == -1 || nameStart <= projectIdEnd) {
            return null;
        }
        String name = DatabaseVirtualFileSystem.unescapeSlash((String)path.substring(nameStart + 1));
        String dataSourceId = path.substring(projectIdEnd + 1, nameStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null) {
            return null;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        ObjectKind kind = dialect.getMetaModel().findKind(elementType);
        if (kind == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = new DatabaseElementVirtualFileImpl(projectId, dataSourceId, name, kind, source);
        if (dataSource.getDelegate() instanceof LocalDataSource) {
            file.setWritableInner(!((AbstractDataSource)dataSource.getDelegate()).isReadOnly());
        }
        return file;
    }

    @NotNull
    public static String getPath(Project project, String dataSourceId, String tableName, ObjectKind kind, boolean source) {
        String string = DatabaseVirtualFileSystem.getPath(project.getLocationHash(), dataSourceId, tableName, kind, source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "getPath"));
        }
        return string;
    }

    @NotNull
    public static String getPath(String projectId, String dataSourceId, String qname, ObjectKind kind, boolean source) {
        String string = (source ? SRC_PREFIX : "") + kind.code() + PROTOCOL_SEPARATOR + projectId + "/" + dataSourceId + "/" + DatabaseVirtualFileSystem.escapeSlash((String)qname);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "getPath"));
        }
        return string;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException("rename not supported: " + vFile.getUrl());
    }

    private void updateReadonlyFlag(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/vfs/DatabaseVirtualFileSystem", "updateReadonlyFlag"));
        }
        boolean writable = !dataSource.isReadOnly();
        String id = dataSource.getUniqueId();
        for (VirtualFile file : this.getCachedFiles()) {
            if (!(file instanceof DatabaseElementVirtualFileImpl) || !Comparing.equal((String)id, (String)((DatabaseElementVirtualFileImpl)file).getDataSourceId()) || file.isWritable() == writable) continue;
            ((DatabaseElementVirtualFileImpl)file).setWritable(writable);
        }
    }
}

