/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabasePreviewDialog
extends DialogWrapper {
    private final Project myProject;
    private final DbDataSource mySource;
    private final List<DasNamespace> mySearchPath;
    private final String myQuery;
    private SqlPreviewPanel myPreviewPanel;
    private String myLabelText;
    @NotNull
    private final List<String> myMessages;

    public DatabasePreviewDialog(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull String title, @NotNull String labelText, @NotNull String query, @NotNull List<String> messages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        if (labelText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelText", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/database/view/ui/DatabasePreviewDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource;
        this.mySearchPath = searchPath;
        this.myQuery = query;
        this.myLabelText = labelText;
        this.myMessages = messages;
        this.setTitle(title);
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabasePreviewDialog", "getDimensionServiceKey"));
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myPreviewPanel = new SqlPreviewPanel(this.myProject, this.mySource, this.mySearchPath, this.myQuery, this.getDimensionServiceKey(), () -> this.close(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel(this.myLabelText), "Center");
        if (!this.myMessages.isEmpty()) {
            ErrorLabel error = new ErrorLabel("There are errors!", UIUtil.getBalloonErrorIcon());
            error.setErrorText(StringUtil.join(this.myMessages, (String)"\n"), (Color)JBColor.RED);
            northPanel.add((Component)error, "East");
        }
        panel.add((Component)northPanel, "North");
        panel.add((Component)this.myPreviewPanel, "Center");
        return panel;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }
}

