/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlTypesStatisticIndex;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.fragments.SqlCodeFragmentImpl;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.CharSequenceSubSequence;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlKeywordCompletionContributor
extends CompletionContributor {
    public static final int USAGE_THRESHOLD = 2;
    private static TokenSet DO_NOT_BALANCE = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN});
    private static final Pattern WHITESPACES = Pattern.compile("[\\u00A0\\s]+");
    private static final InsertHandler<LookupElement> WHITESPACE_PROTECTED = new SqlCompletionUtil.TemplateSafeInsertHandler(",;", false);
    private static final InsertHandler<LookupElement> WHITESPACE_POPUP_PROTECTED = new SqlCompletionUtil.TemplateSafeInsertHandler(",;", true);

    public SqlKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlKeywordCompletionContributor$1", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/sql/completion/SqlKeywordCompletionContributor$1", "addCompletions"));
                }
                PsiFile file = parameters.getOriginalFile();
                if (!(file instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
                    return;
                }
                PsiElement prevSibling = position.getParent().getPrevSibling();
                if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlTokens.SQL_PERIOD) {
                    return;
                }
                SqlLanguageDialect dialect = ((SqlFile)file).getSqlLanguage();
                SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)position.getProject()).getCustomSettings(SqlCodeStyleSettings.class);
                Case keywordCase = SqlCodeStyleSettings.getCaseMode((int)(settings == null ? 2 : settings.KEYWORD_CASE));
                Case typeCase = settings == null ? SqlCodeStyleSettings.getCaseMode((int)2) : settings.getCaseModeExt(settings.TYPE_CASE);
                CompletionResultSet result2 = _result.caseInsensitive();
                if (dialect == DbSqlUtil.getGenericDialect()) {
                    for (String s : dialect.getKeywords()) {
                        if (!result2.getPrefixMatcher().prefixMatches(s)) continue;
                        result2.addElement(SqlCompletionUtil.createKeywordLookupElement(keywordCase, s, (InsertHandler<LookupElement>)WHITESPACE_PROTECTED, 0.0, new String[0]));
                    }
                } else {
                    SqlKeywordCompletionContributor.suggestKeywords(result2, position, parameters, keywordCase, typeCase);
                }
            }
        });
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "fillCompletionVariants"));
        }
        if (!SqlCompletionUtil.isNumericLiteral(parameters)) {
            super.fillCompletionVariants(parameters, result2);
        }
    }

    public static boolean isSupported(SqlLanguageDialect dialect) {
        return dialect != DbSqlUtil.getGenericDialect();
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> getTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getTypeWeightMap"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getTypeWeightMap"));
        }
        Pair pair = (Pair)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "lambda$getTypeWeightMap$0"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "lambda$getTypeWeightMap$0"));
            }
            return CachedValueProvider.Result.create(SqlKeywordCompletionContributor.calcTypeWeightMap(file, dialect), (Object[])new Object[]{file});
        });
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getTypeWeightMap"));
        }
        return pair;
    }

    @NotNull
    private static Pair<Map<String, Integer>, Long> calcTypeWeightMap(@NotNull PsiElement file, @NotNull Language dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "calcTypeWeightMap"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "calcTypeWeightMap"));
        }
        String id = dialect.getID();
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection keys = index.getAllKeys(SqlTypesStatisticIndex.NAME, file.getProject());
        THashMap map = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)file.getProject());
        long total = 0L;
        for (String key : keys) {
            if (!key.startsWith(id)) continue;
            List values = index.getValues(SqlTypesStatisticIndex.NAME, (Object)key, scope);
            int subTotal = 0;
            for (Integer value : values) {
                subTotal += value.intValue();
            }
            total += (long)subTotal;
            map.put(key.substring(id.length() + 2), subTotal);
        }
        Pair pair = Pair.create((Object)map, (Object)total);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "calcTypeWeightMap"));
        }
        return pair;
    }

    public static void suggestKeywords(final @NotNull CompletionResultSet result2, @NotNull PsiElement position, final @NotNull CompletionParameters parameters, final @NotNull Case keywordCase, final @NotNull Case typeCase) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "suggestKeywords"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "suggestKeywords"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "suggestKeywords"));
        }
        if (keywordCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordCase", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "suggestKeywords"));
        }
        if (typeCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCase", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "suggestKeywords"));
        }
        final PsiElement root2 = SqlKeywordCompletionContributor.getStatementsRoot(position);
        final Language dialect = SqlKeywordCompletionContributor.getLanguage(root2);
        Pair<String, String> prefSuf = SqlKeywordCompletionContributor.extractFragment(position, root2, dialect);
        String fragment = (String)prefSuf.first;
        String tailText = StringUtil.notNullize((String)InjectedLanguageUtil.getUnescapedLeafText((PsiElement)position, (boolean)false));
        String tailTextTrimmed = StringUtil.trimEnd((String)tailText, (String)"IntellijIdeaRulezzz");
        boolean empty = StringUtil.isEmptyOrSpaces((String)(fragment = fragment + tailTextTrimmed));
        String text = empty ? "" : fragment + (String)prefSuf.second;
        int offset = parameters.getOffset();
        int completionOffset = empty ? 0 : fragment.length() - (tailTextTrimmed.length() - (offset - position.getTextRange().getStartOffset()));
        SqlCodeFragmentImpl file = root2 instanceof SqlCodeFragmentImpl ? new SqlCodeFragmentImpl((SqlCodeFragmentImpl)root2, text) : PsiFileFactory.getInstance((Project)root2.getProject()).createFileFromText("a.sql", dialect, (CharSequence)text, true, false);
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

            public String convertItem(Object o) {
                return o instanceof SqlKeywordTokenType || o instanceof String || o instanceof IElementType[] ? super.convertItem(o) : null;
            }

            public void addItem(@NotNull PsiBuilder builder, @NotNull String itemText) {
                int count;
                Case mode;
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "addItem"));
                }
                if (itemText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemText", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "addItem"));
                }
                String frameName = this.frameName(builder);
                boolean type = "<type>".equals(frameName);
                boolean funArg = frameName != null && frameName.endsWith("paren argument list>");
                double correction = this.correction(type, itemText);
                Case case_ = mode = type ? typeCase : keywordCase;
                if (!result2.getPrefixMatcher().prefixMatches(mode.apply(itemText))) {
                    return;
                }
                String completionPrefix = StringUtil.notNullize((String)this.buildSearchText(builder, Math.max(this.offset - builder.getCurrentOffset(), 0)));
                int errorReportedAt = this.findReportedError(builder);
                if (errorReportedAt == builder.rawTokenIndex()) {
                    correction -= 0.1;
                }
                LookupElement element = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, itemText, dialect, builder, frameName, !type, correction + (double)(funArg ? 1 : 0));
                if (type && (count = StatisticsWeigher.getBaseStatisticsInfo((LookupElement)element, (CompletionLocation)new CompletionLocation(parameters)).getUseCount()) >= 2) {
                    element = SqlKeywordCompletionContributor.createKeywordLookupElement(mode, completionPrefix, itemText, dialect, builder, frameName, false, correction + 1.0);
                }
                result2.addElement(element);
            }

            private int findReportedError(PsiBuilder builder) {
                GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
                while (frame != null) {
                    if (frame.errorReportedAt != -1) {
                        return frame.errorReportedAt;
                    }
                    frame = frame.parentFrame;
                }
                return -1;
            }

            private double correction(boolean type, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "correction"));
                }
                if (type) {
                    Pair map = SqlKeywordCompletionContributor.getTypeWeightMap(root2, dialect);
                    Integer count = (Integer)((Map)map.first).get(text);
                    return count != null ? 1.0 * (double)count.intValue() / (double)((Long)map.second).longValue() : 0.0;
                }
                if (text.equalsIgnoreCase("left join") || text.equalsIgnoreCase("right join")) {
                    return 0.1;
                }
                return 0.0;
            }

            @Nullable
            private String buildSearchText(@NotNull PsiBuilder builder, int maxLength) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "buildSearchText"));
                }
                int builderOffset = builder.getCurrentOffset();
                if (this.offset == builderOffset) {
                    return "";
                }
                StringBuilder compText = new StringBuilder();
                int i2 = 0;
                while (true) {
                    IElementType type = builder.rawLookup(i2);
                    int tokenStart = builder.rawTokenTypeStart(i2);
                    if (tokenStart > this.offset || type == null) {
                        compText.append(" ");
                        break;
                    }
                    if (!GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                        int tokenEnd = Math.min(builder.rawTokenTypeStart(i2 + 1), this.offset);
                        CharSequence token = builder.getOriginalText().subSequence(tokenStart, tokenEnd);
                        if (compText.length() > 0 || this.convertItem(type) != null) {
                            if (compText.length() != 0) {
                                compText.append(" ");
                            }
                            compText.append(token);
                        }
                        if (compText.length() >= maxLength && tokenEnd != this.offset) {
                            return null;
                        }
                        if (tokenEnd == this.offset) break;
                    }
                    ++i2;
                }
                return compText.length() > 0 ? compText.toString() : "";
            }

            public boolean prefixMatches(@NotNull PsiBuilder builder, @NotNull String text) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "prefixMatches"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "prefixMatches"));
                }
                String searchText = this.buildSearchText(builder, text.length());
                return searchText != null && (searchText.isEmpty() || super.prefixMatches(searchText, text));
            }

            @Nullable
            private String frameName(@NotNull PsiBuilder builder) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor$2", "frameName"));
                }
                GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
                while (frame != null) {
                    if (!StringUtil.isEmpty((String)frame.name)) {
                        return frame.name;
                    }
                    frame = frame.parentFrame;
                }
                return null;
            }
        };
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
    }

    @Nullable
    private static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> clazz, @NotNull PsiElement ceil) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getTopmostParentOfType"));
        }
        if (ceil == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ceil", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getTopmostParentOfType"));
        }
        if (ceil == element) {
            return null;
        }
        return (T)((PsiElement)ObjectUtils.chooseNotNull(element == null ? null : SqlKeywordCompletionContributor.getTopmostParentOfType(element.getParent(), clazz, ceil), (Object)ObjectUtils.tryCast((Object)element, clazz)));
    }

    @NotNull
    private static Pair<String, String> extractFragment(@NotNull PsiElement position, @NotNull PsiElement root2, @NotNull Language dialect) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "extractFragment"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "extractFragment"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "extractFragment"));
        }
        PsiFile rootFile = root2.getContainingFile();
        SqlStatement loBound = SqlKeywordCompletionContributor.getTopmostParentOfType(position, SqlStatement.class, root2);
        if (loBound != null) {
            loBound = SqlKeywordCompletionContributor.findGoodStatement((PsiElement)loBound, root2);
        }
        if (loBound != null) {
            loBound = loBound.getFirstChild();
        }
        if (loBound == null) {
            loBound = (PsiElement)ObjectUtils.chooseNotNull((Object)SqlKeywordCompletionContributor.getFragmentBorderElement(dialect, root2, position, true), (Object)root2);
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)root2).expand(Conditions.alwaysTrue());
        s = (SyntaxTraverser)ScriptModelUtil.inRange(s, TextRange.create((int)loBound.getTextRange().getStartOffset(), (int)position.getTextRange().getStartOffset())).filter(element -> {
            LeafPsiElement leaf = (LeafPsiElement)ObjectUtils.tryCast((Object)element, LeafPsiElement.class);
            return leaf != null && !DO_NOT_BALANCE.contains(leaf.getElementType());
        });
        int balance = 0;
        for (PsiElement element2 : s) {
            balance += SqlKeywordCompletionContributor.getParenBalance(element2.getText());
        }
        String text = InjectedLanguageUtil.getUnescapedText((PsiFile)rootFile, (PsiElement)loBound, (PsiElement)position);
        Pair pair = Pair.create((Object)text, (Object)(balance > 0 ? StringUtil.repeat((String)")", (int)balance) : ""));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "extractFragment"));
        }
        return pair;
    }

    @Nullable
    private static SqlStatement getPrevStatementSameLevel(@NotNull PsiElement stmt) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getPrevStatementSameLevel"));
        }
        PsiElement parent = SqlKeywordCompletionContributor.blockRoot(stmt);
        SyntaxTraverser s = ScriptModelUtil.inRange((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)parent), TextRange.create((int)0, (int)stmt.getTextOffset()));
        return (SqlStatement)((SyntaxTraverser)s.expandAndSkip(Conditions.or((Condition)Conditions.is((Object)parent), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK))))).filter(SqlStatement.class).first();
    }

    @Nullable
    private static PsiElement blockRoot(@NotNull PsiElement stmt) {
        PsiElement parent;
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "blockRoot"));
        }
        for (parent = stmt.getParent(); parent != null && parent.getNode() != null && parent.getNode().getElementType() == GeneratedParserUtilBase.DUMMY_BLOCK; parent = parent.getParent()) {
        }
        return parent;
    }

    @NotNull
    static PsiElement findGoodStatement(@NotNull PsiElement stmt, @NotNull PsiElement ceil) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findGoodStatement"));
        }
        if (ceil == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ceil", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findGoodStatement"));
        }
        PsiElement levelStatement = stmt;
        while (levelStatement != null && PsiTreeUtil.isAncestor((PsiElement)ceil, (PsiElement)levelStatement, (boolean)true)) {
            SqlStatement prev = SqlKeywordCompletionContributor.getPrevStatementSameLevel(levelStatement);
            if (prev != null && SqlKeywordCompletionContributor.findError((PsiElement)prev, stmt) != null) {
                SqlStatement sqlStatement = prev;
                if (sqlStatement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findGoodStatement"));
                }
                return sqlStatement;
            }
            levelStatement = PsiTreeUtil.getParentOfType((PsiElement)levelStatement, SqlStatement.class);
        }
        PsiElement psiElement = stmt;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findGoodStatement"));
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement findError(@NotNull PsiElement stmt, @NotNull PsiElement end) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findError"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findError"));
        }
        HashSet checked = ContainerUtil.newHashSet();
        PsiElement tmp = PsiTreeUtil.prevLeaf((PsiElement)end, (boolean)false);
        while (tmp != null) {
            if (SqlKeywordCompletionContributor.isError(tmp, checked)) {
                return tmp;
            }
            if (!(tmp instanceof PsiComment) && !StringUtil.isEmptyOrSpaces((String)tmp.getText()) && tmp.getTextRange().getStartOffset() < stmt.getTextRange().getEndOffset()) break;
            tmp = PsiTreeUtil.prevLeaf((PsiElement)tmp, (boolean)false);
        }
        return null;
    }

    private static boolean isError(@NotNull PsiElement el, @NotNull Set<PsiElement> checked) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "isError"));
        }
        if (checked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checked", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "isError"));
        }
        if (el instanceof PsiErrorElement) {
            return true;
        }
        PsiElement parent = el.getParent();
        if (parent == null || checked.contains(parent)) {
            return false;
        }
        checked.add(parent);
        return SqlKeywordCompletionContributor.isError(parent, checked);
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getLanguage"));
        }
        if (element instanceof LazyParseablePsiElement) {
            Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element, (Object)PlainTextLanguage.INSTANCE);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getLanguage"));
            }
            return language;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element);
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getLanguage"));
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    private static PsiElement getStatementsRoot(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getStatementsRoot"));
        }
        LazyParseablePsiElement root2 = (LazyParseablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, LazyParseablePsiElement.class);
        PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)root2, (Object)element.getContainingFile());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getStatementsRoot"));
        }
        return psiElement;
    }

    @NotNull
    private static LookupElement createKeywordLookupElement(@NotNull Case keywordCase, @NotNull String filePrefix, @NotNull String str, @NotNull Language dialect, @NotNull PsiBuilder builder, @Nullable String frameName, boolean addWhitespace, double correction) {
        if (keywordCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordCase", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        if (filePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePrefix", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        String k = SqlKeywordCompletionContributor.findMultiWordKeyword(filePrefix, str);
        InsertHandler<LookupElement> customHandler = SqlKeywordCompletionContributor.findCustomInsertHandler(str, builder, frameName, dialect);
        InsertHandler<LookupElement> handler = customHandler != null ? customHandler : (addWhitespace ? WHITESPACE_PROTECTED : null);
        LookupElement lookupElement = k != null ? SqlCompletionUtil.createKeywordLookupElement(keywordCase, k, handler, correction, new String[0]) : SqlCompletionUtil.createKeywordLookupElement(keywordCase, str, handler, correction, str.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_"), str.replaceAll(" ", "_"));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "createKeywordLookupElement"));
        }
        return lookupElement;
    }

    private static boolean isInsideAnalyticClause(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "isInsideAnalyticClause"));
        }
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null) {
            if (frame.elementType == SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE) {
                return true;
            }
            frame = frame.parentFrame;
        }
        return false;
    }

    @Nullable
    private static InsertHandler<LookupElement> findCustomInsertHandler(@NotNull String str, @NotNull PsiBuilder builder, @Nullable String frameName, @NotNull Language dialect) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findCustomInsertHandler"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findCustomInsertHandler"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findCustomInsertHandler"));
        }
        if (SqlKeywordCompletionContributor.isInsideAnalyticClause(builder)) {
            return null;
        }
        if (str.equalsIgnoreCase("AUTO_INCREMENT") || frameName != null && frameName.endsWith("paren argument list>")) {
            return SqlCompletionUtil.DUMMY_HANDLER;
        }
        if (str.equalsIgnoreCase("VARCHAR") || str.equalsIgnoreCase("VARCHAR2")) {
            return ParenthesesInsertHandler.WITH_PARAMETERS;
        }
        if (str.equalsIgnoreCase("WHERE") || str.equalsIgnoreCase("FROM") || str.equalsIgnoreCase("ON") || StringUtil.endsWithIgnoreCase((String)str, (String)"JOIN") && "<join>".equals(frameName)) {
            return WHITESPACE_POPUP_PROTECTED;
        }
        if (str.equalsIgnoreCase("GO")) {
            return SqlCompletionUtil.NEW_LINE_INSERT_HANDLER;
        }
        return null;
    }

    @Nullable
    public static String findMultiWordKeyword(@NotNull String filePrefix, @NotNull String str) {
        if (filePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePrefix", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findMultiWordKeyword"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "findMultiWordKeyword"));
        }
        List<CharSequence> kwSeq = SqlKeywordCompletionContributor.splitSpaces(str);
        if (kwSeq == null) {
            return null;
        }
        List<CharSequence> fileSeq = SqlKeywordCompletionContributor.splitSpaces(filePrefix);
        if (fileSeq == null) {
            fileSeq = Collections.singletonList(filePrefix);
        }
        for (int i2 = Math.min(kwSeq.size(), fileSeq.size()); i2 > 0; --i2) {
            ThreeState comparison = SqlKeywordCompletionContributor.compareFileSuffixWithKwPrefix(fileSeq, kwSeq, i2);
            if (comparison == ThreeState.NO) continue;
            int matched = comparison == ThreeState.UNSURE ? i2 - 1 : i2;
            return StringUtil.join(kwSeq.subList(matched, kwSeq.size()), (String)" ");
        }
        return null;
    }

    private static ThreeState compareFileSuffixWithKwPrefix(@NotNull List<CharSequence> fileSeq, @NotNull List<CharSequence> kwSeq, int size) {
        if (fileSeq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSeq", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "compareFileSuffixWithKwPrefix"));
        }
        if (kwSeq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kwSeq", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "compareFileSuffixWithKwPrefix"));
        }
        assert (size > 0);
        int end = size - 1;
        for (int i2 = 0; i2 < end; ++i2) {
            CharSequence keyWord;
            CharSequence fileWord = fileSeq.get(fileSeq.size() - size + i2);
            if (StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)(keyWord = kwSeq.get(i2)))) continue;
            return ThreeState.NO;
        }
        CharSequence fileWord = fileSeq.get(fileSeq.size() - 1);
        CharSequence keyWord = kwSeq.get(size - 1);
        if (keyWord.length() >= fileWord.length() && StringUtil.equalsIgnoreCase((CharSequence)fileWord, (CharSequence)keyWord.subSequence(0, fileWord.length()))) {
            return keyWord.length() == fileWord.length() ? ThreeState.YES : ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    @Nullable
    private static PsiElement getFragmentBorderElement(@NotNull Language dialect, PsiElement root2, PsiElement position, boolean backward) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getFragmentBorderElement"));
        }
        int count = 0;
        PsiElement cur = position;
        while (cur != null && cur != root2) {
            PsiElement next;
            PsiElement psiElement = next = backward ? cur.getPrevSibling() : cur.getNextSibling();
            if (next instanceof SqlStatement) {
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next.getLastChild())) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
                return next;
            }
            if (next instanceof SqlBatchBlock || next instanceof GeneratedParserUtilBase.DummyBlock) {
                PsiElement psiElement2 = next = backward ? PsiTreeUtil.getDeepestLast((PsiElement)next) : PsiTreeUtil.getDeepestFirst((PsiElement)next);
                if (backward && SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                    return SqlKeywordCompletionContributor.getNextElement(next);
                }
            } else if (next == null) {
                next = cur.getParent();
            } else if (SqlKeywordCompletionContributor.isStatementClosingToken(dialect, next)) {
                return SqlKeywordCompletionContributor.getNextElement(next);
            }
            cur = next;
            ++count;
        }
        return null;
    }

    private static PsiElement getNextElement(PsiElement next) {
        for (PsiElement e = next; e != null; e = e.getParent()) {
            PsiElement p = e.getNextSibling();
            if (p == null) continue;
            return p;
        }
        return next;
    }

    private static boolean isStatementClosingToken(@NotNull Language dialect, PsiElement child) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "isStatementClosingToken"));
        }
        return dialect instanceof SqlLanguageDialect && child instanceof LeafPsiElement && ((SqlLanguageDialect)dialect).getStatementSeparators().contains(((LeafPsiElement)child).getElementType());
    }

    private static int getParenBalance(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/completion/SqlKeywordCompletionContributor", "getParenBalance"));
        }
        int count = 0;
        int len = text.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = text.charAt(i2);
            if (c == '(') {
                ++count;
            }
            if (c != ')') continue;
            --count;
        }
        return count;
    }

    private static List<CharSequence> splitSpaces(CharSequence input) {
        List res = null;
        Matcher matcher = WHITESPACES.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        int start = 0;
        int end = matcher.start();
        while (true) {
            if (res == null) {
                res = ContainerUtil.newSmartList();
            }
            res.add(new CharSequenceSubSequence(input, start, end));
            if (end == input.length()) break;
            start = matcher.end();
            end = matcher.find() ? matcher.start() : input.length();
        }
        return res;
    }
}

