/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.sql.database.SqlModelBuilderUtils;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private SqlFileProcessor myLastProcessor;

    public SqlModelBuilder(@NotNull Project project, @NotNull BasicModModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/database/SqlModelBuilder", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/database/SqlModelBuilder", "<init>"));
        }
        this.myProject = project;
        this.myModel = model;
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder", "getModel"));
        }
        return basicModModel;
    }

    public void introspect(@NotNull Iterable<? extends SqlFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/sql/database/SqlModelBuilder", "introspect"));
        }
        SqlFileProcessor processor = new SqlFileProcessor(this.myProject, this.myModel);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/sql/database/SqlModelBuilder", "lambda$introspect$1"));
            }
            this.myModel.modify(BasicModRoot.class, r -> {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/sql/database/SqlModelBuilder", "lambda$null$0"));
                }
                processor.prepare();
                try {
                    files.forEach(processor::process);
                }
                finally {
                    processor.finish();
                }
            });
        });
        this.myLastProcessor = processor;
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
        SqlFileProcessor processor = this.myLastProcessor;
        Map<Object, Object> map = processor == null ? Collections.emptyMap() : processor.reverseMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder", "reverseMap"));
        }
        return map;
    }

    private static class DasPath {
        @Nullable
        public final DasPath parent;
        @NotNull
        public final ObjectName name;
        @Nullable
        public final String subName;
        @NotNull
        public final ObjectKind kind;

        public DasPath(@Nullable DasPath parent, @NotNull ObjectName name, @Nullable String subName, @NotNull ObjectKind kind) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/database/SqlModelBuilder$DasPath", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlModelBuilder$DasPath", "<init>"));
            }
            this.parent = parent;
            this.name = name;
            this.subName = subName;
            this.kind = kind;
        }

        public DasPath(@Nullable DasPath parent, @NotNull ObjectName name, @NotNull ObjectKind kind) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/database/SqlModelBuilder$DasPath", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlModelBuilder$DasPath", "<init>"));
            }
            this(parent, name, null, kind);
        }

        @NotNull
        public DasPath append(@NotNull ObjectName name, @NotNull ObjectKind kind) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/database/SqlModelBuilder$DasPath", "append"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlModelBuilder$DasPath", "append"));
            }
            DasPath dasPath = new DasPath(this, name, kind);
            if (dasPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$DasPath", "append"));
            }
            return dasPath;
        }

        public static DasPath of(@Nullable DasObject object, @NotNull DatabaseFamilyId familyId, @Nullable Map<DasObject, DasPath> cache) {
            DasPath path;
            if (familyId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/sql/database/SqlModelBuilder$DasPath", "of"));
            }
            if (object == null) {
                return null;
            }
            DasPath dasPath = path = cache == null ? null : cache.get(object);
            if (path != null) {
                return path;
            }
            DasPath parent = DasPath.of(object.getDbParent(), familyId, cache);
            DasPath dasPath2 = path = cache == null ? null : cache.get(object);
            if (path != null) {
                return path;
            }
            path = new DasPath(parent, DasPath.getName(object), DasPath.getSubName(object, familyId), object.getKind());
            if (cache != null) {
                cache.put(object, path);
            }
            return path;
        }

        @NotNull
        public static ObjectName getName(@NotNull DasObject obj) {
            SqlNameElement element;
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/database/SqlModelBuilder$DasPath", "getName"));
            }
            String name = obj.getName();
            boolean quoted = true;
            if (obj instanceof SqlDefinition && (element = ((SqlDefinition)obj).getNameElement()) != null) {
                quoted = element.isQuotedIdentifier();
            }
            ObjectName objectName = new ObjectName(name, quoted);
            if (objectName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$DasPath", "getName"));
            }
            return objectName;
        }

        @Nullable
        public static String getSubName(@NotNull DasObject obj, @NotNull DatabaseFamilyId family) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/database/SqlModelBuilder$DasPath", "getSubName"));
            }
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/sql/database/SqlModelBuilder$DasPath", "getSubName"));
            }
            String name = obj.getName();
            if (obj instanceof BasicElement) {
                String id = obj instanceof BasicOverloadable ? ((BasicOverloadable)obj).identity(true) : null;
                return id == null || id.equals(name) ? null : id;
            }
            if (family.isSybase() && obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
                short pos = SqlModelBuilderUtils.getSybaseNumber(obj);
                return ModelUtil.calculateSybProcedureIdentity(pos);
            }
            if (!(obj instanceof DasRoutine)) {
                return null;
            }
            String id = DasPath.hasOverloads(family) ? ModelUtil.calculateRoutineIdentity(name, ((DasRoutine)obj).getArguments()) : null;
            return name.equals(id) ? null : id;
        }

        private static boolean hasOverloads(DatabaseFamilyId familyId) {
            return familyId.isDb2() || familyId.isDerby() || familyId == DatabaseFamilyId.UNKNOWN || familyId.isH2() || familyId.isHsqldb() || familyId.isMysql() || familyId.isPostgres();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DasPath path = (DasPath)o;
            if (!this.kind.equals(path.kind)) {
                return false;
            }
            if (!this.name.equals((Object)path.name)) {
                return false;
            }
            return !(this.parent != null ? !this.parent.equals(path.parent) : path.parent != null);
        }

        public int hashCode() {
            int result2 = this.parent != null ? this.parent.hashCode() : 0;
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.kind.hashCode();
            return result2;
        }
    }

    private static class SqlFileProcessor {
        private final Project myProject;
        private final Map<DasPath, BasicModElement> myObjects;
        private final Map<DasObject, DasPath> myPaths;
        private final Map<ObjectKind, BasicModElement> myEmptyParents;
        private final BasicModModel myModel;
        private final MetaModel myMetaModel;
        private final DatabaseFamilyId myFamilyId;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        public SqlFileProcessor(@NotNull Project project, @NotNull BasicModModel model) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "<init>"));
            }
            this.myObjects = ContainerUtil.newHashMap();
            this.myPaths = ContainerUtil.newHashMap();
            this.myEmptyParents = ContainerUtil.newHashMap();
            this.myOraPackageRestarter = ContainerUtil.newHashMap();
            this.myProject = project;
            this.myModel = model;
            this.myFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(this.myModel.getRdbms()), (Object)DatabaseFamilyId.UNKNOWN);
            DatabaseDialectEx dialect = this.getDialect();
            this.myMetaModel = dialect.getMetaModel();
        }

        @NotNull
        private DatabaseDialectEx getDialect() {
            DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DatabaseDialects.findByFamily(this.myFamilyId), (Object)GenericDialect.INSTANCE);
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getDialect"));
            }
            return databaseDialectEx;
        }

        public void prepare() {
            for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
                for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                    modFamily.markChildrenAsSyncPending();
                }
            }
            ((BasicModRoot)this.myModel.getRoot()).setDefaultCasing(this.getDialect().getCasing(ObjectKind.NONE, null));
        }

        public void finish() {
            for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
                for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                    modFamily.removeSyncPendingChildren();
                    modFamily.sort();
                }
            }
            this.finalizeObjects();
        }

        public void finalizeObjects() {
            for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
                SqlModelBuilderUtils.finalizeObject(element);
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "process"));
            }
            for (DasObject obj : file.traverser().preOrderDfsTraversal()) {
                this.process(obj);
            }
        }

        @NotNull
        private BasicModElement process(@NotNull DasObject obj) {
            BasicModElement target;
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "process"));
            }
            if (obj instanceof SqlRenameToClause) {
                BasicModElement basicModElement = this.getRoot();
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "process"));
                }
                return basicModElement;
            }
            BasicModElement parent = this.getParent(obj);
            DasPath path = DasPath.of(obj, this.myFamilyId, this.myPaths);
            ObjectKind kind = this.myMetaModel.unaliased(obj.getKind());
            Family family = parent.familyOf(kind);
            if (family == null) {
                boolean ignored = false;
                DasPath p = path;
                while (p.parent != null && !ignored) {
                    if (SqlModelBuilderUtils.isIgnored(this.myFamilyId, p.parent.kind, p.kind)) {
                        ignored = true;
                    }
                    p = p.parent;
                }
                if (!ignored && !SqlModelBuilderUtils.isIgnored(this.myFamilyId, parent.getKind(), obj.getKind())) {
                    SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parent.getKind().code());
                }
                target = this.getRoot();
                this.myObjects.put(path, target);
            } else {
                this.processOddities(obj, parent, kind);
                target = SqlFileProcessor.createOrGet(family, path.name.name, path.subName);
                this.myObjects.put(path, target);
                SqlModelBuilderUtils.fillObject(target, obj);
            }
            BasicModElement basicModElement = target;
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "process"));
            }
            return basicModElement;
        }

        private void processOddities(@NotNull DasObject obj, BasicModElement parent, ObjectKind kind) {
            PsiElement element;
            PsiObject pkg;
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "processOddities"));
            }
            if (this.myFamilyId.isOracle() && parent.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element = this.myOraPackageRestarter.get(parent)) == null || element != pkg)) {
                this.myOraPackageRestarter.put(parent, (PsiElement)pkg);
                JBIterable.from(parent.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @NotNull
        private static BasicModElement createOrGet(@NotNull ModFamily<?> family, @NotNull String name, @Nullable String subName) {
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "createOrGet"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "createOrGet"));
            }
            if (family instanceof ModSingletonFamily) {
                Object e = ((ModSingletonFamily)family).createOrGet();
                if (e == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "createOrGet"));
                }
                return e;
            }
            BasicModElement obj = family.find(o -> {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "lambda$createOrGet$2"));
                }
                return name.equals(o.getName()) && (subName == null || subName.equals(o.identity()));
            });
            if (obj != null && !obj.isSyncPending() && StringUtil.isEmpty((String)name) && !(obj instanceof BasicNamespace)) {
                obj = null;
            }
            if (obj instanceof BasicOverloadable) {
                obj = null;
            }
            if (obj == null) {
                obj = family.createNewOne();
                if (obj instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj).setName(name);
                }
            } else {
                obj.resetSyncPending();
            }
            BasicModElement basicModElement = obj;
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "createOrGet"));
            }
            return basicModElement;
        }

        @NotNull
        private BasicModElement getParent(@NotNull DasObject obj) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getParent"));
            }
            DasObject parent = obj.getDbParent();
            if (parent == null || parent.getKind() == ObjectKind.NONE) {
                BasicModElement basicModElement = this.getEmptyParent(obj.getKind());
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getParent"));
                }
                return basicModElement;
            }
            DasPath parentPath = DasPath.of(parent, this.myFamilyId, this.myPaths);
            BasicModElement element = this.myObjects.get(parentPath);
            if (element != null) {
                BasicModElement basicModElement = element;
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getParent"));
                }
                return basicModElement;
            }
            BasicModElement basicModElement = this.process(parent);
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getParent"));
            }
            return basicModElement;
        }

        @NotNull
        private BasicModElement getEmptyParent(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
            }
            BasicModElement element = this.myEmptyParents.get(kind);
            if (element != null) {
                BasicModElement basicModElement = element;
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            List path = (List)this.myMetaModel.getPathsToRoot(kind).first();
            if (!ContainerUtil.isEmpty((Collection)path) && path.get(0) == kind) {
                path = path.subList(1, path.size());
            }
            if (ContainerUtil.isEmpty((Collection)path)) {
                element = kind == ObjectKind.TABLE ? this.getRoot() : this.getEmptyParent(ObjectKind.TABLE);
                BasicModElement basicModElement = this.putEmptyParent(kind, element);
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            BasicModElement basicModElement = this.getEmptyParent(path, 0);
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
            }
            return basicModElement;
        }

        @NotNull
        private BasicModElement getEmptyParent(@NotNull List<ObjectKind> path, int idx) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
            }
            if (idx >= path.size()) {
                BasicModElement basicModElement = this.getRoot();
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            ObjectKind kind = path.get(idx);
            BasicModElement element = this.myEmptyParents.get(kind);
            if (element != null) {
                BasicModElement basicModElement = element;
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            BasicModElement parent = this.getEmptyParent(path, idx + 1);
            element = this.myEmptyParents.get(kind);
            if (element != null) {
                BasicModElement basicModElement = element;
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            Family family = parent.familyOf(kind);
            if (family == null) {
                BasicModElement basicModElement = this.putEmptyParent(kind, this.getRoot());
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            element = (BasicModElement)family.jbi().filter(DasUtil.byName((String)DasUtil.NO_NAME)).first();
            if (element != null) {
                BasicModElement basicModElement = this.putEmptyParent(kind, element);
                if (basicModElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
                }
                return basicModElement;
            }
            element = family.createNewOne();
            BasicModElement basicModElement = this.putEmptyParent(kind, element);
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getEmptyParent"));
            }
            return basicModElement;
        }

        @NotNull
        private BasicModElement putEmptyParent(@NotNull ObjectKind kind, @NotNull BasicModElement parent) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "putEmptyParent"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "putEmptyParent"));
            }
            this.myEmptyParents.put(kind, parent);
            BasicModElement basicModElement = parent;
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "putEmptyParent"));
            }
            return basicModElement;
        }

        @NotNull
        private BasicModElement getRoot() {
            BasicModElement basicModElement = (BasicModElement)((Object)this.myModel.getRoot());
            if (basicModElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "getRoot"));
            }
            return basicModElement;
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            HashMap res = ContainerUtil.newHashMap();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (Map.Entry<DasObject, DasPath> entry : this.myPaths.entrySet()) {
                BasicModElement target;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)entry.getKey(), SqlElement.class);
                if (object == null || (target = this.myObjects.get(entry.getValue())) == null) continue;
                res.put(target, pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            HashMap hashMap = res;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor", "reverseMap"));
            }
            return hashMap;
        }
    }
}

