/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternNode<Naming extends BaseNaming> {
    public static final Comparator<TreePatternNode<?>> BY_FIRST = (n1, n2) -> Comparing.compare((Comparable)((Comparable)ArrayUtil.getFirstElement((Object[])((BaseNaming)n1.naming).names)), (Comparable)((Comparable)ArrayUtil.getFirstElement((Object[])((BaseNaming)n2.naming).names)));
    public static final Group[] NO_GROUPS = new Group[0];
    public final Naming naming;
    @NotNull
    public final Group[] groups;

    public TreePatternNode(@NotNull Naming naming, @NotNull Group[] groups) {
        if (naming == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "naming", "com/intellij/sql/dialects/TreePatternNode", "<init>"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternNode", "<init>"));
        }
        this.naming = naming;
        this.groups = groups;
        assert (TreePatternUtils.isValid(this));
    }

    @Nullable
    public Group getGroup(@Nullable ObjectKind kind) {
        if (kind != null) {
            for (Group group2 : this.groups) {
                if (group2.kind != kind) continue;
                return group2;
            }
        }
        return null;
    }

    public boolean matchedChildren(@Nullable ObjectName name, @NotNull Casing casing, @NotNull ObjectKind kind, @NotNull List<TreePatternNode> matched) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/sql/dialects/TreePatternNode", "matchedChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternNode", "matchedChildren"));
        }
        if (matched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matched", "com/intellij/sql/dialects/TreePatternNode", "matchedChildren"));
        }
        Group group2 = this.getGroup(kind);
        return group2 != null && group2.matchedChildren(name, casing, matched);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePatternNode node = (TreePatternNode)o;
        if (!((BaseNaming)this.naming).equals(node.naming)) {
            return false;
        }
        return Arrays.equals(this.groups, node.groups);
    }

    public int hashCode() {
        int result2 = ((BaseNaming)this.naming).hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.groups);
        return result2;
    }

    public static class Group {
        public static final Comparator<Group> BY_KIND = (g1, g2) -> Comparing.compare((Comparable)g1.kind, (Comparable)g2.kind);
        public final ObjectKind kind;
        @Nullable
        public final TreePatternNode<PositiveNaming>[] positiveChildren;
        @Nullable
        public final TreePatternNode<NegativeNaming> negativeChild;
        private Integer myHashCode;

        public Group(@NotNull ObjectKind kind, @Nullable TreePatternNode<PositiveNaming>[] children, @Nullable TreePatternNode<NegativeNaming> antiPattern) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternNode$Group", "<init>"));
            }
            this.kind = kind;
            this.positiveChildren = children;
            this.negativeChild = antiPattern;
            assert (TreePatternUtils.isValid(this));
        }

        public boolean matchedChildren(@Nullable ObjectName name, @Nullable(value="exact match") Casing casing, @Nullable List<TreePatternNode> matched) {
            boolean m = false;
            if (this.positiveChildren != null) {
                for (TreePatternNode<PositiveNaming> child : this.positiveChildren) {
                    if (!((PositiveNaming)child.naming).matches(name, casing)) continue;
                    if (matched != null) {
                        matched.add(child);
                    }
                    m = true;
                }
            }
            if (this.negativeChild != null && ((NegativeNaming)this.negativeChild.naming).matches(name, casing)) {
                if (matched != null) {
                    matched.add(this.negativeChild);
                }
                m = true;
            }
            return m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group2 = (Group)o;
            if (group2.hashCode() != this.hashCode()) {
                return false;
            }
            if (!this.kind.equals(group2.kind)) {
                return false;
            }
            if (this.negativeChild != null ? !this.negativeChild.equals(group2.negativeChild) : group2.negativeChild != null) {
                return false;
            }
            return Arrays.equals(this.positiveChildren, group2.positiveChildren);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            int result2 = this.kind.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.positiveChildren);
            result2 = 31 * result2 + (this.negativeChild != null ? this.negativeChild.hashCode() : 0);
            this.myHashCode = result2;
            return this.myHashCode;
        }
    }

    public static class NegativeNaming
    extends BaseNaming {
        public static final NegativeNaming WILDCARD = new NegativeNaming(ObjectName.EMPTY_ARRAY);

        public NegativeNaming(ObjectName ... antiNames) {
            if (antiNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "antiNames", "com/intellij/sql/dialects/TreePatternNode$NegativeNaming", "<init>"));
            }
            super(antiNames);
        }

        @Override
        public boolean matches(@Nullable ObjectName name, @Nullable(value="exact match") Casing casing) {
            if (name == null) {
                return true;
            }
            if (casing == null) {
                return !ArrayUtil.contains((Object)name, (Object[])this.names);
            }
            for (ObjectName n : this.names) {
                if (!name.equals(n, casing)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ObjectName[] getAntiNames() {
            if (this.names == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternNode$NegativeNaming", "getAntiNames"));
            }
            return this.names;
        }

        public String toString() {
            return this.names.length == 0 ? "*" : "*, -" + StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", -");
        }
    }

    public static class PositiveNaming
    extends BaseNaming {
        public PositiveNaming(ObjectName ... names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternNode$PositiveNaming", "<init>"));
            }
            super(names);
            assert (names.length != 0) : "Empty positive naming";
        }

        @Override
        public boolean matches(@Nullable ObjectName name, @Nullable(value="exact match") Casing casing) {
            if (name == null) {
                return true;
            }
            if (casing == null) {
                return ArrayUtil.contains((Object)name, (Object[])this.names);
            }
            for (ObjectName n : this.names) {
                if (!name.equals(n, casing)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public ObjectName[] getNames() {
            if (this.names == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternNode$PositiveNaming", "getNames"));
            }
            return this.names;
        }

        public String toString() {
            return StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", ");
        }
    }

    public static abstract class BaseNaming {
        protected final ObjectName[] names;

        public BaseNaming(@NotNull ObjectName[] names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternNode$BaseNaming", "<init>"));
            }
            this.names = names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseNaming naming = (BaseNaming)o;
            return Arrays.equals(this.names, naming.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public abstract boolean matches(@Nullable ObjectName var1, @Nullable(value="exact match") Casing var2);
    }
}

