/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$1", "checkGroup"));
            }
            return true;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> ggroups) {
            return !1.containsNotNull(ggroups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$1", "checkNode"));
            }
            return true;
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$2", "checkGroup"));
            }
            return !2.containsNull(value);
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> ggroups) {
            return 2.containsNull(ggroups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$2", "checkNode"));
            }
            return true;
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$3", "checkNode"));
            }
            Iterator<TreePatternNode<?>> it = value.iterator();
            if (!it.hasNext()) {
                return false;
            }
            TreePatternNode<?> first = it.next();
            if (first == null) {
                return false;
            }
            while (it.hasNext()) {
                TreePatternNode<?> n = it.next();
                if (n == null || first.groups.length != 0 && n.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/sql/dialects/TreePatternUtils$3", "checkGroup"));
            }
            Iterator<TreePatternNode.Group> it = value.iterator();
            return it.hasNext() && it.next() != null;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
            for (TreePatternNode<?> group2 : nodes2) {
                if (group2 == null || group2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }
    };
    public static final TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null, null);

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        List list = ContainerUtil.collect(names.iterator());
        String[] stringArray = TreePatternUtils.toStringArray(list);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "toStringArray"));
        }
        return stringArray;
    }

    public static boolean isValid(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/sql/dialects/TreePatternUtils", "isValid"));
        }
        HashSet unique = ContainerUtil.newHashSet();
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                    assert (unique.add(name)) : "Duplicate `" + name + "` " + new TreePattern(g).toString();
                }
            }
        }
        if (g.negativeChild != null) {
            List<ObjectName> anti = Arrays.asList(((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
            assert (anti.containsAll(unique)) : "Neg. covers pos. `" + ContainerUtil.newArrayList((Iterable)unique).removeAll(anti) + "` " + new TreePattern(g).toString();
        }
        return true;
    }

    @NotNull
    public static Iterable<ObjectName> getSinkNames(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
        }
        if (g.negativeChild == null) {
            JBIterable jBIterable = JBIterable.of((Object[])g.positiveChildren).flatten(c -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c.naming).getNames()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
            }
            return jBIterable;
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet((Object[])((TreePatternNode.NegativeNaming)g.negativeChild.naming).getAntiNames());
        if (g.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : g.positiveChildren) {
                ContainerUtil.removeAll((Collection)res, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
            }
        }
        LinkedHashSet linkedHashSet = res;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "getSinkNames"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static TreePatternNode.NegativeNaming subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups, @NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> pSubdiv, @NotNull Collection<TreePatternNode<?>> nSubdiv, boolean mergeChildren) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        if (pSubdiv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pSubdiv", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        if (nSubdiv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nSubdiv", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        LinkedHashSet allNames = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode.Group group2 : groups) {
            if (group2 == null) continue;
            if (group2.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                    ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.PositiveNaming)child.naming).getNames());
                }
            }
            if (group2.negativeChild == null) continue;
            ContainerUtil.addAll((Collection)allNames, (Object[])((TreePatternNode.NegativeNaming)group2.negativeChild.naming).getAntiNames());
        }
        MultiMap broadSubdiv = mergeChildren ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        for (TreePatternNode.Group group3 : groups) {
            TreePatternNode<TreePatternNode.NegativeNaming> value;
            HashSet antiNames;
            if (group3 == null) {
                for (ObjectName name : allNames) {
                    broadSubdiv.putValue((Object)name, null);
                }
                nSubdiv.add(null);
                continue;
            }
            if (group3.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group3.positiveChildren) {
                    for (ObjectName name : ((TreePatternNode.PositiveNaming)child.naming).getNames()) {
                        broadSubdiv.putValue((Object)name, child);
                    }
                }
            }
            LinkedHashSet sinks = ContainerUtil.newLinkedHashSet(TreePatternUtils.getSinkNames(group3));
            if (group3.negativeChild != null) {
                for (ObjectName sink : sinks) {
                    broadSubdiv.putValue((Object)sink, null);
                }
                antiNames = ContainerUtil.newHashSet((Object[])((TreePatternNode.NegativeNaming)group3.negativeChild.naming).getAntiNames());
                value = group3.negativeChild;
            } else {
                antiNames = sinks;
                value = null;
            }
            for (ObjectName name : allNames) {
                if (antiNames.contains(name)) continue;
                broadSubdiv.putValue((Object)name, value);
            }
            nSubdiv.add(value);
        }
        MultiMap multiMap = MultiMap.createLinkedSet();
        for (Map.Entry entry : broadSubdiv.entrySet()) {
            multiMap.putValue(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            pSubdiv.put((Object)new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)((Iterable)entry.getValue()))), (Collection)entry.getKey());
        }
        TreePatternNode.NegativeNaming negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)broadSubdiv.keySet()));
        if (negativeNaming == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "subdivideChildren"));
        }
        return negativeNaming;
    }

    @Nullable
    private static TreePatternNode.Group processGrouped(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups, @NotNull GroupedGroupFactory fac) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils", "processGrouped"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "processGrouped"));
        }
        if (fac == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fac", "com/intellij/sql/dialects/TreePatternUtils", "processGrouped"));
        }
        LinkedHashSet grouped = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet(groups) : groups;
        MultiMap positive = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        SequencedCollection negative = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newSmartList();
        TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren(grouped, positive, negative, fac.mergeChildren());
        return fac.create(positive, negativeNaming, negative, kind);
    }

    public static boolean isValid(TreePatternNode node) {
        HashSet kinds = ContainerUtil.newHashSet();
        for (TreePatternNode.Group group2 : node.groups) {
            if (kinds.add(group2.kind)) continue;
            return false;
        }
        return true;
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group2, int depth) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group2.kind).append("\n");
        JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild).forEach(n -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "lambda$print$1"));
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    public static void print(@NotNull StringBuilder builder, @NotNull TreePatternNode<?> node, int depth) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/TreePatternUtils", "print"));
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node.naming).append("\n");
        JBIterable.of((Object[])node.groups).forEach(n -> {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/dialects/TreePatternUtils", "lambda$print$2"));
            }
            TreePatternUtils.print(builder, n, depth + 1);
        });
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups, boolean preserveOthers, @Nullable TreePatternNode.Group res, int pos) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "preserve"));
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res == null ? groups : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups, (Object)res);
            } else if (res == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res;
            }
            return groupArray;
        }
        if (res == null) {
            return preserveOthers && groups.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups.clone();
        clone[pos] = res;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i2, boolean preserveOthers) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (i2 >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i2];
        int idx = -1;
        for (int k = 0; k < groups.length; ++k) {
            if (groups[k].kind != kinds[i2]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res = null;
            if (wildcard) {
                TreePatternNode.Group[] children = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i2 + 1, preserveOthers);
                res = children == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children));
            }
            return TreePatternUtils.preserve(groups, preserveOthers, res, -1);
        }
        TreePatternNode.Group group2 = groups[idx];
        if (!wildcard) {
            TreePatternNode.Group[] masked;
            MultiMap positive = MultiMap.createLinkedSet();
            if (group2.positiveChildren != null) {
                for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                    TreePatternNode.Group[] masked2 = TreePatternUtils.mask(child.groups, kinds, mask, i2 + 1, preserveOthers);
                    if (masked2 == null) continue;
                    positive.putValue(new AW<TreePatternNode.Group>(masked2), child.naming);
                }
            }
            TreePatternNode<Object> negChild = null;
            if (group2.negativeChild != null && (masked = TreePatternUtils.mask(group2.negativeChild.groups, kinds, mask, i2 + 1, preserveOthers)) != null) {
                Collection removed = positive.remove(new AW<TreePatternNode.Group>(masked));
                if (removed != null) {
                    ArrayList names = ContainerUtil.newArrayList((Object[])((TreePatternNode.NegativeNaming)group2.negativeChild.naming).getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : removed) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negChild = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names)), masked);
                } else {
                    negChild = new TreePatternNode(group2.negativeChild.naming, masked);
                }
            }
            TreePatternNode.Group result2 = null;
            if (negChild != null || !positive.isEmpty()) {
                TreePatternNode[] res;
                TreePatternNode[] treePatternNodeArray = res = positive.isEmpty() ? null : new TreePatternNode[positive.size()];
                if (res != null) {
                    int k = 0;
                    for (Map.Entry entry : positive.entrySet()) {
                        res[k] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)JBIterable.from((Iterable)((Iterable)entry.getValue())).flatten(x -> JBIterable.of((Object[])x.getNames())))), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        ++k;
                    }
                }
                result2 = new TreePatternNode.Group(kinds[i2], res, negChild);
            }
            return TreePatternUtils.preserve(groups, preserveOthers, result2, idx);
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet();
        for (TreePatternNode node : JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node.groups, kinds, mask, i2 + 1, preserveOthers);
            if (grouped == null) continue;
            res.add(new TreePatternNode(node.naming, grouped));
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.mergeRoots(res);
        TreePatternNode.Group result3 = merged == null ? null : new TreePatternNode.Group(kinds[i2], null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, merged));
        return TreePatternUtils.preserve(groups, preserveOthers, result3, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        TreePattern treePattern = TreePatternUtils.union(Arrays.asList(patterns));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        TreePattern treePattern = UNION_PROCESSOR.merge(patterns);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "union"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "intersect"));
        }
        TreePattern treePattern = INTERSECTION_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "intersect"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils", "minus"));
        }
        TreePattern treePattern = MINUS_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "minus"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        TreePattern treePattern = new TreePattern(TreePatternUtils.mask(pattern.root.groups, kinds, mask, 0, preserveOthers));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "mask"));
        }
        return treePattern;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        TreePatternNode.Group group2 = TreePatternUtils.create(name == null ? null : Collections.singletonList(name), kind, children);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        return group2;
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        if (children == null) {
            children = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children.length) {
            if (nonNulls == 0) {
                children = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children2 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children) {
                    if (child == null) continue;
                    children2[nonNulls++] = child;
                }
                children = children2;
            }
        }
        TreePatternNode.Group res = names == null ? new TreePatternNode.Group(kind, null, new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children)) : new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray(names)), children)}, null);
        TreePatternNode.Group group2 = res;
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "create"));
        }
        return group2;
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor) {
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mask", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        TreePatternNode.Group[] newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode<?> node, @Nullable TreePatternNode<?> checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return node == null ? null : node.groups;
                }
                NodeBuilder b = null;
                LinkedHashMap newGroups = ContainerUtil.newLinkedHashMap();
                for (TreePatternNode.Group group2 : checker.groups) {
                    newGroups.put(group2.kind, group2);
                }
                if (node != null) {
                    for (int i2 = 0; i2 < node.groups.length; ++i2) {
                        TreePatternNode.Group group3 = node.groups[i2];
                        newGroups.remove(group3.kind);
                        TreePatternNode.Group checkerGroup = checker.getGroup(group3.kind);
                        processed = group3;
                        if (checkerGroup != null) {
                            processed = this.visit(group3, checkerGroup, parent, parentKind);
                        }
                        if (processed != group3 && b == null) {
                            b = new NodeBuilder();
                            for (int k = 0; k < i2; ++k) {
                                b.addGroup(node.groups[k]);
                            }
                        }
                        if (b == null || processed == null) continue;
                        b.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group4;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group4.kind, null, null);
                    group4 = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group4, parent, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b == null) {
                        b = NodeBuilder.from(node);
                    }
                    b.addGroup(processed);
                }
                return b == null ? (node == null ? null : node.groups) : b.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group2, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode n2;
                if (group2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils$4", "visit"));
                }
                if (checker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/sql/dialects/TreePatternUtils$4", "visit"));
                }
                TreePatternNode.Group procRes = processor.process(group2, parent, parentKind);
                if (procRes == SKIP_PROCESSING) {
                    return group2;
                }
                if (procRes == null) {
                    return null;
                }
                group2 = procRes;
                MultiMap gluedPositive = MultiMap.createLinked();
                MultiMap p = MultiMap.createLinked();
                List n = ContainerUtil.newSmartList();
                TreePatternNode.NegativeNaming negativeNaming = TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group2, checker}), p, n, false);
                for (Map.Entry entry : p.entrySet()) {
                    Iterator it = ((Collection)entry.getValue()).iterator();
                    TreePatternNode p1 = (TreePatternNode)it.next();
                    TreePatternNode p2 = (TreePatternNode)it.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p2, (TreePatternNode.BaseNaming)entry.getKey(), group2.kind);
                    gluedPositive.putValue(new AW<TreePatternNode.Group>(processed), entry.getKey());
                }
                Iterator it = n.iterator();
                TreePatternNode n1 = (TreePatternNode)it.next();
                TreePatternNode.Group[] processedNegative = this.visit(n1, n2 = (TreePatternNode)it.next(), (TreePatternNode.BaseNaming)negativeNaming, group2.kind);
                Collection extra = gluedPositive.remove(new AW<TreePatternNode.Group>(processedNegative));
                if (extra != null) {
                    LinkedHashSet names = ContainerUtil.newLinkedHashSet((Object[])negativeNaming.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : extra) {
                        ContainerUtil.removeAll((Collection)names, (Object[])naming.getNames());
                    }
                    negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)names));
                }
                return this.createNewIfChanged(group2, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming>)gluedPositive, processedNegative, negativeNaming);
            }

            private TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group2, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.PositiveNaming> positive, @Nullable TreePatternNode.Group[] negative, @NotNull TreePatternNode.NegativeNaming negativeNaming) {
                if (group2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                if (positive == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positive", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                if (negativeNaming == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "negativeNaming", "com/intellij/sql/dialects/TreePatternUtils$4", "createNewIfChanged"));
                }
                HashMap pool = ContainerUtil.newHashMap();
                if (group2.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                        pool.put(child.naming, child);
                    }
                }
                boolean changed = false;
                GroupBuilder builder = new GroupBuilder();
                if (negative != null) {
                    if (group2.negativeChild != null && negativeNaming.equals(group2.negativeChild.naming) && Arrays.equals(group2.negativeChild.groups, negative)) {
                        builder.negative = group2.negativeChild;
                    } else {
                        changed = true;
                        builder.negative = new TreePatternNode<TreePatternNode.NegativeNaming>(negativeNaming, negative);
                    }
                } else {
                    changed = group2.negativeChild != null;
                }
                changed |= pool.size() != positive.size();
                for (Map.Entry entry : positive.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    for (TreePatternNode.PositiveNaming naming : (Collection)entry.getValue()) {
                        ContainerUtil.addAll((Collection)names, (Object[])naming.getNames());
                    }
                    TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names));
                    TreePatternNode node = (TreePatternNode)pool.get(naming);
                    if (node == null || node.groups != ((AW)entry.getKey()).array) {
                        changed = true;
                        node = ((AW)entry.getKey()).array == null ? null : new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    }
                    ContainerUtil.addIfNotNull(builder.positives, (Object)node);
                }
                return changed ? builder.build(group2.kind) : group2;
            }
        }.visit(processed.root, mask.root, null, null);
        TreePattern treePattern = newRoot == processed.root.groups ? processed : new TreePattern(newRoot);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "patternProcessor"));
        }
        return treePattern;
    }

    public static boolean isWildcard(@Nullable TreePatternNode.Group g) {
        return g != null && g.positiveChildren == null && TreePatternUtils.isWildcard(g.negativeChild);
    }

    public static boolean isWildcard(@Nullable TreePatternNode<?> n) {
        return n != null && ((TreePatternNode.BaseNaming)n.naming).names.length == 0 && n.groups.length == 0;
    }

    @NotNull
    public static TreePattern sorted(@NotNull TreePattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        TreePatternNode<TreePatternNode.NegativeNaming> sortedRoot = TreePatternUtils.sorted(pattern.root);
        TreePattern treePattern = sortedRoot == pattern.root ? pattern : new TreePattern(sortedRoot);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        return treePattern;
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> TreePatternNode<N> sorted(@NotNull TreePatternNode<N> node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        TreePatternNode.Group[] newGroups = TreePatternUtils.sorted(node.groups, TreePatternNode.Group.BY_KIND);
        Object naming = TreePatternUtils.sorted(node.naming);
        TreePatternNode<N> treePatternNode = newGroups == node.groups && naming == node.naming ? node : new TreePatternNode<N>(naming, newGroups);
        if (treePatternNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        return treePatternNode;
    }

    @NotNull
    private static <T> T[] sorted(T[] items, Comparator comp) {
        Object[] newItems = null;
        boolean unsorted = false;
        for (int i2 = 0; i2 < items.length; ++i2) {
            Object newItem;
            Object object = newItem = items[i2] instanceof TreePatternNode.Group ? TreePatternUtils.sorted((TreePatternNode.Group)items[i2]) : TreePatternUtils.sorted((TreePatternNode)items[i2]);
            if (!unsorted && i2 != 0) {
                boolean bl = unsorted = comp.compare(items[i2 - 1], items[i2]) > 0;
            }
            if (newItems == null) {
                if (newItem == items[i2] && !unsorted) continue;
                newItems = (Object[])Array.newInstance(items[i2].getClass(), items.length);
                System.arraycopy(items, 0, newItems, 0, i2);
            }
            newItems[i2] = newItem;
        }
        if (unsorted) {
            Arrays.sort(newItems, comp);
        }
        Object[] objectArray = newItems == null ? items : newItems;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        return objectArray;
    }

    @NotNull
    private static TreePatternNode.NegativeNaming merge(@NotNull TreePatternNode.NegativeNaming neg, @NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (neg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "neg", "com/intellij/sql/dialects/TreePatternUtils", "merge"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/sql/dialects/TreePatternUtils", "merge"));
        }
        LinkedHashSet names = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])neg.getAntiNames());
            }
            ContainerUtil.removeAll((Collection)names, (Object[])naming.names);
        }
        TreePatternNode.NegativeNaming negativeNaming = names == null ? neg : new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
        if (negativeNaming == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "merge"));
        }
        return negativeNaming;
    }

    @Nullable
    private static TreePatternNode.PositiveNaming merge(@NotNull Iterable<TreePatternNode.PositiveNaming> pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/sql/dialects/TreePatternUtils", "merge"));
        }
        LinkedHashSet names = null;
        TreePatternNode.PositiveNaming first = null;
        for (TreePatternNode.PositiveNaming naming : pos) {
            if (first == null) {
                first = naming;
                continue;
            }
            if (names == null) {
                names = ContainerUtil.newLinkedHashSet((Object[])first.names);
            }
            ContainerUtil.addAll((Collection)names, (Object[])naming.names);
        }
        if (names == null) {
            return first;
        }
        Object[] res = ObjectName.toArray(names);
        Arrays.sort(res);
        return new TreePatternNode.PositiveNaming((ObjectName[])res);
    }

    @NotNull
    private static TreePatternNode.Group sorted(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> nodes2 = Pair.create(g.negativeChild == null ? null : TreePatternUtils.sorted(g.negativeChild), g.positiveChildren == null ? null : TreePatternUtils.sorted(g.positiveChildren, TreePatternNode.BY_FIRST));
        nodes2 = TreePatternUtils.tighten((TreePatternNode)nodes2.first, (TreePatternNode[])nodes2.second);
        TreePatternNode.Group group2 = nodes2.first == g.negativeChild && nodes2.second == g.positiveChildren ? g : new TreePatternNode.Group(g.kind, (TreePatternNode[])nodes2.second, (TreePatternNode)nodes2.first);
        if (group2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        return group2;
    }

    @NotNull
    private static Pair<TreePatternNode<TreePatternNode.NegativeNaming>, TreePatternNode<TreePatternNode.PositiveNaming>[]> tighten(@Nullable TreePatternNode<TreePatternNode.NegativeNaming> n, @Nullable TreePatternNode<TreePatternNode.PositiveNaming>[] p) {
        Collection nodes2;
        if (p == null) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "tighten"));
            }
            return pair;
        }
        MultiMap groupping = MultiMap.createLinked();
        for (TreePatternNode<TreePatternNode.PositiveNaming> node2 : p) {
            groupping.putValue(new AW<TreePatternNode.Group>(node2.groups), node2);
        }
        if (n != null && (nodes2 = groupping.remove(new AW<TreePatternNode.Group>(n.groups))) != null) {
            n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternUtils.merge((TreePatternNode.NegativeNaming)n.naming, (Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)nodes2).transform(node -> (TreePatternNode.PositiveNaming)node.naming)), n.groups);
        }
        if (p.length == groupping.size()) {
            Pair pair = Pair.create(n, p);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "tighten"));
            }
            return pair;
        }
        if (groupping.isEmpty()) {
            Pair pair = Pair.create(n, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "tighten"));
            }
            return pair;
        }
        ArrayList pos = ContainerUtil.newArrayListWithCapacity((int)groupping.size());
        for (Map.Entry entry : groupping.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                pos.add(ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                continue;
            }
            TreePatternNode.PositiveNaming naming = TreePatternUtils.merge((Iterable<TreePatternNode.PositiveNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).transform(node -> (TreePatternNode.PositiveNaming)node.naming));
            if (naming == null) continue;
            pos.add(new TreePatternNode<TreePatternNode.PositiveNaming>(naming, (TreePatternNode.Group[])ObjectUtils.assertNotNull(((AW)entry.getKey()).array)));
        }
        p = pos.toArray(new TreePatternNode[pos.size()]);
        Pair pair = Pair.create(n, p);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "tighten"));
        }
        return pair;
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> N sorted(@NotNull N naming) {
        if (naming == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "naming", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        boolean unsorted = false;
        ObjectName[] names = naming.names;
        int s = names.length;
        for (int i2 = 1; i2 < s && !unsorted; ++i2) {
            unsorted = names[i2 - 1].compareTo(names[i2]) > 0;
        }
        if (!unsorted) {
            N n = naming;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
            }
            return n;
        }
        Object[] newNames = new ObjectName[names.length];
        System.arraycopy(names, 0, newNames, 0, names.length);
        Arrays.sort(newNames);
        TreePatternNode.BaseNaming baseNaming = naming instanceof TreePatternNode.NegativeNaming ? new TreePatternNode.NegativeNaming((ObjectName[])newNames) : new TreePatternNode.PositiveNaming((ObjectName[])newNames);
        if (baseNaming == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils", "sorted"));
        }
        return (N)baseNaming;
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static class NodeBuilder {
        public final List<TreePatternNode.Group> groups = ContainerUtil.newSmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g) {
            if (g != null) {
                this.groups.add(g);
            }
            return this;
        }

        @NotNull
        public <T extends TreePatternNode.BaseNaming> TreePatternNode<T> build(T naming) {
            TreePatternNode<T> treePatternNode = new TreePatternNode<T>(naming, this.buildGroups());
            if (treePatternNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "build"));
            }
            return treePatternNode;
        }

        @Nullable
        public TreePatternNode.Group[] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[this.groups.size()]);
        }

        @NotNull
        public TreePatternNode.Group[] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "buildGroups"));
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode<?> node) {
            NodeBuilder nodeBuilder = NodeBuilder.from(node == null ? null : node.groups);
            if (nodeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "from"));
            }
            return nodeBuilder;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups) {
            NodeBuilder b = new NodeBuilder();
            if (groups != null) {
                ContainerUtil.addAll(b.groups, (Object[])groups);
            }
            NodeBuilder nodeBuilder = b;
            if (nodeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$NodeBuilder", "from"));
            }
            return nodeBuilder;
        }
    }

    public static class GroupBuilder {
        public final List<TreePatternNode<TreePatternNode.PositiveNaming>> positives = ContainerUtil.newSmartList();
        public TreePatternNode<TreePatternNode.NegativeNaming> negative = null;

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder", "build"));
            }
            TreePatternNode[] p = this.positives.isEmpty() ? null : this.positives.toArray(new TreePatternNode[this.positives.size()]);
            return p == null && this.negative == null ? null : new TreePatternNode.Group(kind, p, this.negative);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g) {
            GroupBuilder builder = new GroupBuilder();
            if (g != null) {
                if (g.positiveChildren != null) {
                    ContainerUtil.addAll(builder.positives, (Object[])g.positiveChildren);
                }
                builder.negative = g.negativeChild;
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$GroupBuilder", "from"));
            }
            return groupBuilder;
        }
    }

    public static abstract class GroupedGroupFactory {
        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.PositiveNaming, TreePatternNode<?>> p, @NotNull TreePatternNode.NegativeNaming nn, @NotNull Iterable<TreePatternNode<?>> n, ObjectKind kind) {
            TreePatternNode[] positive;
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            if (nn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nn", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            if (n == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "create"));
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : p.entrySet()) {
                TreePatternNode.Group[] merged = this.mergeNodes((TreePatternNode.BaseNaming)entry.getKey(), kind, (Iterable)entry.getValue());
                if (merged == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), entry.getKey());
            }
            TreePatternNode.Group[] negGroups = this.mergeNodes(nn, kind, n);
            if (mergedBranches.isEmpty() && negGroups == null) {
                return null;
            }
            TreePatternNode<TreePatternNode.NegativeNaming> negative = null;
            if (negGroups != null) {
                Collection namings = mergedBranches.remove(new AW<TreePatternNode.Group>(negGroups));
                if (namings != null) {
                    ArrayList antiNames = ContainerUtil.newArrayList((Object[])nn.getAntiNames());
                    for (TreePatternNode.PositiveNaming naming : namings) {
                        ContainerUtil.removeAll((Collection)antiNames, (Object[])naming.getNames());
                    }
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)antiNames)), negGroups);
                } else {
                    negative = new TreePatternNode<TreePatternNode.NegativeNaming>(nn, negGroups);
                }
            }
            TreePatternNode[] treePatternNodeArray = positive = mergedBranches.isEmpty() ? null : new TreePatternNode[mergedBranches.size()];
            if (positive != null) {
                int i2 = 0;
                for (Map.Entry entry : mergedBranches.entrySet()) {
                    List names = ContainerUtil.newSmartList();
                    ((Collection)entry.getValue()).forEach(x -> {
                        List cfr_ignored_0 = (List)ContainerUtil.addAll((Collection)names, (Object[])x.getNames());
                    });
                    positive[i2] = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)names)), (TreePatternNode.Group[])((AW)entry.getKey()).array);
                    ++i2;
                }
            }
            return new TreePatternNode.Group(kind, positive, negative);
        }

        @Nullable
        public TreePatternNode.Group[] mergeNodes(@Nullable TreePatternNode.BaseNaming naming, @Nullable ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "mergeNodes"));
            }
            this.enter(naming, kind, nodes2);
            if (!this.checkNode(naming, kind, nodes2)) {
                this.leave(naming, kind, nodes2);
                return null;
            }
            MultiMap grouped = this.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            LinkedHashSet allKinds = ContainerUtil.newLinkedHashSet();
            for (TreePatternNode<?> node : nodes2) {
                if (node == null) continue;
                for (TreePatternNode.Group group2 : node.groups) {
                    allKinds.add(group2.kind);
                }
            }
            for (TreePatternNode<?> node : nodes2) {
                HashSet currentKinds = null;
                if (node != null) {
                    currentKinds = ContainerUtil.newHashSet();
                    for (TreePatternNode.Group group3 : node.groups) {
                        grouped.putValue((Object)group3.kind, (Object)group3);
                        currentKinds.add(group3.kind);
                    }
                }
                for (ObjectKind gkind : allKinds) {
                    if (currentKinds != null && currentKinds.contains(gkind)) continue;
                    grouped.putValue((Object)gkind, null);
                }
            }
            List res = ContainerUtil.newSmartList();
            for (Map.Entry entry : grouped.entrySet()) {
                this.enterGroups(naming, kind, (Iterable)entry.getValue());
                if (this.checkGroup(naming, kind, (Iterable)entry.getValue())) {
                    ContainerUtil.addAllNotNull((Collection)res, (Object[])new TreePatternNode.Group[]{TreePatternUtils.processGrouped((ObjectKind)entry.getKey(), (Iterable)entry.getValue(), this)});
                }
                this.leaveGroups(naming, kind, (Iterable)entry.getValue());
            }
            TreePatternNode.Group[] merged = !res.isEmpty() ? res.toArray(new TreePatternNode.Group[res.size()]) : (this.willDestroyEmpty(naming, kind, nodes2) ? null : TreePatternNode.NO_GROUPS);
            this.leave(naming, kind, nodes2);
            return merged;
        }

        @NotNull
        public TreePattern merge(@NotNull Iterable<TreePattern> patterns) {
            if (patterns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "merge"));
            }
            TreePatternNode.Group[] groups = this.mergeRoots((Iterable<TreePatternNode<?>>)JBIterable.from(patterns).transform(p -> p.root));
            TreePattern treePattern = groups == null ? TreePattern.EMPTY : new TreePattern(groups);
            if (treePattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "merge"));
            }
            return treePattern;
        }

        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode<?>> nodes2) {
            if (nodes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "mergeRoots"));
            }
            return this.mergeNodes(TreePatternNode.NegativeNaming.WILDCARD, ObjectKind.NONE, nodes2);
        }

        @Nullable
        public TreePatternNode.Group mergeGroups(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "mergeGroups"));
            }
            if (groups == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternUtils$GroupedGroupFactory", "mergeGroups"));
            }
            return TreePatternUtils.processGrouped(kind, groups, this);
        }

        protected abstract boolean checkGroup(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode.Group> var3);

        protected abstract boolean checkNode(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode<?>> var3);

        protected abstract boolean willDestroyEmpty(TreePatternNode.BaseNaming var1, ObjectKind var2, Iterable<TreePatternNode<?>> var3);

        protected void enter(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void leave(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> nodes2) {
        }

        protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        public boolean mergeChildren() {
            return true;
        }

        protected static boolean containsNull(Iterable it) {
            if (it instanceof Collection) {
                return ((Collection)it).contains(null);
            }
            for (Object o : it) {
                if (o != null) continue;
                return true;
            }
            return false;
        }

        protected static boolean containsNotNull(Iterable it) {
            for (Object o : it) {
                if (o == null) continue;
                return true;
            }
            return false;
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        public AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AW aw = (AW)o;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }
}

