/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.database.util.DbUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.FunToken;
import com.intellij.sql.dialects.functions.FunctionLexer;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionDefinitionParser {
    private static final Logger LOG = Logger.getInstance((String)SqlFunctionDefinitionParser.class.getName());
    private static final String NAME_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "name"});
    private static final String NAME_ATTR_LOCATION1 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function"});
    private static final String NAME_ATTR_LOCATION2 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private static final String PROTOTYPE_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "prototype"});
    private static final String PROTOTYPE_MACRO_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private final FunctionLexer myLexer;
    private final SqlLanguageDialectEx myDialect;
    private final Map<String, SqlFunctionDefinition.Parameter[]> myCustomMap;

    public SqlFunctionDefinitionParser(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/functions/SqlFunctionDefinitionParser", "<init>"));
        }
        this.myCustomMap = new THashMap();
        this.myDialect = dialect;
        this.myLexer = new FunctionLexer();
    }

    public List<SqlFunctionDefinition> parse(String text) {
        return this.parseXmlFormat(text);
    }

    private List<SqlFunctionDefinition> parseXmlFormat(String text) {
        final ArrayList list = ContainerUtil.newArrayList();
        NanoXmlUtil.parse((Reader)new StringReader(text), (IXMLBuilder)new NanoXmlUtil.BaseXmlBuilder(){
            final List<SqlFunctionDefinition.Prototype> myPrototypes = ContainerUtil.newArrayList();
            final List<String> myNames = ContainerUtil.newArrayList();
            final HashMap<String, String> myDialectAttrs = ContainerUtil.newHashMap();
            final HashMap<String, String> myPrototypeAttrs = ContainerUtil.newHashMap();
            int myPrototypeId = 0;
            String myCurPCDataLocation;
            StringBuilder myCurPCData = new StringBuilder();

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                super.startElement(name, nsPrefix, nsURI, systemID, lineNr);
                if ("function".equals(name) || "macro".equals(name)) {
                    this.myPrototypes.clear();
                    this.myNames.clear();
                    this.myDialectAttrs.clear();
                    this.myPrototypeId = 0;
                } else if ("prototype".equals(name)) {
                    this.myPrototypeAttrs.clear();
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                boolean macro = false;
                String functionName = (String)ContainerUtil.getFirstItem(this.myNames);
                if (NAME_LOCATION.equals(this.myCurPCDataLocation)) {
                    this.myNames.add(this.myCurPCData.toString());
                } else if (PROTOTYPE_LOCATION.equals(this.myCurPCDataLocation) || (macro = PROTOTYPE_MACRO_LOCATION.equals(this.myCurPCDataLocation))) {
                    SqlFunctionDefinition.Type returnType;
                    SqlFunctionDefinition.Parameter[] params2;
                    SqlFunctionDefinitionParser.this.myLexer.start(this.myCurPCData, 0, this.myCurPCData.length(), 2);
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.LEFT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, "( expected");
                    }
                    if ((params2 = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE)) == null) {
                        SqlFunctionDefinitionParser.this.error(functionName, "params not parsed");
                    }
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.RIGHT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, ") expected");
                    }
                    SqlFunctionDefinition.ParameterBlock tailBlock = null;
                    if (!macro && SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.COLON)) {
                        SqlFunctionDefinition.Parameter[] tail;
                        String typeText = SqlFunctionDefinitionParser.this.consumeTypeName();
                        returnType = SqlFunctionDefinitionParser.this.findType(typeText);
                        if (returnType == null) {
                            SqlFunctionDefinitionParser.this.error(functionName, typeText + " type not found");
                            returnType = SqlFunctionDefinition.ANY;
                        }
                        if ((tail = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE)) != null && tail.length > 0) {
                            tailBlock = new SqlFunctionDefinition.ParameterBlock(this.myPrototypeId, SqlFunctionDefinition.ParameterBlockType.SEQUENCE, tail, false);
                        }
                    } else {
                        if (!macro) {
                            SqlFunctionDefinitionParser.this.error(functionName, ":<type> expected");
                        }
                        returnType = SqlFunctionDefinition.ANY;
                    }
                    if (params2 != null) {
                        SmartFMap attributes = SmartFMap.emptyMap().plusAll(this.myPrototypeAttrs);
                        this.myPrototypes.add(new SqlFunctionDefinition.Prototype(null, returnType, this.myPrototypeId++, params2, tailBlock, (Map<String, String>)attributes));
                    }
                }
                this.myCurPCData.setLength(0);
                this.myCurPCDataLocation = null;
                if (name.equals("function") || (macro = name.equals("macro"))) {
                    LinkedHashMap<String, String> dialectAttrs = this.myDialectAttrs.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.myDialectAttrs);
                    for (String alias : this.myNames) {
                        if (!macro) {
                            list.add(new SqlFunctionDefinition(DbUtil.intern((String)alias), DbUtil.intern((String)this.myNames.get(0)), dialectAttrs, this.myPrototypes));
                            continue;
                        }
                        if (this.myPrototypes.size() != 1) {
                            SqlFunctionDefinitionParser.this.error(functionName, "macro body not found");
                            continue;
                        }
                        SqlFunctionDefinitionParser.this.myCustomMap.put(alias, this.myPrototypes.get(0).getParams());
                    }
                }
                super.endElement(name, nsPrefix, nsURI);
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                String location = this.getLocation();
                if (PROTOTYPE_LOCATION.equals(location) && "id".equals(key)) {
                    this.myPrototypeId = Integer.parseInt(value);
                } else if ((NAME_ATTR_LOCATION1.equals(location) || NAME_ATTR_LOCATION2.equals(location)) && "name".equals(key)) {
                    this.myNames.add(DbUtil.intern((String)value));
                } else if (NAME_ATTR_LOCATION1.equals(location)) {
                    this.myDialectAttrs.put(DbUtil.intern((String)key), DbUtil.intern((String)value));
                } else if (PROTOTYPE_LOCATION.equals(location)) {
                    this.myPrototypeAttrs.put(DbUtil.intern((String)key), DbUtil.intern((String)value));
                }
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                String location = this.getLocation();
                String text = 1.readText((Reader)reader);
                if (!location.equals(this.myCurPCDataLocation)) {
                    this.myCurPCData.setLength(0);
                    this.myCurPCData.append(text);
                    this.myCurPCDataLocation = location;
                } else {
                    this.myCurPCData.append(text);
                }
            }
        });
        return list;
    }

    @Nullable
    private <T> T error(String functionName, @NonNls String message) {
        CharSequence seq = this.myLexer.getBufferSequence();
        int SPACE = 20;
        int pos = this.myLexer.getTokenStart();
        int offset = Math.max(0, pos - SPACE);
        String context = seq.subSequence(offset, Math.min(this.myLexer.getTokenEnd() + SPACE, this.myLexer.getBufferEnd())).toString();
        LOG.error(functionName + " [" + pos + "]: " + message + "\n    curToken = " + this.getTokenType() + "\n    curTokenText = '" + this.getTokenText() + "'\n    context = '" + context + "'\n    ___________" + StringUtil.repeat((String)"_", (int)(pos - offset)) + "^");
        return null;
    }

    @Nullable
    private SqlFunctionDefinition.Parameter[] parseParameterList(int prototypeId, String functionName, SqlFunctionDefinition.ParameterBlockType currentBlockType) {
        IElementType curType;
        FunToken separator;
        ArrayList result2 = ContainerUtil.newArrayList();
        FunToken funToken = separator = currentBlockType == SqlFunctionDefinition.ParameterBlockType.CHOICE ? FunToken.BAR : FunToken.COMMA;
        while ((curType = this.getTokenType()) != FunToken.RIGHT_PAREN && curType != FunToken.RIGHT_BRACKET && curType != FunToken.RIGHT_BRACE) {
            if (currentBlockType == SqlFunctionDefinition.ParameterBlockType.CHOICE) {
                SqlFunctionDefinition.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, SqlFunctionDefinition.ParameterBlockType.SEQUENCE);
                if (parameters == null || parameters.length == 0) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, "no parameters");
                }
                if (parameters.length == 1) {
                    result2.add(parameters[0]);
                } else {
                    result2.add(new SqlFunctionDefinition.ParameterBlock(prototypeId, SqlFunctionDefinition.ParameterBlockType.SEQUENCE, parameters, false));
                }
            } else if (curType == FunToken.LEFT_PAREN || curType == FunToken.LEFT_BRACKET || curType == FunToken.LEFT_BRACE) {
                FunToken closingType;
                this.advanceLexer();
                SqlFunctionDefinition.ParameterBlockType parameterBlockType = curType == FunToken.LEFT_PAREN ? SqlFunctionDefinition.ParameterBlockType.SEQUENCE : (curType == FunToken.LEFT_BRACKET ? SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE : SqlFunctionDefinition.ParameterBlockType.CHOICE);
                SqlFunctionDefinition.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, parameterBlockType);
                if (parameters == null) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, "no parameters");
                }
                FunToken funToken2 = curType == FunToken.LEFT_PAREN ? FunToken.RIGHT_PAREN : (closingType = curType == FunToken.LEFT_BRACKET ? FunToken.RIGHT_BRACKET : FunToken.RIGHT_BRACE);
                if (!this.consumeToken(true, closingType)) {
                    return (SqlFunctionDefinition.Parameter[])this.error(functionName, (Object)((Object)closingType) + " expected");
                }
                result2.add(new SqlFunctionDefinition.ParameterBlock(prototypeId, parameterBlockType, parameters, this.consumeToken(true, FunToken.ELLIPSIS)));
            } else if (curType == FunToken.COMMA) {
                this.advanceLexer();
                result2.add(SqlFunctionDefinition.COMMA);
            } else if (curType == FunToken.SYNTAX) {
                String tokenText = this.getTokenText();
                assert (tokenText != null);
                result2.add(new SqlFunctionDefinition.SyntaxParameter(prototypeId, tokenText.startsWith("\\") ? tokenText.substring(1) : tokenText));
                this.advanceLexer();
            } else {
                if (curType != FunToken.IDENT) break;
                String name = this.consumeTokenText(true, FunToken.IDENT);
                boolean colon = this.consumeToken(true, FunToken.COLON);
                String typeName = colon ? this.consumeTypeName() : null;
                SqlFunctionDefinition.Type type = this.findType(typeName);
                if (type == null) {
                    if (colon) {
                        return (SqlFunctionDefinition.Parameter[])this.error(functionName, typeName + " type not found");
                    }
                    SqlFunctionDefinition.Parameter[] parameters = this.myCustomMap.get(name);
                    if (parameters != null) {
                        for (SqlFunctionDefinition.Parameter parameter : parameters) {
                            result2.add(parameter.copyWithPrototype(prototypeId));
                        }
                    } else {
                        result2.add(new SqlFunctionDefinition.Keyword(prototypeId, name));
                    }
                } else {
                    String refTypeName = type == SqlFunctionDefinition.REF && this.consumeToken(true, FunToken.SLASH) ? this.consumeTokenText(false, FunToken.IDENT) : null;
                    boolean many = this.consumeToken(true, FunToken.ELLIPSIS);
                    if (type == SqlFunctionDefinition.REF && refTypeName == null) {
                        this.error(functionName, "/refType required");
                    }
                    result2.add(refTypeName == null ? new SqlFunctionDefinition.SimpleParameter(prototypeId, name, type, many) : new SqlFunctionDefinition.ReferenceParameter(prototypeId, name, type, refTypeName, many));
                }
            }
            if (!this.consumeToken(true, separator) || separator != FunToken.COMMA) continue;
            result2.add(SqlFunctionDefinition.COMMA);
        }
        return result2.isEmpty() ? SqlFunctionDefinition.Parameter.EMPTY_ARRAY : result2.toArray(new SqlFunctionDefinition.Parameter[result2.size()]);
    }

    private String consumeTypeName() {
        this.skipCommentsAndWhiteSpaces();
        int len = this.myLexer.getBufferSequence().length();
        int s = this.myLexer.getTokenEnd();
        boolean isArray = this.myLexer.getBufferSequence().subSequence(s, Math.min(len, s + 2)).equals("[]");
        String name = this.consumeTokenText(true, FunToken.IDENT);
        if (name != null && isArray) {
            this.consumeToken(true, FunToken.LEFT_BRACKET);
            this.consumeToken(true, FunToken.RIGHT_BRACKET);
            name = name + "[]";
        }
        return name;
    }

    @Nullable
    private SqlFunctionDefinition.Type findType(@Nullable String type) {
        if (type == null) {
            return null;
        }
        for (SqlFunctionDefinition.Type simpleType : SqlFunctionDefinition.SIMPLE_TYPES) {
            if (!simpleType.getName().equals(type)) continue;
            return simpleType;
        }
        SqlFunctionDefinition.Type builtInType = this.myDialect.getBuiltInTypes().get(type);
        if (builtInType != null) {
            return builtInType;
        }
        if (type.startsWith("P")) {
            String s = type.substring("P".length());
            try {
                return new SqlFunctionDefinition.ParamType(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private void advanceLexer() {
        this.myLexer.advance();
    }

    private void skipCommentsAndWhiteSpaces() {
        IElementType type = this.myLexer.getTokenType();
        while (type == FunToken.COMMENT || type == FunToken.WHITE_SPACE) {
            this.myLexer.advance();
            type = this.myLexer.getTokenType();
        }
    }

    @Nullable
    private IElementType getTokenType() {
        this.skipCommentsAndWhiteSpaces();
        return this.myLexer.getTokenType();
    }

    @Nullable
    private String getTokenText() {
        if (this.myLexer.getTokenType() == null) {
            return null;
        }
        String s = this.myLexer.getBufferSequence().subSequence(this.myLexer.getTokenStart(), this.myLexer.getTokenEnd()).toString();
        return DbUtil.intern((String)s);
    }

    private boolean consumeToken(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            this.advanceLexer();
            return true;
        }
        if (!optional) {
            throw new AssertionError((Object)(type.toString() + " expected"));
        }
        return false;
    }

    @Nullable
    private String consumeTokenText(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            String result2 = this.getTokenText();
            this.advanceLexer();
            return result2;
        }
        if (!optional) {
            throw new AssertionError((Object)(type + " expected, found " + this.getTokenType()));
        }
        return null;
    }

    public static void writeFuncs(List<SqlFunctionDefinition> definitionList, String root2, Class<Language> dialectClass) throws IOException {
        new File(root2 + "/reference").mkdirs();
        PrintWriter indexOut = new PrintWriter(new FileWriter(root2 + "index.xml"));
        indexOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        indexOut.println("<functions>");
        for (SqlFunctionDefinition definition : definitionList) {
            String docRef = "reference/" + definition.getName() + ".html";
            indexOut.println("<function>");
            indexOut.print("<name>");
            indexOut.print(definition.getName());
            indexOut.println("</name>");
            indexOut.print("<documentation ref=\"");
            indexOut.print(docRef);
            indexOut.println("\"/>");
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                indexOut.print("<prototype>");
                indexOut.print(prototype.toString());
                indexOut.println("</prototype>");
            }
            indexOut.println("</function>");
            PrintWriter docOut = new PrintWriter(new FileWriter(root2 + docRef));
            docOut.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html lang=\"en\" xml:lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>");
            docOut.println("<title>' + definition.getName() + '</title>");
            docOut.println("</head><body>");
            docOut.println(SqlDocumentationProvider.getDocumentation(definition, null, dialectClass));
            docOut.println("</body></html>");
            docOut.close();
        }
        indexOut.println("</functions>");
        indexOut.close();
    }
}

