/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.plus.OrapDialect;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDeprecateTypeInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/oracle/inspections/SqlDeprecateTypeInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/dialects/oracle/inspections/SqlDeprecateTypeInspection", "createAnnotationVisitor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/dialects/oracle/inspections/SqlDeprecateTypeInspection", "createAnnotationVisitor"));
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlTypeElement(SqlTypeElement o) {
                DataType dataType = o.getDataType();
                if ((this.myDialect == OracleDialect.INSTANCE || this.myDialect == OrapDialect.INSTANCE) && StringUtil.equalsIgnoreCase((CharSequence)dataType.getSpecification(), (CharSequence)"long")) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "The 'long' type is deprecated. Use LOB columns (CLOB, NCLOB, BLOB) instead.", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }
}

