/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjection
extends BaseInjection {
    public static final Pattern INVALID_PATTERN = Pattern.compile("");
    private Pattern myPattern = INVALID_PATTERN;
    private boolean myEnabled = false;
    private List<String> myHostLanguages = Collections.emptyList();
    private String myFragment = null;

    public SqlTypeBasedInjection() {
        super("sql");
    }

    public SqlTypeBasedInjection copyFrom(@NotNull BaseInjection other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/sql/injection/SqlTypeBasedInjection", "copyFrom"));
        }
        super.copyFrom(other);
        this.myPattern = ((SqlTypeBasedInjection)other).myPattern;
        this.myEnabled = ((SqlTypeBasedInjection)other).myEnabled;
        this.myFragment = ((SqlTypeBasedInjection)other).myFragment;
        this.myHostLanguages = ((SqlTypeBasedInjection)other).myHostLanguages;
        return this;
    }

    public void setPattern(@NotNull Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/injection/SqlTypeBasedInjection", "setPattern"));
        }
        this.myPattern = p;
    }

    @NotNull
    public Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjection", "getPattern"));
        }
        return pattern;
    }

    @NotNull
    public List<String> getHostLanguages() {
        List<String> list = this.myHostLanguages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjection", "getHostLanguages"));
        }
        return list;
    }

    public void setHostLanguages(@NotNull List<String> hostLanguages) {
        if (hostLanguages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostLanguages", "com/intellij/sql/injection/SqlTypeBasedInjection", "setHostLanguages"));
        }
        this.myHostLanguages = hostLanguages;
    }

    @Nullable
    public String getFragment() {
        return this.myFragment;
    }

    public void setFragment(String fragment) {
        this.myFragment = fragment;
    }

    protected void readExternalImpl(Element e) {
        super.readExternalImpl(e);
        String pattern = e.getAttributeValue("pattern");
        if (pattern != null) {
            this.myPattern = PatternUtil.compileSafe((String)pattern, (Pattern)INVALID_PATTERN);
        }
        this.myEnabled = Boolean.parseBoolean(e.getAttributeValue("enabled"));
        this.myFragment = StringUtil.nullize((String)e.getAttributeValue("fragment"));
        String hosts = e.getAttributeValue("hosts");
        this.myHostLanguages = StringUtil.isEmpty((String)hosts) ? Collections.emptyList() : ContainerUtil.newSmartList((Object[])hosts.split(","));
    }

    protected void writeExternalImpl(Element e) {
        super.writeExternalImpl(e);
        if (StringUtil.isNotEmpty((String)this.myPattern.pattern())) {
            e.setAttribute("pattern", this.myPattern.pattern());
        }
        if (this.myEnabled) {
            e.setAttribute("enabled", Boolean.toString(true));
        }
        if (StringUtil.isNotEmpty((String)this.myFragment)) {
            e.setAttribute("fragment", this.myFragment);
        }
        if (!this.myHostLanguages.isEmpty()) {
            e.setAttribute("hosts", StringUtil.join(this.myHostLanguages, (String)","));
        }
    }

    public SqlTypeBasedInjection copy() {
        return new SqlTypeBasedInjection().copyFrom(this);
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!super.sameLanguageParameters(that)) {
            return false;
        }
        SqlTypeBasedInjection that1 = (SqlTypeBasedInjection)((Object)ObjectUtils.tryCast((Object)that, SqlTypeBasedInjection.class));
        return that1 != null && this.myPattern.pattern().equals(that1.myPattern.pattern()) && this.myEnabled == that1.myEnabled && Comparing.equal((String)this.myFragment, (String)that1.myFragment) && this.myHostLanguages.equals(that1.myHostLanguages);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myPattern.pattern().hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.myEnabled);
        return result2;
    }

    public void setPlaceEnabled(@Nullable String text, boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return StringUtil.isNotEmpty((String)this.myPattern.pattern()) && this.myEnabled;
    }
}

