/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.database.model.DataType;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjector
implements MultiHostInjector {
    private static final List<Class<? extends PsiElement>> ourSqlInjectionSearchPoints = ContainerUtil.immutableList((Object[])new Class[]{SqlExpressionList.class, SqlColumnDefinition.class, SqlTypeCastExpression.class, SqlSetAssignment.class, SqlBinaryExpression.class});
    private static final Condition<PsiElement> ourIsInjectionSearchPoint = Conditions.instanceOf((Class[])ourSqlInjectionSearchPoints.toArray(new Class[ourSqlInjectionSearchPoints.size()]));
    private final Configuration myConfiguration;
    private final AtomicReference<InjectionsCache> myInjections;
    private static Set<IElementType> SAME_TYPE_OPERATORS = ContainerUtil.immutableSet((Object[])new IElementType[]{SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlTokens.SQL_OP_ASSIGN});

    public SqlTypeBasedInjector(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/sql/injection/SqlTypeBasedInjector", "<init>"));
        }
        this.myConfiguration = configuration;
        this.myInjections = new AtomicReference();
    }

    public SqlTypeBasedInjector(@NotNull Map<Language, SqlTypeBasedInjection> injections) {
        if (injections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injections", "com/intellij/sql/injection/SqlTypeBasedInjector", "<init>"));
        }
        this.myConfiguration = null;
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry<Language, SqlTypeBasedInjection> entry : injections.entrySet()) {
            SqlTypeBasedInjection inj = entry.getValue();
            inj.setInjectedLanguageId(entry.getKey().getID());
            IElementType fragment = inj.getFragment() == null ? null : (IElementType)ObjectUtils.assertNotNull((Object)SqlTokenRegistry.findCompositeType((String)inj.getFragment()));
            result2.add(new InjectionsCache.CacheEntry(inj, entry.getKey(), fragment));
        }
        this.myInjections = new AtomicReference<InjectionsCache>(new InjectionsCache(result2, -1L));
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguagesToInject"));
        }
        List<InjectionsCache.CacheEntry> injections = this.getFreshCache().forDialect(SqlImplUtil.getSqlDialectSafe(context));
        LinkedHashMap langs = ContainerUtil.newLinkedHashMap();
        SqlTypeBasedInjector.process(context, (PairProcessor<PsiElement, String>)((PairProcessor)(element, type) -> {
            if (element instanceof PsiLanguageInjectionHost) {
                SqlTypeBasedInjector.mergeLang(langs, (PsiLanguageInjectionHost)element, SqlTypeBasedInjector.getLanguageForType(type, injections));
            }
            return true;
        }));
        for (Map.Entry entry : langs.entrySet()) {
            PsiLanguageInjectionHost host;
            InjectionsCache.CacheEntry inj = (InjectionsCache.CacheEntry)entry.getValue();
            Language lang = inj.resolved;
            if (lang == Language.ANY || SqlTypeBasedInjector.isInjectedByComment(host = (PsiLanguageInjectionHost)entry.getKey())) continue;
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)host);
            InjectedLanguageUtil.INJECTED_FRAGMENT_TYPE.set((UserDataHolder)host, (Object)inj.fragment);
            InjectorUtils.registerInjection((Language)lang, Collections.singletonList(Trinity.create((Object)host, (Object)inj.injected, (Object)range)), (PsiFile)host.getContainingFile(), (MultiHostRegistrar)registrar);
        }
        SqlTypeBasedInjector.registerSupport(registrar);
    }

    @NotNull
    public static Set<String> getTypesFor(@NotNull PsiLanguageInjectionHost element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/injection/SqlTypeBasedInjector", "getTypesFor"));
        }
        LinkedHashSet types = ContainerUtil.newLinkedHashSet();
        SqlTypeBasedInjector.process((PsiElement)element, (PairProcessor<PsiElement, String>)((PairProcessor)(el, type) -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/injection/SqlTypeBasedInjector", "lambda$getTypesFor$1"));
            }
            if (el == element) {
                types.add(type);
            }
            return true;
        }));
        LinkedHashSet linkedHashSet = types;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getTypesFor"));
        }
        return linkedHashSet;
    }

    private static boolean process(@Nullable PsiElement element, @NotNull PairProcessor<PsiElement, String> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "process"));
        }
        while (element != null && !ourIsInjectionSearchPoint.value((Object)element)) {
            element = element.getParent();
        }
        if (element instanceof SqlSetAssignment) {
            return SqlTypeBasedInjector.processAssignment((SqlSetAssignment)element, processor);
        }
        if (element instanceof SqlBinaryExpression) {
            return SqlTypeBasedInjector.processBinaryExpression((SqlBinaryExpression)element, processor);
        }
        if (element instanceof SqlExpressionList) {
            return SqlTypeBasedInjector.processExpressionList((SqlExpressionList)element, processor);
        }
        if (element instanceof SqlTypeCastExpression) {
            return SqlTypeBasedInjector.processTypeCast((SqlTypeCastExpression)element, processor);
        }
        if (element instanceof SqlColumnDefinition) {
            return SqlTypeBasedInjector.processColumnDef((SqlColumnDefinition)element, processor);
        }
        return true;
    }

    private static boolean processBinaryExpression(@NotNull SqlBinaryExpression expr, @NotNull PairProcessor<PsiElement, String> processor) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/sql/injection/SqlTypeBasedInjector", "processBinaryExpression"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processBinaryExpression"));
        }
        SqlExpression left = expr.getLOperand();
        SqlExpression right = expr.getROperand();
        IElementType sign = expr.getOpSign();
        if (right == null) {
            return true;
        }
        if (!SAME_TYPE_OPERATORS.contains(sign)) {
            return true;
        }
        return right instanceof PsiLanguageInjectionHost ? SqlTypeBasedInjector.processFromExpression(left, (PsiElement)right, processor) : SqlTypeBasedInjector.processFromExpression(right, (PsiElement)left, processor);
    }

    private static boolean processAssignment(@NotNull SqlSetAssignment assignment, @NotNull PairProcessor<PsiElement, String> processor) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/sql/injection/SqlTypeBasedInjector", "processAssignment"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processAssignment"));
        }
        SqlExpression left = (SqlExpression)ObjectUtils.tryCast((Object)assignment.getLValue(), SqlExpression.class);
        if (left == null) {
            return true;
        }
        SqlElement right = assignment.getRValue();
        if (!(right instanceof PsiLanguageInjectionHost)) {
            return true;
        }
        return SqlTypeBasedInjector.processFromExpression(left, (PsiElement)right, processor);
    }

    private static boolean processFromExpression(@NotNull SqlExpression expr, @NotNull PsiElement place, @NotNull PairProcessor<PsiElement, String> processor) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/sql/injection/SqlTypeBasedInjector", "processFromExpression"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/injection/SqlTypeBasedInjector", "processFromExpression"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processFromExpression"));
        }
        SqlType sqlType = expr.getSqlType();
        if (sqlType == SqlType.UNKNOWN) {
            return true;
        }
        String name = sqlType.getDisplayName();
        return processor.process((Object)place, (Object)name);
    }

    private static boolean processTypeCast(@Nullable SqlTypeCastExpression castExpression, @NotNull PairProcessor<PsiElement, String> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processTypeCast"));
        }
        if (castExpression == null) {
            return true;
        }
        SqlExpression expression = castExpression.getExpression();
        SqlTypeElement typeElement = castExpression.getTypeElement();
        return typeElement == null || processor.process((Object)expression, (Object)typeElement.getDataType().typeName);
    }

    private static boolean processColumnDef(@Nullable SqlColumnDefinition columnDef, @NotNull PairProcessor<PsiElement, String> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processColumnDef"));
        }
        if (columnDef == null) {
            return true;
        }
        DataType type = columnDef.getDataType();
        if (type == DataType.UNKNOWN) {
            return true;
        }
        String typeName = type.typeName;
        for (SqlConstraintDefinition constraint : columnDef.getConstraints()) {
            PsiLanguageInjectionHost def;
            if (constraint.getConstraintType() != SqlConstraintDefinition.Type.DEFAULT || (def = (PsiLanguageInjectionHost)ObjectUtils.tryCast((Object)PsiTreeUtil.getChildOfType((PsiElement)constraint, SqlExpression.class), PsiLanguageInjectionHost.class)) == null || processor.process((Object)def, (Object)typeName)) continue;
            return false;
        }
        return true;
    }

    private static boolean processExpressionList(@Nullable SqlExpressionList list, @NotNull PairProcessor<PsiElement, String> processor) {
        JBIterable toMatch;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "processExpressionList"));
        }
        Object[] lists = SqlTypeBasedInjector.getExpressionsList(list);
        if (lists == null || lists.length == 0) {
            return true;
        }
        if (list.getParent() instanceof SqlFunctionCallExpression) {
            Object matching = null;
            for (Object overload : lists) {
                if (!overload.isMatched()) continue;
                if (matching != null) {
                    matching = null;
                    break;
                }
                matching = overload;
            }
            toMatch = matching != null ? Collections.singleton(matching) : JBIterable.of((Object[])lists);
        } else {
            toMatch = JBIterable.of((Object[])lists).filter(SqlFunctionsUtil.ExpressionList::isMatched);
        }
        if (!toMatch.iterator().hasNext()) {
            toMatch = JBIterable.of((Object[])lists);
        }
        for (SqlFunctionsUtil.ExpressionList elist : toMatch) {
            if (elist.processArgumentTypes((e, name, type) -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/injection/SqlTypeBasedInjector", "lambda$processExpressionList$2"));
                }
                return processor.process((Object)e, (Object)type);
            })) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static SqlFunctionsUtil.ExpressionList[] getExpressionsList(@Nullable SqlExpressionList list) {
        if (list == null) {
            return null;
        }
        if (list.getParent() instanceof SqlFunctionCallExpression) {
            return SqlFunctionsUtil.getOverloads((SqlFunctionCallExpression)list.getParent());
        }
        SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)list, SqlDmlInstruction.class);
        if (instruction != null) {
            return SqlFunctionsUtil.getInsertVariants(instruction, list);
        }
        if (list instanceof SqlParenthesizedExpression) {
            return null;
        }
        SqlCreateTableStatement tableStatement = (SqlCreateTableStatement)PsiTreeUtil.getParentOfType((PsiElement)list, SqlCreateTableStatement.class);
        if (tableStatement != null) {
            return SqlFunctionsUtil.getCreateTable((SqlCreateStatement)tableStatement, list);
        }
        return null;
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list = ourSqlInjectionSearchPoints;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "elementsToInjectIn"));
        }
        return list;
    }

    public static boolean isInjectedByComment(@Nullable PsiLanguageInjectionHost element) {
        return element != null && InjectorUtils.findCommentInjection((PsiElement)element, (String)"comment", null) != null;
    }

    private static void registerSupport(@NotNull MultiHostRegistrar registrar) {
        LanguageInjectionSupport support;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/sql/injection/SqlTypeBasedInjector", "registerSupport"));
        }
        if (registrar instanceof MultiHostRegistrarImpl && (support = InjectorUtils.findInjectionSupport((String)"sql")) != null) {
            InjectorUtils.registerSupport((LanguageInjectionSupport)support, (boolean)true, (MultiHostRegistrar)registrar);
        }
    }

    @NotNull
    private InjectionsCache getFreshCache() {
        InjectionsCache cache = this.myInjections.get();
        if (this.myConfiguration == null) {
            InjectionsCache injectionsCache = (InjectionsCache)ObjectUtils.assertNotNull((Object)cache);
            if (injectionsCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getFreshCache"));
            }
            return injectionsCache;
        }
        long counter = this.myConfiguration.getModificationCount();
        if (cache != null && cache.modCounter == counter) {
            InjectionsCache injectionsCache = cache;
            if (injectionsCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getFreshCache"));
            }
            return injectionsCache;
        }
        cache = new InjectionsCache(JBIterable.from((Iterable)this.myConfiguration.getInjections("sql")).filter(SqlTypeBasedInjection.class).transform(InjectionsCache.CacheEntry::of).filter(Conditions.notNull()).toList(), counter);
        this.myInjections.set(cache);
        InjectionsCache injectionsCache = cache;
        if (injectionsCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getFreshCache"));
        }
        return injectionsCache;
    }

    @NotNull
    private static Set<InjectionsCache.CacheEntry> getLanguageForType(@NotNull String type, @NotNull List<InjectionsCache.CacheEntry> cache) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguageForType"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguageForType"));
        }
        InjectionsCache.CacheEntry first = null;
        Set res = null;
        CharSequence bombed = null;
        for (InjectionsCache.CacheEntry item : cache) {
            if (!item.injection.isEnabled()) continue;
            if (bombed == null) {
                bombed = StringUtil.newBombedCharSequence((CharSequence)type, (long)100L);
            }
            if (SqlTypeBasedInjector.matchTimed(bombed, item) != Boolean.TRUE || item.resolved == Language.ANY || Comparing.equal(first, (Object)item)) continue;
            if (first == null) {
                first = item;
                continue;
            }
            if (res == null) {
                res = ContainerUtil.newLinkedHashSet((Object[])new InjectionsCache.CacheEntry[]{first, item});
                continue;
            }
            res.add(item);
        }
        if (res != null) {
            Set set = res;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguageForType"));
            }
            return set;
        }
        if (first != null) {
            Set<Object> set = Collections.singleton(first);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguageForType"));
            }
            return set;
        }
        Set<InjectionsCache.CacheEntry> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector", "getLanguageForType"));
        }
        return set;
    }

    @Nullable
    private static Boolean matchTimed(@NotNull CharSequence bombed, @NotNull InjectionsCache.CacheEntry item) {
        if (bombed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bombed", "com/intellij/sql/injection/SqlTypeBasedInjector", "matchTimed"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/sql/injection/SqlTypeBasedInjector", "matchTimed"));
        }
        try {
            return item.injection.getPattern().matcher(bombed).matches();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    private static void mergeLang(@NotNull Map<PsiLanguageInjectionHost, InjectionsCache.CacheEntry> langs, @NotNull PsiLanguageInjectionHost host, @NotNull Set<InjectionsCache.CacheEntry> inj) {
        if (langs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langs", "com/intellij/sql/injection/SqlTypeBasedInjector", "mergeLang"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/sql/injection/SqlTypeBasedInjector", "mergeLang"));
        }
        if (inj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inj", "com/intellij/sql/injection/SqlTypeBasedInjector", "mergeLang"));
        }
        InjectionsCache.CacheEntry lang = inj.size() != 1 ? InjectionsCache.CacheEntry.BAD : inj.iterator().next();
        InjectionsCache.CacheEntry old = langs.get(host);
        if (old == InjectionsCache.CacheEntry.BAD || old == lang) {
            return;
        }
        langs.put(host, old == null ? lang : InjectionsCache.CacheEntry.BAD);
    }

    private static class InjectionsCache {
        public final List<CacheEntry> items;
        public final long modCounter;
        private final Map<SqlLanguageDialectEx, List<CacheEntry>> myByLang;

        private InjectionsCache(@NotNull List<CacheEntry> items, long counter) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache", "<init>"));
            }
            this.myByLang = ContainerUtil.createConcurrentSoftValueMap();
            this.items = items;
            this.modCounter = counter;
        }

        @NotNull
        public List<CacheEntry> forDialect(@NotNull SqlLanguageDialectEx lang) {
            if (lang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache", "forDialect"));
            }
            List<CacheEntry> cached = this.myByLang.get((Object)lang);
            if (cached != null) {
                List<CacheEntry> list = cached;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache", "forDialect"));
                }
                return list;
            }
            ArrayList newCached = ContainerUtil.newArrayList();
            String id = lang.getID();
            for (CacheEntry item : this.items) {
                List<String> hosts = item.injection.getHostLanguages();
                if (!hosts.isEmpty() && !hosts.contains(id)) continue;
                newCached.add(item);
            }
            newCached.trimToSize();
            this.myByLang.put(lang, newCached);
            ArrayList arrayList = newCached;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache", "forDialect"));
            }
            return arrayList;
        }

        public static class CacheEntry {
            public static final CacheEntry BAD = new CacheEntry(new SqlTypeBasedInjection(), Language.ANY, null);
            public final SqlTypeBasedInjection injection;
            public final Language resolved;
            public final InjectedLanguage injected;
            public final IElementType fragment;

            @Nullable
            public static CacheEntry of(SqlTypeBasedInjection injection) {
                Language language = Language.findLanguageByID((String)injection.getInjectedLanguageId());
                if (language == null) {
                    return null;
                }
                IElementType fragment = null;
                if (injection.getFragment() != null && (fragment = SqlTokenRegistry.findCompositeType((String)injection.getFragment())) == null) {
                    return null;
                }
                return new CacheEntry(injection, language, fragment);
            }

            public CacheEntry(@NotNull SqlTypeBasedInjection injection, @NotNull Language resolved, @Nullable IElementType fragment) {
                if (injection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache$CacheEntry", "<init>"));
                }
                if (resolved == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache$CacheEntry", "<init>"));
                }
                this.injection = injection;
                this.resolved = resolved;
                this.fragment = fragment;
                this.injected = InjectedLanguage.create((String)injection.getInjectedLanguageId(), (String)injection.getPrefix(), (String)injection.getSuffix(), (boolean)false);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheEntry entry = (CacheEntry)o;
                return this.injected.equals((Object)entry.injected);
            }

            public int hashCode() {
                return this.injected.hashCode();
            }
        }
    }
}

