/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseConsoleAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveConfigurable;
import com.intellij.sql.highlighting.SqlAnnotator;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.resolve", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        final SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){
            List<DbDataSource> myDataSources;

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "re", "com/intellij/sql/inspections/SqlResolveInspection$1", "visitSqlReferenceExpression"));
                }
                for (PsiElement element : (SyntaxTraverser)traverser.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    ObjectKind type = o.getReferenceElementType().getTargetKind();
                    if (!this.myDialect.shallResolve(o, type)) {
                        return;
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier identifier = o.getIdentifier();
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier(identifier, afterIfExists);
                        break;
                    }
                    this.checkIdentifier(identifier, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable SqlIdentifier identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "afterIfExistsClause"));
                }
                PsiElement parent = o.getParent();
                return (parent instanceof SqlDropStatement || parent instanceof SqlAlterTableStatement || parent instanceof SqlAlterTableInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "visitSqlIdentifier"));
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve(o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable SqlIdentifier o) {
                SqlFunctionCallExpression foo;
                boolean isFunction;
                PsiElement grandPa;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement parent = o.getParent();
                PsiElement psiElement = grandPa = parent == null ? null : parent.getParent();
                if (parent instanceof SqlReferenceExpression && grandPa instanceof SqlDefinition && grandPa instanceof SqlAlterStatement) {
                    return this.checkAlterResolve(o, (SqlDefinition)grandPa);
                }
                PsiElement target = SqlAnnotator.getTargetElement(o);
                if (target == parent && "*".equals(o.getText()) && (!(parent instanceof SqlExpression) || SqlType.UNKNOWN == ((SqlExpression)parent).getSqlType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "Unable to resolve * in this context", true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target != null) {
                    return true;
                }
                ObjectKind expectedType = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
                if (expectedType == ObjectKind.ARGUMENT && (foo = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)api.parents((Object)parent).skip(3).first(), SqlFunctionCallExpression.class)) != null) {
                    if (foo.getParent() instanceof JdbcProcedureCall) {
                        return true;
                    }
                    SqlReferenceExpression name = foo.getNameElement();
                    if (name == null || name.resolve() == null) {
                        return true;
                    }
                }
                String kindName = DbPresentation.getPresentableName(expectedType, SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDatabaseDialect());
                String message = isFunction ? SqlMessages.message("unknown.function", o.getName()) : (expectedType != SqlDbElementType.ANY ? SqlMessages.message("unable.to.resolve.symbol.0.1", kindName, o.getName()) : SqlMessages.message("unable.to.resolve.symbol.0", o.getName()));
                List<LocalQuickFix> fixes = this.createQuickFixesFor(o, parent, expectedType);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(new LocalQuickFix[fixes.size()]) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            private boolean checkAlterResolve(SqlIdentifier o, SqlDefinition def) {
                boolean resolved;
                Object[] elements = SqlImplUtil.getRelatedElements(def);
                boolean bl = resolved = elements.length != 0;
                if (resolved) {
                    PsiElement res = (PsiElement)JBIterable.of((Object[])elements).filter(x -> !(x instanceof SqlAlterStatement)).first();
                    boolean bl2 = resolved = res != null;
                }
                if (!resolved) {
                    String message = SqlMessages.message("unable.to.resolve.symbol.0.1", def.getKind(), o.getName());
                    List<LocalQuickFix> fixes = this.createQuickFixesFor(o, o.getParent(), def.getKind());
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(new LocalQuickFix[fixes.size()]) : LocalQuickFix.EMPTY_ARRAY));
                }
                return resolved;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            private List<LocalQuickFix> createQuickFixesFor(@NotNull SqlIdentifier o, @Nullable PsiElement parent, @NotNull ObjectKind expectedType) {
                boolean addGenericFixes;
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "createQuickFixesFor"));
                }
                if (expectedType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/sql/inspections/SqlResolveInspection$1", "createQuickFixesFor"));
                }
                ArrayList result2 = ContainerUtil.newArrayList();
                if (expectedType == ObjectKind.TABLE) {
                    result2.add(new AddSqlTableFix(o));
                    result2.add(new AddDbTableFix(o));
                } else if (expectedType == ObjectKind.COLUMN) {
                    if (parent instanceof SqlReferenceExpression) {
                        PsiReference reference;
                        SqlExpression qualifierExpression = ((SqlReferenceExpression)parent).getQualifierExpression();
                        if (qualifierExpression instanceof SqlReferenceExpression) {
                            SqlExpression expression;
                            PsiElement resolve;
                            reference = qualifierExpression.getReference();
                            PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                            if (resolve instanceof DbTable) {
                                result2.add(new AddDbColumnFix(o, (DbTable)resolve));
                            } else if (resolve instanceof SqlAsExpression && (expression = ((SqlAsExpression)resolve).getExpression()) instanceof SqlReferenceExpression) {
                                PsiElement resolveResult;
                                PsiReference expressionReference = expression.getReference();
                                PsiElement psiElement2 = resolveResult = expressionReference != null ? expressionReference.resolve() : null;
                                if (resolveResult instanceof DbTable) {
                                    result2.add(new AddDbColumnFix(o, (DbTable)resolveResult));
                                } else if (resolveResult instanceof SqlCreateTableStatement) {
                                    result2.add(new AddSqlColumnFix(o, (SqlCreateTableStatement)resolveResult));
                                }
                            }
                        } else {
                            reference = ((SqlReferenceExpression)parent).getReference();
                            if (reference instanceof SqlReferenceImpl) {
                                if (this.myDataSources == null) {
                                    this.myDataSources = SqlImplUtil.getDataSources((PsiElement)parent.getContainingFile());
                                }
                                MyResolveContextProcessor processor = new MyResolveContextProcessor(this.myDialect, this.myDataSources);
                                ((SqlReferenceImpl)reference).processResolveVariants(processor);
                                Set<DbTable> dbTables = processor.getDbTables();
                                Set<SqlCreateTableStatement> sqlTables = processor.getSqlTables();
                                for (DbTable dbTable : dbTables) {
                                    result2.add(new AddDbColumnFix(o, dbTable));
                                }
                                for (SqlCreateTableStatement sqlCreateTableStatement : sqlTables) {
                                    result2.add(new AddSqlColumnFix(o, sqlCreateTableStatement));
                                }
                            }
                        }
                    }
                } else {
                    SqlReferenceImpl ref;
                    SqlReferenceImpl sqlReferenceImpl = ref = parent instanceof SqlReferenceExpression ? (SqlReferenceImpl)ObjectUtils.tryCast((Object)parent.getReference(), SqlReferenceImpl.class) : null;
                    if (ref != null) {
                        MyResolveContextProcessor processor = new MyResolveContextProcessor(this.myDialect, this.myDataSources);
                        ref.initExpectedTargetTypes(processor);
                        boolean schemaExpected = processor.getExpectedTypes().contains(ObjectKind.SCHEMA);
                        boolean dbExpected = processor.getExpectedTypes().contains(ObjectKind.DATABASE);
                        if (schemaExpected || dbExpected) {
                            String name;
                            void var11_27;
                            List candidates;
                            SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent).getQualifierExpression(), SqlReferenceExpression.class);
                            Object[] resolved = qual == null ? ResolveResult.EMPTY_ARRAY : qual.multiResolve(false);
                            JBIterable jBIterable = JBIterable.empty();
                            if (resolved.length == 0) {
                                SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)o.getContainingFile(), SqlFile.class);
                                if (file != null) {
                                    if (this.myDataSources == null) {
                                        this.myDataSources = SqlImplUtil.getDataSources((PsiElement)file);
                                    }
                                    SqlImportState checker = SqlDialectImplUtil.getImportCheckerAt(file, (PsiElement)o);
                                    for (DbDataSource source : this.myDataSources) {
                                        void var11_24;
                                        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getDelegate().getModel(), BasicModel.class);
                                        if (model == null) continue;
                                        JBIterable jBIterable2 = var11_24.append((Iterable)((JBTreeTraverser)model.traverser().expand(SqlFileImpl.importedCondition(checker, source))).filter(BasicMateNamespace.class).transform(n -> Pair.create((Object)source, (Object)n)));
                                    }
                                }
                            } else {
                                JBIterable jBIterable3 = JBIterable.of((Object[])resolved).transform(ResolveResult::getElement).filter(DbElement.class).flatten(e -> {
                                    DasObject object = (DasObject)ObjectUtils.tryCast((Object)e.getDelegate(), DasObject.class);
                                    DbDataSource source = e.getDataSource();
                                    return object == null ? JBIterable.empty() : object.getDbChildren(BasicMateNamespace.class, ObjectKind.NONE).transform(n -> Pair.create((Object)source, (Object)n));
                                });
                            }
                            if (!(candidates = var11_27.filter(arg_0 -> 1.lambda$createQuickFixesFor$4(name = ref.getReferenceName(), dialect, schemaExpected, dbExpected, arg_0)).toList()).isEmpty()) {
                                ObjectKind kind = dbExpected && schemaExpected ? ObjectKind.NONE : (dbExpected ? ObjectKind.DATABASE : ObjectKind.SCHEMA);
                                result2.add(new IntrospectSchemaFix(candidates, kind));
                            }
                        }
                    }
                }
                VirtualFile file = SqlImplUtil.getTopLevelFile(o.getContainingFile());
                boolean bl = addGenericFixes = expectedType != ObjectKind.COLUMN && file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem) && !DbSrcUtils.isDbSrcFile(file) && !DbConsoleRootType.isConsoleFile(file);
                if (addGenericFixes) {
                    result2.add(new GoToResolutionScopesFix());
                    if (onTheFly && JdbcConsoleProvider.getAttachedConsole(o.getProject(), file) == null) {
                        result2.add(new AttachConsoleFix());
                    }
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$1", "createQuickFixesFor"));
                }
                return arrayList;
            }

            private static /* synthetic */ boolean lambda$createQuickFixesFor$4(String name, @NotNull SqlLanguageDialectEx dialect2, boolean schemaExpected, boolean dbExpected, Pair n) {
                if (dialect2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlResolveInspection$1", "lambda$createQuickFixesFor$4"));
                }
                return !((BasicMateNamespace)n.second).isVisible() && DasUtil.nameEqual((DasObject)((DasObject)n.second), (String)name, (CasingProvider)dialect2) && (((BasicMateNamespace)n.second).getKind() == ObjectKind.SCHEMA && schemaExpected || ((BasicMateNamespace)n.second).getKind() == ObjectKind.DATABASE && dbExpected);
            }
        };
    }

    @NotNull
    private static Collection<String> collectColumnNames(@NotNull SqlIdentifier element, @NotNull SqlStatement statement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement);
        DatabaseDialectEx dialect = sqlLanguage.getDatabaseDialect();
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlAsExpression.class);
        LinkedHashSet columnsNames = ContainerUtil.newLinkedHashSet();
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            String qualifierText;
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            PsiPolyVariantReference reference = e.getReference();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || reference.resolve() != null) continue;
            boolean isPlain = SqlImplUtil.hasPlainIdentifier(e, dialect);
            Case casing = casingProvider.getCasing(ObjectKind.COLUMN, null).choose(isPlain);
            SqlExpression qualifier = e.getQualifierExpression();
            PsiReference qualifierReference = qualifier != null ? qualifier.getReference() : null;
            String string = qualifierText = qualifier != null ? qualifier.getText() : null;
            if (asExpression != null && qualifierReference != null && !asExpression.equals(qualifierReference.resolve()) && !new NameChecker(qualifierText, casing, isPlain, sqlLanguage, casingProvider).checkName(element.getParent(), false)) continue;
            columnsNames.add(identifier.getText());
        }
        LinkedHashSet linkedHashSet = columnsNames;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        return linkedHashSet;
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessor {
        final Set<DbTable> myMyDbTables = new HashSet();
        final Set<SqlCreateTableStatement> myMySqlTables = new HashSet();
        private Set<ObjectKind> myExpectedTypes = Collections.emptySet();

        MyResolveContextProcessor(SqlLanguageDialectEx dialect, Iterable<DbDataSource> dataSources) {
            super(true, dialect, dataSources);
        }

        @Override
        public boolean isResultEmpty() {
            return this.myMyDbTables.isEmpty() && this.myMySqlTables.isEmpty();
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object context) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "handleEvent"));
            }
            if (event == EXPECTED_TYPE) {
                this.myExpectedTypes = (Set)context;
            }
            if (event != SqlScopeProcessor.RESOLVE_CONTEXT) {
                return;
            }
            if (!(context instanceof PsiElement)) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = ((PsiElement)context).getParent();
            PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement o) {
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor);
            }
        }

        private void processReference(@Nullable PsiReference ref) {
            PsiElement resolve;
            PsiElement psiElement = resolve = ref != null ? ref.resolve() : null;
            if (resolve instanceof DbTable) {
                this.myMyDbTables.add((DbTable)resolve);
            } else if (resolve instanceof SqlCreateTableStatement) {
                this.myMySqlTables.add((SqlCreateTableStatement)resolve);
            }
        }

        @Override
        public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "executeTarget"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "executeTarget"));
            }
            return true;
        }

        @NotNull
        public Set<DbTable> getDbTables() {
            Set<DbTable> set = this.myMyDbTables;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "getDbTables"));
            }
            return set;
        }

        @NotNull
        public Set<SqlCreateTableStatement> getSqlTables() {
            Set<SqlCreateTableStatement> set = this.myMySqlTables;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "getSqlTables"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getExpectedTypes() {
            Set<ObjectKind> set = this.myExpectedTypes;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "getExpectedTypes"));
            }
            return set;
        }
    }

    private static class AddDbColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final VirtualFile myTable;
        final String myColumnName;

        AddDbColumnFix(@NotNull SqlIdentifier o, @NotNull DbTable table) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "<init>"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "<init>"));
            }
            super(o);
            this.myColumnName = o.getName();
            this.myTable = table.getVirtualFile();
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add '" + this.myColumnName + "' to '" + this.myTable.getName() + "' table";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "getText"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "applyFix"));
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element.getContainingFile());
            if (dataSource == null) {
                return;
            }
            DbElement table = ((DatabaseElementVirtualFileImpl)this.myTable).findElement();
            if (!(table instanceof DbTable)) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "lambda$applyFix$0"));
                }
                DdlActions.AddColumnAction.perform((DbTable)table, null, element.getText());
            });
        }
    }

    private static class AddDbTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        AddDbTableFix(@Nullable SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            if ("Add table to data source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "getText"));
            }
            return "Add table to data source";
        }

        @Override
        public void applyFix(@NotNull Project project, final @NotNull SqlIdentifier element, @Nullable Editor editor) {
            List strings;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "applyFix"));
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element.getContainingFile());
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            Collection collection = strings = statement == null ? ContainerUtil.emptyList() : SqlResolveInspection.collectColumnNames(element, statement);
            if (dataSource != null) {
                AddDbTableFix.showDialog(dataSource, element, strings);
            } else if (editor != null) {
                ArrayList runners = ContainerUtil.newArrayList();
                for (final DbDataSource source : DbPsiFacade.getInstance((Project)project).getDataSources()) {
                    runners.add(new PersistenceConsoleProvider.Runner(){

                        public String getDisplayName() {
                            return source.getName();
                        }

                        public Icon getIcon() {
                            return source.getIcon();
                        }

                        public boolean isAlreadyRunning() {
                            return false;
                        }

                        public void run() {
                            AddDbTableFix.showDialog(source, element, strings);
                        }
                    });
                }
                RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, null, "Choose Data Source");
            }
        }

        private static void showDialog(@NotNull DbDataSource source, @NotNull SqlIdentifier element, @NotNull Collection<String> strings) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$showDialog$1"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$showDialog$1"));
                }
                if (strings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$showDialog$1"));
                }
                TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$null$0"));
                    }
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$null$0"));
                    }
                    if (strings == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "lambda$null$0"));
                    }
                    DdlActions.AddTableAction.showAddTableDialogAndRun(source, null, element.getText(), strings);
                });
            });
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        public AddSqlTableFix(SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlMessages.message("quickfix.name.create.table.definition", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getText"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "applyFix"));
            }
            if (editor == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlStatement.class);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            if (statement == null || placeForInsertBefore == null) {
                return;
            }
            Collection columnsNames = SqlResolveInspection.collectColumnNames(element, statement);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = AddSqlTableFix.getTemplate(templateManager, (PsiElement)element, columnsNames);
            if (template == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        private static Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element, @NotNull Collection<String> columnsNames) {
            if (templateManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateManager", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (columnsNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsNames", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (columnsNames.isEmpty()) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                Variable variable = (Variable)copy.getVariables().get(0);
                assert ("table".equals(variable.getName()));
                variable.setDefaultValueString("\"" + element.getText() + "\"");
                variable.setAlwaysStopAt(false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment("create table " + element.getText() + " (\n");
            int size = columnsNames.size();
            int i2 = 0;
            for (String name : columnsNames) {
                template.addTextSegment(name);
                template.addTextSegment(" ");
                template.addVariable("type" + i2, (Expression)new ConstantNode("int"), true);
                template.addTextSegment(" ");
                template.addVariable("not_null" + i2, (Expression)new ConstantNode("not null"), true);
                if (i2 != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i2;
            }
            template.addTextSegment(");\n");
            return template;
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final SmartPsiElementPointer<SqlCreateTableStatement> myTable;
        final String myTableName;
        final String myColumnName;

        AddSqlColumnFix(@NotNull SqlIdentifier o, @NotNull SqlCreateTableStatement table) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "<init>"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "<init>"));
            }
            super(o);
            this.myTable = SmartPointerManager.getInstance((Project)o.getProject()).createSmartPsiElementPointer((PsiElement)table);
            this.myTableName = table.getName();
            this.myColumnName = o.getName();
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add column '" + this.myColumnName + "'to '" + this.myTableName + "' table";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "getText"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "applyFix"));
            }
            if (editor == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)ContainerUtil.getLastItem((List)table.getColumns());
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen = table.getNode().findChildByType((IElementType)SqlTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            Variable variable = (Variable)copy.getVariables().get(0);
            assert ("col".equals(variable.getName()));
            variable.setDefaultValueString("\"" + element.getText() + "\"");
            variable.setAlwaysStopAt(false);
            editor.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor.getDocument().insertString(offset, (CharSequence)newLine);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor, (Template)copy);
        }
    }

    private static class IntrospectSchemaFix
    extends IntentionAndQuickFixAction {
        final List<Pair<DbDataSource, BasicMateNamespace>> myCandidates;
        final String myKindName;

        IntrospectSchemaFix(@NotNull List<Pair<DbDataSource, BasicMateNamespace>> candidates, @NotNull ObjectKind kind) {
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix", "<init>"));
            }
            this.myCandidates = candidates;
            this.myKindName = StringUtil.capitalize((String)DbPresentation.getPresentableName(kind, GenericDialect.INSTANCE));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = "Introspect " + this.myKindName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix", "getName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix", "applyFix"));
            }
            if (this.myCandidates.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                IntrospectSchemaFix.setVisible(this.myCandidates);
            } else {
                final Set ds = JBIterable.from(this.myCandidates).transform(p -> (DbDataSource)p.first).toSet();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<Pair<DbDataSource, BasicMateNamespace>>("Add to View", this.myCandidates){

                    public Icon getIconFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        return DbPresentation.getIcon((DasObject)value.second);
                    }

                    @NotNull
                    public String getTextFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        BasicElement parent = (BasicElement)ObjectUtils.notNull((Object)((BasicMateNamespace)value.second).getDbParent());
                        StringBuilder text = new StringBuilder();
                        if (ds.size() > 1) {
                            text.append(((DbDataSource)value.first).getName()).append("\u2006.\u2006");
                        }
                        if (parent.getKind() != ObjectKind.ROOT) {
                            text.append(parent.getName()).append("\u2006.\u2006");
                        }
                        text.append(((BasicMateNamespace)value.second).getName());
                        String string = text.toString();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix$1", "getTextFor"));
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues, boolean finalChoice) {
                        IntrospectSchemaFix.setVisible(selectedValues);
                        return FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }
                }).showCenteredInCurrentWindow(project);
            }
        }

        private static void setVisible(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues) {
            MultiMap byDs = MultiMap.create();
            selectedValues.forEach(e -> byDs.putValue(e.first, e.second));
            for (Map.Entry entry : byDs.entrySet()) {
                BasicNamespace item = (BasicNamespace)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (item == null) continue;
                DataSourceUiUtil.setNamespacesVisible((DbDataSource)entry.getKey(), (Iterable)entry.getValue(), true);
            }
        }
    }

    private static class AttachConsoleFix
    extends IntentionAndQuickFixAction {
        private AttachConsoleFix() {
        }

        @NotNull
        public String getName() {
            if ("Attach console" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix", "getName"));
            }
            return "Attach console";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix", "applyFix"));
            }
            if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
                return;
            }
            ChooseConsoleAction action = new ChooseConsoleAction();
            action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)editor.getContentComponent())));
        }
    }

    private static class GoToResolutionScopesFix
    extends IntentionAndQuickFixAction {
        private GoToResolutionScopesFix() {
        }

        @NotNull
        public String getName() {
            if ("Go to SQL Resolution Scopes" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix", "getName"));
            }
            return "Go to SQL Resolution Scopes";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix", "applyFix"));
            }
            SqlResolveConfigurable.openResolveScopesConfigurable(project, SqlImplUtil.getTopLevelFile(file));
        }
    }
}

