/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.inspections.suppression.SqlFileSuppressInspectionFix;
import com.intellij.sql.inspections.suppression.SqlSuppressInspectionFix;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInspectionSuppressor
implements InspectionSuppressor {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedFor"));
        }
        if (!(element instanceof SqlElement)) {
            return false;
        }
        if (SqlInspectionSuppressor.isSuppressedForFile(element.getContainingFile(), toolId)) {
            return true;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        return statement != null && SqlInspectionSuppressor.isSuppressedForStatement((PsiElement)statement, toolId);
    }

    private static boolean isSuppressedForFile(@NotNull PsiFile file, @NotNull String id) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForFile"));
        }
        int prefixLength = SqlInspectionSuppressor.prefixLength((PsiElement)file);
        String idForFile = id + "ForFile";
        return SqlInspectionSuppressor.leafs((PsiElement)file, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi()).takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment).find(e -> SqlInspectionSuppressor.isSuppressedInComment(e, idForFile, prefixLength)) != null;
    }

    private static boolean isSuppressedForStatement(@NotNull PsiElement element, @NotNull String id) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForStatement"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForStatement"));
        }
        int prefixLength = SqlInspectionSuppressor.prefixLength(element);
        PsiElement first = element.getFirstChild() instanceof PsiComment ? element.getFirstChild() : SqlInspectionSuppressor.nextLeaf(element, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed());
        return SqlInspectionSuppressor.leafs(first, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed()).takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment).find(e -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "lambda$isSuppressedForStatement$3"));
            }
            return SqlInspectionSuppressor.isSuppressedInComment(e, id, prefixLength);
        }) != null;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "getSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SqlSuppressInspectionFix(toolId, SqlStatement.class), new SqlFileSuppressInspectionFix(toolId)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    @NotNull
    private static JBIterable<PsiElement> leafs(@Nullable PsiElement element, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "leafs"));
        }
        JBIterable jBIterable = JBIterable.generate((Object)SqlInspectionSuppressor.firstLeaf(element, api), e -> {
            if (api == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "lambda$leafs$4"));
            }
            return SqlInspectionSuppressor.nextLeaf(e, api);
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "leafs"));
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement firstLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "firstLeaf"));
        }
        PsiElement next = e;
        while (next != null) {
            PsiElement first = (PsiElement)api.first((Object)next);
            if (first == null) {
                if (next.getTextLength() > 0) break;
                next = (PsiElement)api.next((Object)next);
                continue;
            }
            next = first;
        }
        return next;
    }

    @Nullable
    private static PsiElement nextLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "nextLeaf"));
        }
        PsiElement p = e;
        while (p != null) {
            PsiElement next = SqlInspectionSuppressor.firstLeaf((PsiElement)api.next((Object)p), api);
            if (next != null) {
                return next;
            }
            p = (PsiElement)api.parent((Object)p);
        }
        return null;
    }

    private static boolean isSuppressedInComment(@Nullable PsiElement e, @NotNull String toolId, int prefixLength) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedInComment"));
        }
        if (!(e instanceof PsiComment)) {
            return false;
        }
        for (String line : StringUtil.splitByLines((String)e.getText())) {
            Matcher m;
            if (line.length() < prefixLength || !(m = SUPPRESS_PATTERN.matcher(line.substring(prefixLength))).matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)m.group(1), (String)toolId)) continue;
            return true;
        }
        return false;
    }

    private static int prefixLength(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "prefixLength"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getContainingFile().getLanguage());
        String prefix = (String)ObjectUtils.notNull((Object)(commenter == null ? null : commenter.getLineCommentPrefix()), (Object)"");
        return prefix.length();
    }
}

