/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.intentions.SqlIntentionActionBase;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlUnqualifyIdentifierIntention
extends SqlIntentionActionBase {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unqualify identifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "getFamilyName"));
        }
        return "Unqualify identifier";
    }

    @Nullable
    private static SqlReferenceExpression getTopmostQualifiedRef(@NotNull PsiElement element) {
        SqlReferenceExpression next;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "getTopmostQualifiedRef"));
        }
        SqlIdentifier identifier = SqlIntentionUtil.getIdentifier(element);
        if (identifier == null) {
            return null;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        if (ref.getQualifierExpression() == null) {
            return (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        }
        while (ref.getQualifierExpression() != null && (next = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class)) != null && next.getQualifierExpression() != null) {
            ref = next;
        }
        return ref.getQualifierExpression() == null ? null : ref;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "isAvailable"));
        }
        return SqlUnqualifyIdentifierIntention.getTopmostQualifiedRef(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "invoke"));
        }
        SqlReferenceExpression ref = SqlUnqualifyIdentifierIntention.getTopmostQualifiedRef(element);
        if (ref == null || ref.getQualifierExpression() == null || ref.getIdentifier() == null) {
            return;
        }
        this.unqualifyReference(ref);
    }

    private void unqualifyReference(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "unqualifyReference"));
        }
        PsiFile file = ref.getContainingFile();
        SqlIdentifier identifier = ref.getIdentifier();
        if (file == null || identifier == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)ref.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)ref.getProject(), (String)this.getText(), null, () -> {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention", "lambda$unqualifyReference$0"));
            }
            document.replaceString(ref.getTextRange().getStartOffset(), identifier.getTextRange().getStartOffset(), (CharSequence)"");
        }, (PsiFile[])new PsiFile[]{file});
    }
}

