/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.TextWithRanges;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlPreFormatProcessor;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.fragments.SqlCodeFragmentImpl;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.sql.script.SqlScriptModel;
import com.intellij.util.text.TextRangeUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPsiFacadeImpl
extends SqlPsiFacade {
    private final Project myProject;

    public SqlPsiFacadeImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public SqlLanguageDialect getDefaultDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(this.myProject, null);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "getDefaultDialect"));
        }
        return sqlLanguageDialect;
    }

    public void setDialectMapping(@NotNull VirtualFile file, @NotNull SqlLanguageDialect dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlPsiFacadeImpl", "setDialectMapping"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "setDialectMapping"));
        }
        SqlDialectMappings.getInstance(this.myProject).setMapping(file, dialect);
    }

    @NotNull
    public SqlLanguageDialect getDialectMapping(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlPsiFacadeImpl", "getDialectMapping"));
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(this.myProject).getMapping(file);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "getDialectMapping"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlScriptModel createScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createScriptModel"));
        }
        SqlScriptModel sqlScriptModel = new SqlScriptModel(file);
        if (sqlScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createScriptModel"));
        }
        return sqlScriptModel;
    }

    @NotNull
    public SqlReader createSqlReader() {
        SqlReaderImpl sqlReaderImpl = new SqlReaderImpl(this.myProject);
        if (sqlReaderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createSqlReader"));
        }
        return sqlReaderImpl;
    }

    @NotNull
    public CharSequence format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull TextWithRanges textWithRanges) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (textWithRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textWithRanges", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createDocumentFormattingModel(project, dialect, sqlSettings.getRootSettings(), textWithRanges);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
        CharSequence charSequence = model.getDocumentModel().getDocument().getImmutableCharSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        return charSequence;
    }

    public void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        CommonCodeStyleSettings sqlSettings = CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)dialect);
        FormattingModel model = SqlFormattingModelBuilder.createModel(project, dialect, sqlSettings.getRootSettings(), document.getText(), document);
        SqlPsiFacadeImpl.format(project, dialect, sqlSettings, model);
    }

    private static void format(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CommonCodeStyleSettings sqlSettings, @NotNull FormattingModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (sqlSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlSettings", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/psi/SqlPsiFacadeImpl", "format"));
        }
        CodeStyleSettings settings = sqlSettings.getRootSettings();
        Block rootBlock = model.getRootBlock();
        TextRange range = new SqlPreFormatProcessor().process(((AbstractBlock)rootBlock).getNode(), TextRange.create((int)0, (int)model.getDocumentModel().getTextLength()));
        Document document = model.getDocumentModel().getDocument();
        FormatTextRanges ranges = new FormatTextRanges();
        Iterable toProcess = TextRangeUtil.excludeRanges((TextRange)range, ((DocumentEx)document).getGuardedBlocks().stream().map(marker -> TextRange.create((int)marker.getStartOffset(), (int)marker.getEndOffset())).collect(Collectors.toList()));
        for (TextRange tr : toProcess) {
            ranges.add(tr, true);
        }
        model = SqlFormattingModelBuilder.createModel(project, dialect, settings, document.getCharsSequence(), document);
        FormatterEx.getInstance().format(model, settings, sqlSettings.getIndentOptions(), ranges);
    }

    @NotNull
    public PsiCodeFragment createTableReferenceFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable DbElement schemaElement, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, "dummy.sql", text, true);
        codeFragment.setContext((PsiElement)schemaElement);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTableReferenceFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createEvaluableExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource dataSourceElement, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createEvaluableExpressionFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createEvaluableExpressionFragment"));
        }
        SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION, "dummy.sql", text, true);
        fragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, dataSourceElement);
        fragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = fragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createEvaluableExpressionFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createTypeElementFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createTypeElementFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        return sqlCodeFragmentImpl;
    }

    @NotNull
    public PsiCodeFragment createExpressionFragment(@NotNull Language dialect, @Nullable DbDataSource context, @Nullable List<DasNamespace> searchPath, @NotNull String text, @NotNull String contextQuery) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        if (contextQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextQuery", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(this.myProject, (SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, "dummy.sql", text, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, context);
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        SqlFile file = (SqlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.sql", dialect, (CharSequence)contextQuery);
        file.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)context);
        file.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        final Ref ref = Ref.create();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof SqlQueryExpression) {
                    ref.set((Object)((SqlQueryExpression)element));
                } else {
                    super.visitElement(element);
                }
            }
        });
        if (!ref.isNull()) {
            codeFragment.setContext((PsiElement)ref.get());
        }
        SqlCodeFragmentImpl sqlCodeFragmentImpl = codeFragment;
        if (sqlCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlPsiFacadeImpl", "createExpressionFragment"));
        }
        return sqlCodeFragmentImpl;
    }
}

