/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final String sourceActual;
    public final Case sourceCase;
    public final boolean sourcePlain;
    public final SqlLanguageDialectEx dialect;
    public final CasingProvider casingProvider;

    public NameChecker(String sourceText, Case sourceCase, boolean sourcePlain, SqlLanguageDialectEx dialect, CasingProvider casingProvider) {
        this.dialect = dialect;
        this.sourceCase = sourceCase;
        this.sourcePlain = sourcePlain;
        this.sourceText = sourceText;
        this.casingProvider = casingProvider;
        this.sourceActual = sourceCase.apply(sourceText);
    }

    public NameChecker(@NotNull SqlReferenceExpression ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/NameChecker", "<init>"));
        }
        this.dialect = dialect;
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        DasObject context = this.getDasContext(ref.getQualifierExpression());
        this.sourcePlain = SqlImplUtil.hasPlainIdentifier(ref, dialect.getDatabaseDialect());
        this.sourceText = ref.getName();
        this.casingProvider = provider;
        this.sourceCase = this.casingProvider.getCasing(kind, context).choose(this.sourcePlain);
        this.sourceActual = this.sourceCase.apply(this.sourceText);
    }

    NameChecker(@NotNull SqlReferenceImpl ref, SqlLanguageDialectEx dialect, CasingProvider provider) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/psi/impl/NameChecker", "<init>"));
        }
        this.dialect = dialect;
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        DasObject context = this.getDasContext(ref.getQualifierExpression());
        this.sourceText = ref.getReferenceName();
        this.sourcePlain = SqlImplUtil.hasPlainIdentifier(ref.getElement(), dialect.getDatabaseDialect());
        this.casingProvider = provider;
        this.sourceCase = this.casingProvider.getCasing(kind, context).choose(this.sourcePlain);
        this.sourceActual = this.sourceCase.apply(this.sourceText);
    }

    @Nullable
    protected DasObject getDasContext(@Nullable SqlExpression qualifier) {
        PsiReference reference = qualifier == null ? null : qualifier.getReference();
        PsiElement target = reference == null ? null : reference.resolve();
        return target instanceof DasObject ? (DasObject)target : null;
    }

    public boolean checkName(@Nullable Object target, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        String[] altNames;
        if (target == null) {
            return false;
        }
        if (!Conditions.instanceOf((Class[])new Class[]{DasObject.class, SqlReferenceExpression.class}).value(target)) {
            throw new IllegalArgumentException(target.getClass().getName());
        }
        String name = target instanceof DasObject ? ((DasObject)target).getName() : (target instanceof SqlReferenceExpression ? ((SqlNameElement)target).getName() : null);
        String[] stringArray = altNames = target instanceof SqlAltNamesProvider ? ((SqlAltNamesProvider)target).getAltNames() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (!Comparing.strEqual((String)name, (String)this.sourceText, (boolean)false)) {
            String alt = null;
            for (String text : altNames) {
                if (!Comparing.strEqual((String)text, (String)this.sourceText, (boolean)false)) continue;
                alt = text;
                break;
            }
            if (alt == null) {
                return false;
            }
            name = alt;
        }
        DatabaseDialectEx databaseDialect = this.dialect.getDatabaseDialect();
        boolean isBuiltInFunction = target instanceof BuiltinFunction;
        if (isBuiltInFunction && databaseDialect.getFamilyId().isSybase()) {
            return true;
        }
        if (isBuiltInFunction && databaseDialect.getFamilyId().isTransactSql() && ((BuiltinFunction)target).getPostfixType() == null) {
            return this.sourcePlain;
        }
        boolean targetIsPlain = SqlImplUtil.hasPlainIdentifier(target, databaseDialect);
        Case targetCase = target instanceof DasObject ? this.casingProvider.getCasing(((DasObject)target).getKind(), (DasObject)target).choose(targetIsPlain) : (target instanceof SqlReferenceExpression ? new NameChecker((SqlReferenceExpression)((SqlReferenceExpression)target), (SqlLanguageDialectEx)this.dialect, (CasingProvider)this.casingProvider).sourceCase : Case.MIXED);
        String targetActual = SqlImplUtil.getActualName(target, name, targetIsPlain, this.casingProvider);
        boolean targetCaseSensitive = targetCase == Case.EXACT && !isBuiltInFunction;
        boolean sourceCaseSensitive = this.sourceCase == Case.EXACT && (!isBuiltInFunction || !this.sourcePlain);
        boolean bl = caseSensitive = (sourceCaseSensitive || targetCaseSensitive || forcedCaseSens == Boolean.TRUE) && forcedCaseSens != Boolean.FALSE;
        return Comparing.strEqual((String)targetActual, (String)this.sourceActual, (boolean)caseSensitive);
    }
}

