/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class SqlConstraintDefinitionImpl
extends SqlDefinitionImpl
implements SqlConstraintDefinition {
    public SqlConstraintDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlConstraintDefinition((SqlConstraintDefinition)this);
    }

    public SqlReferenceExpression getNameElement() {
        return this.findReferenceByType(SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.CONSTRAINT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    public <T> T getConstraintParameter(Key<T> key) {
        PsiElement child;
        if (key != EXPRESSION) {
            return null;
        }
        SqlReferenceExpression name = this.getNameElement();
        PsiElement psiElement = child = name == null ? this.getFirstChild() : name.getNextSibling();
        while (child != null) {
            if (child instanceof SqlExpression) {
                return (T)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    @NotNull
    public SqlConstraintDefinition.Type getConstraintType() {
        IElementType type = this.getNode().getElementType();
        if (type == SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type2 = SqlConstraintDefinition.Type.NOT_NULL;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type2;
        }
        if (type == SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type3 = SqlConstraintDefinition.Type.NULLABLE;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type3;
        }
        if (type == SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type4 = SqlConstraintDefinition.Type.COLLATE;
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
            }
            return type4;
        }
        SqlConstraintDefinition.Type type5 = SqlConstraintDefinition.Type.OTHER;
        if (type5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintDefinitionImpl", "getConstraintType"));
        }
        return type5;
    }

    public String getTableName() {
        DasTable table = this.getTable();
        return table == null ? null : table.getName();
    }

    public DasTable getTable() {
        return (DasTable)PsiTreeUtil.getParentOfType((PsiElement)this, SqlCreateTableStatement.class, (boolean)true);
    }

    @Override
    public DasObject getDbParent() {
        DasTable table = this.getTable();
        return table == null ? (DasObject)PsiTreeUtil.getParentOfType((PsiElement)this, SqlDefinition.class, (boolean)true) : table;
    }
}

