/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.stubs.SqlConstraintStub;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlConstraintStubbedDefinitionImpl
extends SqlStubbedDefinitionImpl<SqlConstraintStub>
implements SqlConstraintDefinition {
    public SqlConstraintStubbedDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlConstraintStubbedDefinitionImpl(SqlConstraintStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.getConstraintType() == SqlConstraintDefinition.Type.CHECK ? ObjectKind.CHECK : SqlDbElementType.CONSTRAINT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public SqlConstraintDefinition.Type getConstraintType() {
        IStubElementType type = this.getElementType();
        if (type == SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type2 = SqlConstraintDefinition.Type.CHECK;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl", "getConstraintType"));
            }
            return type2;
        }
        if (type == SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type3 = SqlConstraintDefinition.Type.DEFAULT;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl", "getConstraintType"));
            }
            return type3;
        }
        SqlConstraintDefinition.Type type4 = SqlConstraintDefinition.Type.OTHER;
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl", "getConstraintType"));
        }
        return type4;
    }

    @Nullable
    public <T> T getConstraintParameter(Key<T> key) {
        PsiElement child;
        if (key != EXPRESSION) {
            return null;
        }
        SqlConstraintStub stub = (SqlConstraintStub)this.getStub();
        if (stub != null) {
            return (T)stub.getExpression();
        }
        SqlReferenceExpression name = this.getNameElement();
        PsiElement psiElement = child = name == null ? this.getFirstChild() : name.getNextSibling();
        while (child != null) {
            if (child instanceof SqlExpression) {
                return (T)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public String getTableName() {
        DasTable table = this.getTable();
        return table == null ? null : table.getName();
    }

    public DasTable getTable() {
        return (DasTable)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, SqlCreateTableStatement.class);
    }

    @Override
    public DasObject getDbParent() {
        DasTable table = this.getTable();
        return table == null ? (DasObject)PsiTreeUtil.getParentOfType((PsiElement)this, SqlDefinition.class, (boolean)true) : table;
    }

    @Override
    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE;
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlCreateStatement statement;
        if (this.getConstraintType() == SqlConstraintDefinition.Type.CHECK && (statement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlCreateStatement.class, (boolean)true)) != null) {
            if (!processor.execute((PsiElement)statement, state)) {
                return false;
            }
            if (!statement.processDeclarations(processor, state, (PsiElement)statement, place)) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }
}

