/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateIndexStatementImpl
extends SqlKIFKImpl<SqlTableKeyStub<?>>
implements SqlCreateIndexStatement,
SqlTargetContextProvider {
    public SqlCreateIndexStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateIndexStatementImpl(SqlTableKeyStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_INDEX_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlElementTypes.SQL_INDEX_REFERENCE;
    }

    @Override
    public String getTableName() {
        SqlReferenceExpression ref = this.getTableReference();
        return ref == null ? null : ref.getText();
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateIndexStatement((SqlCreateIndexStatement)this);
    }

    @Nullable
    public SqlReferenceExpression getTableReference() {
        SqlTableColumnsList list = this.getTableColumnsList();
        return list == null ? null : list.getTableReference();
    }

    @Nullable
    private SqlTableColumnsList getTableColumnsList() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            return stub.getKeyColumnList();
        }
        SqlOnTargetClauseImpl target = (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)target, SqlTableColumnsList.class);
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl", "getColumnSorting"));
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl", "getColumnSorting"));
        }
        return sorting;
    }

    @Override
    @Nullable
    protected SqlReferenceList getColumnsList() {
        SqlTableColumnsList tableColumnsList = this.getTableColumnsList();
        return tableColumnsList == null ? null : tableColumnsList.getColumnsReferenceList();
    }

    public List<SqlReferenceExpression> getColumnReferences() {
        return SqlImplUtil.getReferenceList(this.getTableColumnsList());
    }

    @Override
    @Nullable
    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTableReference();
        if (ref == null) {
            return null;
        }
        for (ResolveResult result2 : ref.multiResolve(false)) {
            if (!(result2.getElement() instanceof DasTable)) continue;
            return (DasTable)result2.getElement();
        }
        return null;
    }

    public boolean isUnique() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getGreenStub();
        if (stub != null) {
            return stub.isUnique();
        }
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_UNIQUE) != null;
    }

    public boolean isFunctionBased() {
        return false;
    }

    public int getColumnCount() {
        return this.getColumnReferences().size();
    }

    public DasColumn getColumn(int index) {
        SqlReferenceExpression ref = this.getColumnReferences().get(index);
        for (ResolveResult result2 : ref.multiResolve(false)) {
            if (!(result2.getElement() instanceof DasColumn)) continue;
            return (DasColumn)result2.getElement();
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Index;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression reference = this.getTableReference();
        if (reference != null && !SqlImplUtil.processQualifier(reference, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public SqlReferenceExpression getTargetContextExpression() {
        return this.getTableReference();
    }
}

