/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlInheritedTableDefinition;
import com.intellij.sql.psi.SqlLikeTableClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlCreateTableStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlCreateTableLikeStatementImpl
extends SqlCreateTableStatementImpl
implements SqlInheritedTableDefinition {
    private static IElementType[] INHERITANCE_METHODS = new IElementType[]{SqlCompositeElementTypes.SQL_LIKE_TABLE_CLAUSE};

    public SqlCreateTableLikeStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateTableLikeStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    @NotNull
    public List<PsiColumn> getAdditionalColumnsImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAdditionalColumnsImpl"));
        }
        boolean sensitive = this.isColumnsCaseSensitive();
        List<SqlReferenceExpression> ancestors = this.getAncestors(elementType);
        ArrayList plainColumns = ContainerUtil.newArrayList();
        if (ancestors.isEmpty()) {
            ArrayList arrayList = plainColumns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAdditionalColumnsImpl"));
            }
            return arrayList;
        }
        for (SqlReferenceExpression ancestor : ancestors) {
            PsiElement element = ancestor.resolve();
            if (!(element instanceof PsiTable)) continue;
            List<PsiColumn> inherited = this.extractColumns((PsiTable)element);
            this.mergeInheritedColumns(elementType, plainColumns, inherited, sensitive);
        }
        ArrayList arrayList = plainColumns;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAdditionalColumnsImpl"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiColumn> getAdditionalColumns() {
        List<PsiColumn> list = this.getAdditionalColumnsImpl((IElementType)SqlCompositeElementTypes.SQL_LIKE_TABLE_CLAUSE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAdditionalColumns"));
        }
        return list;
    }

    protected void mergeInheritedColumns(@NotNull IElementType elementType, List<PsiColumn> into, List<PsiColumn> from, boolean sensitive) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "mergeInheritedColumns"));
        }
        into.addAll(from);
    }

    @NotNull
    public List<SqlReferenceExpression> getAncestors(@NotNull Object methodKey) {
        if (methodKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKey", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAncestors"));
        }
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            List<SqlReferenceExpression> list = stub.getAncestorRefs(ArrayUtil.indexOf((Object[])this.getInheritanceMethods(), (Object)methodKey));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAncestors"));
            }
            return list;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        for (SqlLikeTableClause clause : (SqlLikeTableClause[])this.findChildrenByClass(SqlLikeTableClause.class)) {
            if (clause.getNode().getElementType() != methodKey) continue;
            refs.addAll(clause.getTableReferences());
        }
        ArrayList arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getAncestors"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiColumn> calcColumns() {
        boolean caseSensitive = this.isColumnsCaseSensitive();
        List<PsiColumn> inherited = this.getQueryColumns();
        List<PsiColumn> res = ContainerUtil.concat(this.getDeclaredColumns(), this.getAdditionalColumns());
        inherited = SqlImplUtil.processColumnList(inherited, (List<? extends PsiColumn>)res, caseSensitive, null, false);
        res = SqlImplUtil.processColumnList((List<? extends PsiColumn>)res, inherited, caseSensitive, null, true);
        List list = ContainerUtil.concat(res, inherited);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "calcColumns"));
        }
        return list;
    }

    @NotNull
    public Object[] getInheritanceMethods() {
        if (INHERITANCE_METHODS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableLikeStatementImpl", "getInheritanceMethods"));
        }
        return INHERITANCE_METHODS;
    }
}

