/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class SqlLiteralExpressionImpl
extends SqlExpressionImpl
implements SqlLiteralExpression {
    public SqlLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlLiteralExpression((SqlLiteralExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "processDeclarations"));
        }
        return true;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        IElementType type = this.getNode().getElementType();
        if (type == SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BOOLEAN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL) {
            PsiElement child = this.getLastChild();
            IElementType childType = child == null ? null : child.getNode().getElementType();
            SqlPrimitiveType sqlPrimitiveType = childType == SqlCommonKeywords.SQL_DEFAULT ? SqlType.DEFAULT : SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) {
            IElementType childType;
            PsiElement child = this.getLastChild();
            IElementType iElementType = childType = child == null ? null : child.getNode().getElementType();
            SqlPrimitiveType sqlPrimitiveType = childType == null ? SqlType.UNKNOWN : (childType == SqlTokens.SQL_INTEGER_TOKEN ? SqlType.INTEGER : (childType == SqlTokens.SQL_FLOAT_TOKEN ? SqlType.REAL : SqlType.UNKNOWN));
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.SQL_ARRAY_LITERAL) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.ARRAY;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_TIMESTAMP) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.TIMESTAMP;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_DATE) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.DATE;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_TIME) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.TIME;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_ESCAPE) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.STRING;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_GENERIC) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (type == SqlCompositeElementTypes.ODBC_FUNCTION_CALL) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlLiteralExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        throw new AssertionError(type);
    }
}

