/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTypeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPsiElementFactory {
    @Nullable
    public static SqlTypeElement createDataTypeFromText(String text, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createDataTypeFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createDataTypeFromText"));
        }
        return SqlPsiElementFactory.createDataTypeFromText(text, language, context, false);
    }

    @Nullable
    public static SqlTypeElement createDataTypeFromText(String text, @NotNull SqlLanguageDialect language, @NotNull PsiElement context, boolean ext) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createDataTypeFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createDataTypeFromText"));
        }
        return (SqlTypeElement)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)(ext ? SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT : SqlCompositeElementTypes.SQL_TYPE_ELEMENT), context.getProject(), context);
    }

    @Nullable
    public static SqlExpression createExpressionFromText(String text, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createExpressionFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createExpressionFromText"));
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, context.getProject(), context);
    }

    @Nullable
    public static SqlExpression createExpressionFromText(String text, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createExpressionFromText"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createExpressionFromText"));
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, project, context);
    }

    @Nullable
    public static SqlReferenceExpression createReferenceFromText(String text, @NotNull SqlLanguageDialect language, @NotNull SqlReferenceElementType type, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createReferenceFromText"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createReferenceFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createReferenceFromText"));
        }
        return (SqlReferenceExpression)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)type, context.getProject(), context);
    }

    @Nullable
    public static SqlTableColumnsList createTableColumnListFromText(String text, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createTableColumnListFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createTableColumnListFromText"));
        }
        return (SqlTableColumnsList)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, context.getProject(), context);
    }

    @Nullable
    public static SqlExpression createQueryExpressionFromText(String text, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createQueryExpressionFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createQueryExpressionFromText"));
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, context.getProject(), context);
    }

    @Nullable
    public static SqlStatement createStatementFromText(String text, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createStatementFromText"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createStatementFromText"));
        }
        return (SqlStatement)SqlPsiElementFactory.createElementFromText(text, language, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT, project, context);
    }

    @Nullable
    public static SqlIdentifier createIdentifierFromText(@NotNull String text, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createIdentifierFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createIdentifierFromText"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createIdentifierFromText"));
        }
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)("select " + text));
        PsiElement parent = PsiTreeUtil.getDeepestLast((PsiElement)fileFromText).getParent();
        return parent instanceof SqlIdentifier ? (SqlIdentifier)parent : null;
    }

    @Nullable
    private static SqlElement createElementFromText(String text, @NotNull SqlLanguageDialect language, @NotNull IElementType type, @NotNull Project project, @Nullable PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createElementFromText"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createElementFromText"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createElementFromText"));
        }
        PsiElement result2 = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).createElementFromText(text, (Language)language, type, context);
        if (!(result2 instanceof SqlElement)) {
            SqlDialectImplUtil.LOG.error(language + " [" + text + "]: " + result2);
            return null;
        }
        return (SqlElement)result2;
    }

    @NotNull
    public static PsiElement createLeafFromText(Project project, @NotNull SqlLanguageDialect language, @NotNull String text) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createLeafFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createLeafFromText"));
        }
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)text);
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)fileFromText);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "createLeafFromText"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newLine(Project project) {
        PsiElement psiElement = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlPsiElementFactory", "newLine"));
        }
        return psiElement;
    }
}

