/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeElementImpl
extends SqlCompositeElementImpl
implements SqlTypeElement {
    private DataType myDataType;

    public SqlTypeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTypeElement((SqlTypeElement)this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myDataType = null;
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            int state = 0;
            String schema = null;
            String suffix = null;
            StringBuilder typeName = new StringBuilder();
            int i1 = -1;
            int i2 = 0;
            LengthUnit unit = null;
            for (ASTNode cur = this.getNode().getFirstChildNode(); cur != null; cur = cur.getTreeNext()) {
                IElementType type = cur.getElementType();
                boolean isIdentToken = type instanceof SqlKeywordTokenType || type instanceof SqlReferenceElementType || type == SqlCompositeElementTypes.SQL_TYPE_ELEMENT || type == SqlTokens.SQL_IDENT;
                String text = cur.getText();
                if (state == 0 && type == SqlCommonKeywords.SQL_TABLE) {
                    this.myDataType = DataTypeFactory.of(null, "table", this.getTableVagueArgs(), null);
                    if (this.myDataType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "getDataType"));
                    }
                    return this.myDataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_ENUM) {
                    this.myDataType = DataTypeFactory.of(null, "enum", this.getEnumVagueArgs(), null);
                    if (this.myDataType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "getDataType"));
                    }
                    return this.myDataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_SET) {
                    this.myDataType = DataTypeFactory.of(null, "set", this.getEnumVagueArgs(), null);
                    if (this.myDataType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "getDataType"));
                    }
                    return this.myDataType;
                }
                if (state < 2 && isIdentToken) {
                    state = 1;
                    if (typeName.length() == 0) {
                        typeName.append(text);
                        continue;
                    }
                    typeName.append(' ').append(text);
                    continue;
                }
                if (state < 2 && (type == SqlTokens.SQL_LEFT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACKET)) {
                    state = 1;
                    typeName.append(text);
                    continue;
                }
                if (state == 1 && type == SqlTokens.SQL_LEFT_PAREN) {
                    ++state;
                    continue;
                }
                if (state == 2 && type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) {
                    ++state;
                    i1 = StringUtil.parseInt((String)text, (int)i1);
                    continue;
                }
                if (state == 3 && type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) {
                    ++state;
                    i2 = StringUtil.parseInt((String)text, (int)i2);
                    continue;
                }
                if (state == 3 && type instanceof SqlKeywordTokenType) {
                    ++state;
                    unit = LengthUnit.of((String)text);
                    continue;
                }
                if (state > 1 && type == SqlTokens.SQL_RIGHT_PAREN) {
                    state = 10;
                    continue;
                }
                if (state != 10 || type != SqlTokens.SQL_IDENT) continue;
                ++state;
                suffix = text;
            }
            this.myDataType = DataTypeFactory.of(schema, typeName.length() == 0 ? DasUtil.NO_NAME : typeName.toString(), i1, i2, unit, suffix, unit != null, false);
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "getDataType"));
        }
        return dataType;
    }

    @Nullable
    private String getEnumVagueArgs() {
        SqlParenthesizedExpression child = (SqlParenthesizedExpression)this.findChildByClass(SqlParenthesizedExpression.class);
        Object[] items = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)child, SqlExpression.class);
        return items == null ? null : StringUtil.join((Object[])items, PsiElement::getText, (String)", ");
    }

    @Nullable
    private String getTableVagueArgs() {
        Object[] children = (SqlColumnDefinition[])this.findChildrenByClass(SqlColumnDefinition.class);
        return children.length == 0 ? null : StringUtil.join((Object[])children, PsiElement::getText, (String)", ");
    }

    @NotNull
    public SqlType findSqlType() {
        if (this.findChildByType((IElementType)SqlCommonKeywords.SQL_TABLE) != null) {
            List columns2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlColumnDefinitionImpl.class);
            if (columns2.isEmpty()) {
                SqlExpression expr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
                SqlTableType sqlTableType = expr != null ? SqlTableTypeBase.ensureTableType(expr.getSqlType(), (SqlElement)this, null) : SqlTableTypeBase.EMPTY_TABLE;
                if (sqlTableType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "findSqlType"));
                }
                return sqlTableType;
            }
            TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl(columns2, (PsiElement)this);
            if (tableBasedSqlTableTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "findSqlType"));
            }
            return tableBasedSqlTableTypeImpl;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)this.findChildByClass(SqlReferenceExpression.class);
        if (ref != null) {
            SqlType sqlType = ref.getSqlType();
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "findSqlType"));
            }
            return sqlType;
        }
        SqlType sqlType = SqlImplUtil.getSqlType(this.getDataType().typeName, SqlImplUtil.getSqlDialectSafe((PsiElement)this));
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTypeElementImpl", "findSqlType"));
        }
        return sqlType;
    }

    public String getDisplayName() {
        return this.getDataType().getSpecification();
    }
}

