/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

public class SqlValuesExpressionImpl
extends SqlExpressionImpl
implements SqlValuesExpression {
    public SqlValuesExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlValuesExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlValuesExpression((SqlValuesExpression)this);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlExpression firstExpression = (SqlExpression)this.getExpressions().first();
        if (firstExpression == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlValuesExpressionImpl", "getSqlType"));
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(firstExpression.getSqlType(), (SqlElement)firstExpression, (PsiElement)this);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlValuesExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    @NotNull
    public JBIterable<SqlExpression> getExpressions() {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlExpression.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlValuesExpressionImpl", "getExpressions"));
        }
        return jBIterable;
    }
}

