/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.model.DasForeignKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlForeignKeyStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlForeignKeyElementType
extends SqlStubElementType<SqlForeignKeyStub, SqlForeignKeyDefinitionImpl> {
    public static final NotNullFunction<String, SqlForeignKeyElementType> FACTORY = SqlForeignKeyElementType::new;

    public SqlForeignKeyElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public SqlForeignKeyStub createStub(@NotNull SqlForeignKeyDefinitionImpl psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "createStub"));
        }
        String tableName = psi.getTableName();
        Iterable columnNames = psi.getColumnsRef().names();
        String keyText = tableName == null ? null : SqlTableKeyElementType.tableColumnList(tableName, columnNames);
        SqlTableColumnsList tableColumnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)psi, SqlTableColumnsList.class);
        SqlForeignKeyStub sqlForeignKeyStub = new SqlForeignKeyStub(parentStub, this, SqlForeignKeyElementType.asStringRef((PsiElement)psi.getNameElement()), keyText == null ? null : StringRef.fromString((String)keyText), tableColumnsList == null ? null : StringRef.fromString((String)tableColumnsList.getText()), psi.getDeleteRule(), psi.getUpdateRule(), psi.getDeferrability());
        if (sqlForeignKeyStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "createStub"));
        }
        return sqlForeignKeyStub;
    }

    public void serialize(@NotNull SqlForeignKeyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getKeyText());
        dataStream.writeName(stub.getRefKeyText());
        dataStream.writeByte(SqlForeignKeyElementType.toOrd(stub.getDeleteRule()));
        dataStream.writeByte(SqlForeignKeyElementType.toOrd(stub.getUpdateRule()));
        dataStream.writeByte(SqlForeignKeyElementType.toOrd(stub.getDeferrability()));
    }

    private static int toOrd(Enum<?> rule) {
        return rule == null ? -1 : rule.ordinal();
    }

    private static <T extends Enum<?>> T fromOrd(int ord, Class<T> clazz) {
        if (ord == -1) {
            return null;
        }
        Enum[] values = (Enum[])clazz.getEnumConstants();
        return (T)(ord < values.length ? values[ord] : null);
    }

    @NotNull
    public SqlForeignKeyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "deserialize"));
        }
        SqlForeignKeyStub sqlForeignKeyStub = new SqlForeignKeyStub(parentStub, this, dataStream.readName(), dataStream.readName(), dataStream.readName(), SqlForeignKeyElementType.fromOrd(dataStream.readByte(), DasForeignKey.RuleAction.class), SqlForeignKeyElementType.fromOrd(dataStream.readByte(), DasForeignKey.RuleAction.class), SqlForeignKeyElementType.fromOrd(dataStream.readByte(), DasForeignKey.Deferrability.class));
        if (sqlForeignKeyStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "deserialize"));
        }
        return sqlForeignKeyStub;
    }
}

