/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlScriptModel<E>
extends ScriptModel<E> {
    private final Script<E> myScript;

    public SqlScriptModel(PsiFile file) {
        this(SqlScriptModel.newScriptFor(file));
    }

    private SqlScriptModel(Script<E> script) {
        this.myScript = script;
    }

    @NotNull
    private static <E> Script<E> newScriptFor(PsiFile file) {
        Document document;
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        Document document2 = document = SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            TrackingDocScript trackingDocScript = new TrackingDocScript(project, virtualFile, document);
            if (trackingDocScript == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "newScriptFor"));
            }
            return trackingDocScript;
        }
        FileScript fileScript = new FileScript(project, virtualFile, null, false);
        if (fileScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "newScriptFor"));
        }
        return fileScript;
    }

    @NotNull
    private Project getProject() {
        Project project = this.myScript.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "getProject"));
        }
        return project;
    }

    public VirtualFile getVirtualFile() {
        return this.myScript.vFile;
    }

    public SqlScriptModel<E> subModel(@Nullable TextRange range, boolean atPosition) {
        return new SqlScriptModel<E>(this.myScript.subScript(range, atPosition));
    }

    public JBIterable<? extends ScriptModel.StatementIt<E>> statements() {
        return new SIt(this.myScript.getScript(), this.TO_STATEMENTS()).cursor();
    }

    public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
        return new PIt(this.myScript.getScript(), this.TO_PARAMETERS()).cursor();
    }

    public TextRange getTextRange() {
        return this.myScript.range;
    }

    public boolean isAtPosition() {
        return this.myScript.range != null && this.myScript.atPosition;
    }

    public void dispose() {
        super.dispose();
        if (this.myScript instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myScript));
        }
    }

    @NotNull
    private <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> TO_STATEMENTS() {
        Function function = s -> SqlScriptModel.statementsImpl(this.myScript, s);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "TO_STATEMENTS"));
        }
        return function;
    }

    @NotNull
    private <V> Function<SyntaxTraverser<V>, Iterable<V>> TO_PARAMETERS() {
        Function function = s -> SqlScriptModel.parametersImpl(this.myScript, s);
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "TO_PARAMETERS"));
        }
        return function;
    }

    private static <V> SyntaxTraverser<V> statementsImpl(final Script script, final SyntaxTraverser<V> s) {
        if (script.range == null) {
            return s;
        }
        final SqlLanguageDialect dialect = script.getDialect();
        final int offset = ScriptModelUtil.getPartOffsetAsInt(s);
        final boolean leavesOnly = !script.atPosition && script.range.getLength() > 0;
        Condition filter = Conditions.and2((Condition)Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class, SqlResultSetExpression.class}), (Condition)Conditions.not((Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.or2((Condition)Conditions.is((Object)SqlElementTypes.SQL_DUMMY_BLOCK), (Condition)Conditions.instanceOf((Class[])new Class[]{SqlLazyElementType.class, IsExternal.class})))));
        Condition<SqlStatement> fileFilter = ScriptModelUtil.wholeFileCondition(s.forceDisregardTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK)), leavesOnly, SqlStatement.class);
        final Condition resultFilter = Conditions.or2((Condition)filter, fileFilter);
        SyntaxTraverser adjusted = (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).filter(resultFilter)).regard(filter)).regard((Condition)new FilteredTraverserBase.EdgeFilter<V>(){

            public boolean value(V v) {
                Object parent;
                IElementType type = s.api.typeOf(v);
                if (type == SqlCompositeElementTypes.SQL_BATCH_BLOCK && ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).withRoot(v)).expandAndSkip(Conditions.is(v))).filter(Conditions.instanceOf(SqlStatement.class))).traverse().take(2).size() < 2) {
                    return false;
                }
                Object object = parent = this.edgeSource != null && resultFilter.value(this.edgeSource) ? this.edgeSource : null;
                if (parent == null) {
                    return true;
                }
                TextRange vr = s.api.rangeOf(v);
                TextRange pr = s.api.rangeOf(parent);
                if (leavesOnly && v instanceof SqlResultSetExpression) {
                    return false;
                }
                if (type == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT && parent instanceof SqlDefinition && !dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
                    return false;
                }
                if (script.range.contains(pr.shiftRight(offset))) {
                    return false;
                }
                return !pr.equals((Object)vr);
            }
        });
        SyntaxTraverser ranged = ScriptModelUtil.inRange(adjusted, script.range);
        return (SyntaxTraverser)ranged.withTraversal(leavesOnly ? TreeTraversal.LEAVES_DFS : TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    protected static <V> JBIterable<V> parametersImpl(Script script, SyntaxTraverser<V> s) {
        DatabaseFamilyId familyId = script.getDialect().getDatabaseDialect().getFamilyId();
        Condition canHaveParams = v -> SqlScriptModel.canHaveParameters(v, s.api);
        Condition isParameter = v -> SqlScriptModel.isParameter(v, s, familyId);
        Function statementParams = v -> (SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.reset()).withRoot(v)).expand(canHaveParams)).filter(isParameter);
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlScriptModel.statementsImpl(script, s).expand(Conditions.not((Condition)Conditions.and2((Condition)canHaveParams, (Condition)Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class, SqlResultSetExpression.class}))))).filter(canHaveParams)).traverse().flatten(statementParams);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "parametersImpl"));
        }
        return jBIterable;
    }

    @NotNull
    private static SqlLanguageDialect getSqlDialect(@NotNull VirtualFile vFile, Project project) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/sql/script/SqlScriptModel", "getSqlDialect"));
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)vFile);
        SqlLanguageDialect sqlLanguageDialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : DbSqlUtil.getGenericDialect();
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public <EE> ScriptModel<EE> rawTransform(Function<SyntaxTraverser<E>, SyntaxTraverser<EE>> function) {
        class A
        extends Script<EE> {
            final Script<E> delegate;
            final /* synthetic */ Function val$function;
            final /* synthetic */ SqlScriptModel this$0;

            public A(Script<E> delegate) {
                this.this$0 = this$0;
                this.val$function = var3_3;
                super(delegate.project, delegate.vFile, delegate.range, delegate.atPosition);
                this.delegate = delegate;
            }

            @Override
            JBIterable<SyntaxTraverser<EE>> getScript() {
                return this.delegate.getScript().transform(this.val$function);
            }

            @Override
            Script<EE> subScript(@Nullable TextRange range, boolean atPosition) {
                return new A(this.this$0, this.delegate.subScript(range, atPosition), this.val$function);
            }

            @Override
            UserDataHolder getParamDataHolder() {
                return this.delegate.getParamDataHolder();
            }
        }
        SqlScriptModel<E> sqlScriptModel = new SqlScriptModel<E>(new A(this, this.myScript.subScript(this.myScript.range, this.myScript.atPosition), function));
        if (sqlScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel", "rawTransform"));
        }
        return sqlScriptModel;
    }

    private static <V> boolean canHaveParameters(V node, SyntaxTraverser.Api<V> api) {
        IElementType type = api.typeOf(node);
        if (type instanceof SqlTokenType) {
            return false;
        }
        if (type == SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT) {
            return true;
        }
        return type != SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    private static <V> boolean isParameter(V node, SyntaxTraverser<V> s, DatabaseFamilyId familyId) {
        SyntaxTraverser.Api api = s.api;
        IElementType type = api.typeOf(node);
        boolean result2 = type == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        if ((result2 |= type == SqlTokens.SQL_EXTERNAL_PARAM) && familyId.isOracle() && s.api.parents(node).transform(api.TO_TYPE).contains((Object)SqlCompositeElementTypes.SQL_EXPLAIN_STATEMENT)) {
            CharSequence text = api.textOf(node);
            return !"?".equals(text) && !StringUtil.startsWith((CharSequence)text, (CharSequence)":");
        }
        return result2;
    }

    private Object statementType(@NotNull ScriptModel.StatementIt it, @NotNull JdbcConsole console) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/sql/script/SqlScriptModel", "statementType"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/sql/script/SqlScriptModel", "statementType"));
        }
        return DbSqlUtil.parseQueryType(this.getProject(), this.myScript.getDialect(), DbSqlUtil.findAnyContext(console.getProject(), (DatabaseSystem)console.getDataSource(), console.getCurrentNamespace()), it.text(), this.myScript.createReader());
    }

    private class PIt
    extends MIt<PIt>
    implements ScriptModel.ParamIt<E> {
        public PIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, Iterable<E>> transform) {
            super(s, transform);
        }

        public String displayName() {
            String base = this.nameBase();
            return base != null ? base : this.adjustName(null);
        }

        public Iterable<String> description() {
            return ScriptModelUtil.getRelativeSnippet(this.current(), this.traverser.api);
        }

        public String name() {
            return this.adjustName(this.nameBase());
        }

        @NotNull
        protected String adjustName(String base) {
            String known = ScriptModelUtil.ParamHelper.getParameterId(this, base, SqlScriptModel.this.myScript.getParamDataHolder());
            String string = known != null ? known : (base != null ? base : this.text() + " #" + ((long)this.range().getStartOffset() + this.rangeOffset()));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$PIt", "adjustName"));
            }
            return string;
        }

        private String nameBase() {
            Object o = this.current();
            String name = o instanceof SqlParameter ? ((SqlParameter)o).getName() : null;
            return StringUtil.nullize((String)name);
        }
    }

    private class SIt
    extends MIt<SIt>
    implements ScriptModel.StatementIt<E> {
        SIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            super(s, transform);
        }

        public String text(ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<E>> paramCondition) {
            return ScriptModelUtil.statementText(this, storage, paramCondition);
        }

        public Object resultType(Object target) {
            return SqlScriptModel.this.statementType(this, (JdbcConsole)target);
        }

        public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
            return new PIt(JBIterable.of((Object)this.traverser.withRoot(this.current())), SqlScriptModel.this.TO_PARAMETERS()).cursor();
        }
    }

    private class MIt<Self extends MIt<Self>>
    extends ScriptModel.ModelItBase<E, Self> {
        long rangeOffset;
        JBIterator<E> vIt;
        SyntaxTraverser<E> nextTr;

        MIt(JBIterable<SyntaxTraverser<E>> s, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            this.vIt = JBIterator.from((Iterator)s.flatten(vs -> {
                this.nextTr = vs;
                return (Iterable)transform.fun(vs);
            }).iterator());
        }

        protected E nextImpl() {
            return this.vIt.hasNext() ? this.vIt.next() : this.stop();
        }

        protected void currentChanged() {
            if (this.nextTr == null) {
                return;
            }
            this.traverser = this.nextTr;
            this.nextTr = null;
            this.rangeOffset = ScriptModelUtil.getPartOffset(this.traverser);
        }

        public long rangeOffset() {
            return this.rangeOffset;
        }
    }

    private static class FileScript
    extends ScriptBase<LighterASTNode, FileScript>
    implements Disposable {
        FileScript(Project project, VirtualFile virtualFile, TextRange range, boolean atPosition) {
            super(project, virtualFile, range, atPosition);
        }

        @Override
        FileScript subScript(@Nullable TextRange range, boolean atPosition) {
            return new FileScript(this.project, this.vFile, range, atPosition);
        }

        @Override
        UserDataHolder getParamDataHolder() {
            return this.vFile;
        }

        @Override
        JBIterable<SyntaxTraverser<LighterASTNode>> getScript() {
            boolean inRange = !this.atPosition && this.range != null && this.range.getLength() > 0;
            SqlReaderImpl r = new SqlReaderImpl(this.project);
            JBIterable result2 = r.parseSql(this.getDialect(), this.vFile, this);
            if (inRange) {
                result2 = result2.transform(ScriptModelUtil.LIMIT_TO_RANGE(this.range));
            }
            return result2;
        }

        public void dispose() {
        }
    }

    private static class SealedDocScript
    extends DocScript {
        final SealedDocScript parent;
        final SqlLanguageDialect dialect;
        final CharSequence text;
        final long timeStamp;
        SyntaxTraverser<PsiElement> raw;
        JBIterable<SyntaxTraverser<PsiElement>> cached;

        SealedDocScript(Project project, VirtualFile file, Document document, SqlLanguageDialect dialect) {
            super(project, file, document);
            this.text = document.getImmutableCharSequence();
            this.timeStamp = document.getModificationStamp();
            this.dialect = dialect;
            this.parent = null;
        }

        SealedDocScript(SealedDocScript sealed, TextRange range, boolean atPosition) {
            super(sealed, range, atPosition);
            this.text = sealed.text;
            this.timeStamp = sealed.timeStamp;
            this.dialect = sealed.dialect;
            this.parent = sealed;
        }

        @Override
        SqlLanguageDialect getDialect() {
            return this.dialect;
        }

        @Override
        @NotNull
        JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            JBIterable<SyntaxTraverser<PsiElement>> jBIterable = this.cached != null ? this.cached : (this.cached = this.getScriptImpl());
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "getScript"));
            }
            return jBIterable;
        }

        @Override
        DocScript subScript(@Nullable TextRange range, boolean atPosition) {
            SealedDocScript p = this.parent == null ? this : this.parent;
            return range == null ? p : new SealedDocScript(p, range, atPosition);
        }

        @NotNull
        SyntaxTraverser<PsiElement> parseRaw() {
            SyntaxTraverser<PsiElement> syntaxTraverser;
            if (this.parent != null) {
                syntaxTraverser = this.parent.parseRaw();
            } else if (this.raw != null) {
                syntaxTraverser = this.raw;
            } else {
                this.raw = SealedDocScript.parseImpl(this.dialect, this.text, this.createReader());
                syntaxTraverser = this.raw;
            }
            if (syntaxTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "parseRaw"));
            }
            return syntaxTraverser;
        }

        @NotNull
        static SyntaxTraverser<PsiElement> parseImpl(SqlLanguageDialect dialect, CharSequence documentText, SqlReaderImpl r) {
            SyntaxTraverser<PsiElement> syntaxTraverser = SqlReaderImpl.getStatementTraverser(SqlImplUtil.sqlTraverser((PsiElement)r.getReadOnlyPsi(dialect, documentText)));
            if (syntaxTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "parseImpl"));
            }
            return syntaxTraverser;
        }

        @NotNull
        JBIterable<SyntaxTraverser<PsiElement>> getScriptImpl() {
            boolean inRange = !this.atPosition && this.range != null;
            DatabaseSettings settings = DatabaseSettings.getSettings();
            SqlReaderImpl r = this.createReader();
            this.raw = this.parseRaw();
            if (inRange) {
                boolean justOne;
                JBIterable adjusted = SqlScriptModel.statementsImpl(this, this.raw).traverse();
                boolean singleBatch = this.dialect.getDatabaseDialect().getFamilyId().isTransactSql() && adjusted.filter(SqlBatchBlock.class).isEmpty();
                boolean bl = justOne = settings.executeSelectionOption == 1 || settings.executeSelectionOption == 2 || adjusted.take(2).size() == 1 || singleBatch && adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.IN_RANGE(this.range))).isEmpty() || adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.CONTAINS_RANGE(this.range))).isEmpty();
                if (justOne) {
                    PsiElement first;
                    SyntaxTraverser<PsiElement> exact = SealedDocScript.parseImpl(this.dialect, this.range.subSequence(this.text), r);
                    exact.putUserData(SqlReader.PART_OFFSET, (Object)this.range.getStartOffset());
                    if (settings.executeSelectionOption == 3 && adjusted.take(2).size() == 1 && ((first = (PsiElement)exact.traverse().first()) == null || first.getTextRange().getStartOffset() != 0)) {
                        JBIterable jBIterable = JBIterable.of(this.raw);
                        if (jBIterable == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "getScriptImpl"));
                        }
                        return jBIterable;
                    }
                    JBIterable jBIterable = JBIterable.of(exact);
                    if (jBIterable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "getScriptImpl"));
                    }
                    return jBIterable;
                }
            }
            JBIterable jBIterable = JBIterable.of(this.raw);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$SealedDocScript", "getScriptImpl"));
            }
            return jBIterable;
        }
    }

    private static class TrackingDocScript
    extends DocScript {
        SealedDocScript sealed;

        TrackingDocScript(Project project, VirtualFile file, Document document) {
            super(project, file, document);
        }

        @Override
        DocScript subScript(@Nullable TextRange range, boolean atPosition) {
            return this.getSealed().subScript(range, atPosition);
        }

        @Override
        JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            return this.getSealed().getScript();
        }

        SealedDocScript getSealed() {
            SqlLanguageDialect dialect = this.getDialect();
            if (this.sealed == null || this.sealed.timeStamp != this.document.getModificationStamp() || this.sealed.dialect != dialect) {
                this.sealed = new SealedDocScript(this.project, this.vFile, this.document, dialect);
            }
            return this.sealed;
        }
    }

    private static abstract class DocScript
    extends ScriptBase<PsiElement, DocScript> {
        final Document document;

        DocScript(Project project, VirtualFile file, Document document) {
            super(project, file, null, false);
            this.document = document;
        }

        DocScript(DocScript script, TextRange range, boolean atPosition) {
            super(script.project, script.vFile, range, atPosition);
            this.document = script.document;
        }

        @Override
        UserDataHolder getParamDataHolder() {
            return this.document;
        }
    }

    private static abstract class ScriptBase<V, Self extends ScriptBase<V, Self>>
    extends Script<V> {
        ScriptBase(Project project, VirtualFile file, TextRange range, boolean atPosition) {
            super(project, file, range, atPosition);
        }

        @Override
        abstract JBIterable<SyntaxTraverser<V>> getScript();

        abstract Self subScript(@Nullable TextRange var1, boolean var2);
    }

    private static abstract class Script<V> {
        final Project project;
        final VirtualFile vFile;
        final TextRange range;
        final boolean atPosition;

        private Script(Project project, VirtualFile vFile, TextRange range, boolean atPosition) {
            this.project = project;
            this.vFile = vFile;
            this.range = range;
            this.atPosition = atPosition;
        }

        SqlLanguageDialect getDialect() {
            return SqlScriptModel.getSqlDialect(this.vFile, this.project);
        }

        abstract JBIterable<SyntaxTraverser<V>> getScript();

        abstract Script<V> subScript(@Nullable TextRange var1, boolean var2);

        abstract UserDataHolder getParamDataHolder();

        @NotNull
        SqlReaderImpl createReader() {
            VirtualFile virtualFile = this.vFile;
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            SqlReaderImpl sqlReaderImpl = new SqlReaderImpl(this.project, Comparing.equal((Object)virtualFile, (Object)this.vFile) ? null : LanguageUtil.getFileLanguage((VirtualFile)virtualFile));
            if (sqlReaderImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$Script", "createReader"));
            }
            return sqlReaderImpl;
        }
    }
}

