/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;

public class GradleWebFrameworkSupportProvider
extends GradleFrameworkSupportProvider {
    private static final Logger LOG = Logger.getInstance(GradleWebFrameworkSupportProvider.class);
    public static final String ID = "web";

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        FrameworkTypeEx frameworkTypeEx = new FrameworkTypeEx(ID){

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                GradleWebFrameworkSupportProvider gradleWebFrameworkSupportProvider = GradleWebFrameworkSupportProvider.this;
                if (gradleWebFrameworkSupportProvider == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider$1", "createProvider"));
                }
                return gradleWebFrameworkSupportProvider;
            }

            @NotNull
            public String getPresentableName() {
                if ("Web" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider$1", "getPresentableName"));
                }
                return "Web";
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.Javaee.WebModule;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider$1", "getIcon"));
                }
                return icon;
            }
        };
        if (frameworkTypeEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider", "getFrameworkType"));
        }
        return frameworkTypeEx;
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider", "addSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider", "addSupport"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider", "addSupport"));
        }
        if (buildScriptData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildScriptData", "org/jetbrains/plugins/gradle/service/project/data/javaee/GradleWebFrameworkSupportProvider", "addSupport"));
        }
        buildScriptData.addPluginDefinition("apply plugin: 'war'").addRepositoriesDefinition("mavenCentral()").addDependencyNotation("testCompile group: 'junit', name: 'junit', version: '4.11'");
        String webRootPath = buildScriptData.getBuildScriptFile().getParent().getPath() + "/src/main/webapp";
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)webRootPath), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = module.getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }
}

