/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans;

import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebflowDiagramNode
extends DiagramNodeBase<WebflowElementWrapper> {
    @NotNull
    private final WebflowElementWrapper myElement;

    public WebflowDiagramNode(@NotNull WebflowElementWrapper element, @NotNull DiagramProvider<WebflowElementWrapper> provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/diagram/beans/WebflowDiagramNode", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/spring/webflow/diagram/beans/WebflowDiagramNode", "<init>"));
        }
        super(provider);
        this.myElement = element;
    }

    public String getTooltip() {
        return StringUtil.notNullize((String)this.myElement.getName(), (String)"<unknown>");
    }

    public Icon getIcon() {
        return this.myElement.getIcon();
    }

    @NotNull
    public WebflowElementWrapper getIdentifyingElement() {
        WebflowElementWrapper webflowElementWrapper = this.myElement;
        if (webflowElementWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/WebflowDiagramNode", "getIdentifyingElement"));
        }
        return webflowElementWrapper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WebflowDiagramNode that = (WebflowDiagramNode)((Object)o);
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return 31 * this.myElement.hashCode();
    }
}

