/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.webflow.config.model.xml.version1_0.Location;
import com.intellij.spring.webflow.config.model.xml.version1_0.Registry;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocation;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocationPattern;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.model.impl.FlowDefinition;
import com.intellij.spring.webflow.references.CodeSetupPsiReferenceContributor;
import com.intellij.spring.webflow.util.WebflowConfigUtil;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlowDefinitionCollector {
    private final Module module;
    private final List<FlowDefinition> myDefinitions = new SmartList();

    private FlowDefinitionCollector(Module module) {
        this.module = module;
    }

    static List<FlowDefinition> forModule(Module module) {
        return new FlowDefinitionCollector(module).collect();
    }

    private List<FlowDefinition> collect() {
        if (!WebflowUtil.isWebFlowAvailable(this.module)) {
            return Collections.emptyList();
        }
        WebflowVersion webflowVersion = WebflowVersionDetector.detect(this.module);
        if (!webflowVersion.isAtLeast(WebflowVersion.Webflow_2_0)) {
            return this.collectWebflow10Definitions();
        }
        List<FlowRegistry> flowRegistries = WebflowConfigUtil.getFlowRegistries(this.module);
        for (FlowRegistry registry : flowRegistries) {
            for (FlowLocation flowLocation : registry.getFlowLocations()) {
                PsiFileSystemItem file = (PsiFileSystemItem)flowLocation.getPath().getValue();
                this.addDomFlowDefinition(registry, flowLocation, (GenericDomValue)flowLocation.getPath(), file);
            }
            for (FlowLocationPattern pattern : registry.getFlowLocationPatterns()) {
                PsiReference[] references;
                XmlAttributeValue element = pattern.getValue().getXmlAttributeValue();
                if (element == null) continue;
                for (PsiReference reference : references = element.getReferences()) {
                    ResolveResult[] results;
                    if (!(reference instanceof FileReference)) continue;
                    for (ResolveResult result : results = ((FileReference)reference).multiResolve(false)) {
                        PsiElement resolve = result.getElement();
                        if (!(resolve instanceof PsiFileSystemItem)) continue;
                        PsiFileSystemItem file = (PsiFileSystemItem)resolve;
                        this.addDomFlowDefinition(registry, pattern, (GenericDomValue)pattern.getValue(), file);
                    }
                }
            }
        }
        List<JamSpringBeanPointer> codeConfigs = WebflowConfigUtil.getCodeFlowRegistries(this.module);
        for (JamSpringBeanPointer config : codeConfigs) {
            PsiElement configPsiElement = config.getPsiElement();
            if (configPsiElement == null) continue;
            VirtualFile basePathFile = null;
            for (PsiLiteral literal : SyntaxTraverser.psiTraverser((PsiElement)configPsiElement).filter(PsiLiteral.class)) {
                if (!CodeSetupPsiReferenceContributor.BASE_PATH.accepts((Object)literal)) continue;
                PsiFileSystemItem basePathFileItem = (PsiFileSystemItem)ContainerUtil.getFirstItem(FlowDefinitionCollector.getFilesFromLiteral(literal));
                basePathFile = basePathFileItem != null ? basePathFileItem.getVirtualFile() : null;
                break;
            }
            for (PsiLiteral literal : SyntaxTraverser.psiTraverser((PsiElement)configPsiElement).filter(PsiLiteral.class)) {
                if (CodeSetupPsiReferenceContributor.ADD_FLOW_LOCATION.accepts((Object)literal)) {
                    Collection<PsiFileSystemItem> files = FlowDefinitionCollector.getFilesFromLiteral(literal);
                    PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)ContainerUtil.getFirstItem(files);
                    if (fileSystemItem == null || files.size() != 1) continue;
                    VirtualFile flowXml = fileSystemItem.getVirtualFile();
                    DelegatePsiTarget definition = new DelegatePsiTarget((PsiElement)literal);
                    String flowName = (String)ObjectUtils.chooseNotNull((Object)FlowDefinitionCollector.getCodeCustomFlowName(literal), (Object)FlowDefinitionCollector.getCodeFlowName(flowXml, basePathFile));
                    this.myDefinitions.add(new FlowDefinition(flowXml, (PomTarget)definition, flowName));
                    continue;
                }
                if (!CodeSetupPsiReferenceContributor.ADD_FLOW_LOCATION_PATTERN.accepts((Object)literal)) continue;
                DelegatePsiTarget definition = new DelegatePsiTarget((PsiElement)literal);
                Collection<PsiFileSystemItem> files = FlowDefinitionCollector.getFilesFromLiteral(literal);
                for (PsiFileSystemItem file : files) {
                    VirtualFile flowXml = file.getVirtualFile();
                    this.myDefinitions.add(new FlowDefinition(flowXml, (PomTarget)definition, FlowDefinitionCollector.getCodeFlowName(flowXml, basePathFile)));
                }
            }
        }
        return this.myDefinitions;
    }

    @Nullable
    private static String getCodeCustomFlowName(PsiLiteral literal) {
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)literal, PsiExpressionList.class);
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        if (expressions.length == 1) {
            return null;
        }
        Pair customIdExpression = StringExpressionHelper.evaluateConstantExpression((PsiElement)expressions[1]);
        return customIdExpression != null ? (String)customIdExpression.second : null;
    }

    private static Collection<PsiFileSystemItem> getFilesFromLiteral(PsiLiteral literal) {
        return SpringResourcesUtil.getInstance().getResourceItems(literal.getReferences(), Conditions.alwaysTrue());
    }

    private static String getCodeFlowName(VirtualFile flowXml, @Nullable VirtualFile basePathFile) {
        return (String)ObjectUtils.chooseNotNull((Object)FlowDefinitionCollector.determineBasePathRelativeName(flowXml, basePathFile), (Object)flowXml.getNameWithoutExtension());
    }

    private List<FlowDefinition> collectWebflow10Definitions() {
        List<Registry> flowRegistries = WebflowConfigUtil.getFlowRegistries10(this.module);
        for (Registry registry : flowRegistries) {
            for (Location location : registry.getLocations()) {
                VirtualFile flowVirtualFile;
                PsiFileSystemItem file = (PsiFileSystemItem)location.getPath().getValue();
                if (file == null || (flowVirtualFile = file.getVirtualFile()) == null) continue;
                DomTarget locationTarget = DomTarget.getTarget((DomElement)location, location.getPath());
                this.myDefinitions.add(new FlowDefinition(flowVirtualFile, (PomTarget)locationTarget, flowVirtualFile.getNameWithoutExtension()));
            }
        }
        List<SpringProperty> properties = WebflowConfigUtil.getAdditionalConfigProperties(this.module);
        if (properties.isEmpty()) {
            return this.myDefinitions;
        }
        WebflowDomModelManager webflowDomModelManager = WebflowDomModelManager.getInstance(this.module.getProject());
        PairProcessor processor = (genericDomValue, s) -> {
            Object value = genericDomValue.getValue();
            if (!(value instanceof Set)) {
                return true;
            }
            Set set = (Set)value;
            for (Object o : set) {
                VirtualFile virtualFile;
                XmlFile xmlFile;
                if (!(o instanceof XmlFile) || !webflowDomModelManager.isWebflow(xmlFile = (XmlFile)o) || (virtualFile = xmlFile.getVirtualFile()) == null) continue;
                DomTarget target = DomTarget.getTarget((DomElement)genericDomValue, (GenericDomValue)genericDomValue);
                this.myDefinitions.add(new FlowDefinition(virtualFile, (PomTarget)target, virtualFile.getNameWithoutExtension()));
            }
            return true;
        };
        for (SpringProperty property : properties) {
            SpringPropertyUtils.processSpringValues((SpringProperty)property, (PairProcessor)processor);
        }
        return this.myDefinitions;
    }

    private void addDomFlowDefinition(@NotNull FlowRegistry flowRegistry, @NotNull DomElement definitionElement, @NotNull GenericDomValue definitionNavigationAttribute, @Nullable PsiFileSystemItem file) {
        if (flowRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowRegistry", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "addDomFlowDefinition"));
        }
        if (definitionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionElement", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "addDomFlowDefinition"));
        }
        if (definitionNavigationAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionNavigationAttribute", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "addDomFlowDefinition"));
        }
        if (file == null || file.isDirectory()) {
            return;
        }
        VirtualFile flowVirtualFile = file.getVirtualFile();
        if (flowVirtualFile == null) {
            return;
        }
        DomTarget definitionTarget = DomTarget.getTarget((DomElement)definitionElement, (GenericDomValue)definitionNavigationAttribute);
        FlowDefinition flowDefinition = new FlowDefinition(flowVirtualFile, (PomTarget)definitionTarget, FlowDefinitionCollector.getFlowName(flowRegistry, definitionElement, flowVirtualFile));
        this.myDefinitions.add(flowDefinition);
    }

    @NotNull
    private static String getFlowName(@NotNull FlowRegistry flowRegistry, @NotNull DomElement definition, @NotNull VirtualFile virtualFile) {
        if (flowRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowRegistry", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
        }
        if (definition instanceof FlowLocation) {
            FlowLocation flowLocation = (FlowLocation)definition;
            if (DomUtil.hasXml(flowLocation.getId())) {
                String string = flowLocation.getId().getStringValue();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
                }
                return string;
            }
            String basePathId = FlowDefinitionCollector.determineFlowId(flowRegistry, virtualFile);
            if (basePathId != null) {
                String string = basePathId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
                }
                return string;
            }
            String string = virtualFile.getNameWithoutExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
            }
            return string;
        }
        if (definition instanceof FlowLocationPattern) {
            String basePathId = FlowDefinitionCollector.determineFlowId(flowRegistry, virtualFile);
            if (basePathId != null) {
                String string = basePathId;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
                }
                return string;
            }
            String string = virtualFile.getNameWithoutExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "getFlowName"));
            }
            return string;
        }
        throw new IllegalArgumentException("unknown definition type " + definition);
    }

    @Nullable
    private static String determineFlowId(FlowRegistry flowRegistry, VirtualFile flowXml) {
        if (!DomUtil.hasXml(flowRegistry.getBasePath())) {
            return null;
        }
        PsiFileSystemItem basePath = (PsiFileSystemItem)flowRegistry.getBasePath().getValue();
        if (basePath == null) {
            return null;
        }
        VirtualFile baseVirtualFile = basePath.getVirtualFile();
        return FlowDefinitionCollector.determineBasePathRelativeName(flowXml, baseVirtualFile);
    }

    @Nullable
    private static String determineBasePathRelativeName(@NotNull VirtualFile flowXml, @Nullable VirtualFile baseVirtualFile) {
        if (flowXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowXml", "com/intellij/spring/webflow/model/impl/FlowDefinitionCollector", "determineBasePathRelativeName"));
        }
        if (baseVirtualFile == null) {
            return null;
        }
        String relativeFlowXmlPath = VfsUtilCore.getRelativePath((VirtualFile)flowXml, (VirtualFile)baseVirtualFile, (char)'/');
        if (relativeFlowXmlPath == null) {
            return null;
        }
        int lastSlashIdx = relativeFlowXmlPath.lastIndexOf(47);
        return lastSlashIdx == -1 ? relativeFlowXmlPath : relativeFlowXmlPath.substring(0, lastSlashIdx);
    }
}

