/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.android.util.BufferingFolderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferingFileWrapper
implements IAbstractFile {
    private final File myFile;

    public BufferingFileWrapper(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/BufferingFileWrapper", "<init>"));
        }
        this.myFile = file;
    }

    @Override
    public InputStream getContents() throws StreamException {
        try {
            byte[] content = this.readFile();
            return new ByteArrayInputStream(content);
        }
        catch (IOException e) {
            throw new StreamException(e, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile() throws IOException {
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myFile));){
            byte[] data = new byte[(int)this.myFile.length()];
            is.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/BufferingFileWrapper", "getFile"));
        }
        return file;
    }

    @Override
    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getModificationStamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.myFile.getName();
    }

    @Override
    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public boolean exists() {
        return this.myFile.isFile();
    }

    @Override
    @Nullable
    public IAbstractFolder getParentFolder() {
        File parentFile = this.myFile.getParentFile();
        return parentFile != null ? new BufferingFolderWrapper(parentFile) : null;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferingFileWrapper wrapper = (BufferingFileWrapper)o;
        return FileUtil.filesEqual((File)this.myFile, (File)wrapper.myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.myFile).toString();
    }
}

