/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.bijection.SeamJamBijection;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamBijectionUndefinedContextVariableInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        Module module = seamJamComponent.getModule();
        for (SeamJamInjection injection : seamJamComponent.getInjections()) {
            SeamBijectionUndefinedContextVariableInspection.checkInjectionContextVariableExisted(holder, injection, module);
        }
        for (SeamJamOutjection outjection : seamJamComponent.getOutjections()) {
            SeamBijectionUndefinedContextVariableInspection.checkOutjectionContextVariableExisted(holder, outjection, module);
        }
    }

    private static void checkInjectionContextVariableExisted(ProblemsHolder holder, SeamJamInjection baseSeamInjection, Module module) {
        SeamBijectionUndefinedContextVariableInspection.checkContextVariableExisted(holder, baseSeamInjection, module);
    }

    private static void checkOutjectionContextVariableExisted(ProblemsHolder holder, SeamJamOutjection outjection, Module module) {
        SeamComponentScope scope = outjection.getScope();
        if (scope != null && scope != SeamComponentScope.UNSPECIFIED) {
            return;
        }
        SeamBijectionUndefinedContextVariableInspection.checkContextVariableExisted(holder, outjection, module);
    }

    private static void checkContextVariableExisted(ProblemsHolder holder, SeamJamBijection bijection, Module module) {
        String variableName = bijection.getName();
        if (variableName != null && !SeamCommonUtils.isElText(variableName) && !SeamBijectionUndefinedContextVariableInspection.isContextVariableExisted(variableName, module)) {
            holder.registerProblem((PsiElement)bijection.getIdentifyingAnnotation(), SeamInspectionBundle.message("bijection.undefined.context.variable", variableName), new LocalQuickFix[0]);
        }
    }

    private static boolean isContextVariableExisted(@NotNull String variableName, Module module) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection", "isContextVariableExisted"));
        }
        return SeamCommonUtils.getContextVariable(variableName, module) != null;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("bijection.undefined.context.variables.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamBijectionUndefinedContextVariableInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection", "getShortName"));
        }
        return "SeamBijectionUndefinedContextVariableInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

