/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.utils.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFactoryContextVariable
extends ContextVariable {
    private final SeamDomFactory myFactory;
    private final Set<ContextVariable> myVars;
    private final Module myModule;
    private static Key<Boolean> IS_PROCESSING_VAR_TYPE = new Key("IS_PROCESSING_VAR_TYPE");

    public DomFactoryContextVariable(SeamDomFactory factory, String factoryName, Set<ContextVariable> vars, Module module) {
        super(factory, factoryName, (PsiType)PsiType.VOID);
        this.myFactory = factory;
        this.myVars = vars;
        this.myModule = module;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType type = SeamCommonUtils.getFactoryType(this.myFactory, this.myVars);
        PsiType psiType = type != null ? type : SeamCommonUtils.getObjectClassType(this.myModule.getProject());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/utils/beans/DomFactoryContextVariable", "getType"));
        }
        return psiType;
    }

    @Nullable
    public PsiType getELExpressionType() {
        XmlAttributeValue context = this.myFactory.getValue().getXmlAttributeValue();
        if (context == null || DomFactoryContextVariable.isProcessing((PsiElement)context)) {
            return null;
        }
        String value = this.myFactory.getValue().getStringValue();
        if (value != null && SeamCommonUtils.isElText(value)) {
            Ref injectionType = new Ref();
            DomFactoryContextVariable.setProcessing((PsiElement)context, true);
            InjectedLanguageUtil.enumerate((PsiElement)context, (injectedPsi, places) -> {
                ELExpression expression;
                PsiElement at = injectedPsi.findElementAt(injectedPsi.getTextLength() - 1);
                ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)at, ELExpressionHolder.class);
                if (holder != null && (expression = (ELExpression)PsiTreeUtil.getChildOfType((PsiElement)holder, ELExpression.class)) != null && !DomFactoryContextVariable.isSelfReference(expression, this.getName())) {
                    injectionType.set((Object)ELResolveUtil.resolveContextAsType((ELExpression)expression));
                }
            });
            DomFactoryContextVariable.setProcessing((PsiElement)context, false);
            return (PsiType)injectionType.get();
        }
        return null;
    }

    private static void setProcessing(@NotNull PsiElement context, boolean b) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/seam/utils/beans/DomFactoryContextVariable", "setProcessing"));
        }
        context.putUserData(IS_PROCESSING_VAR_TYPE, (Object)b);
    }

    private static boolean isProcessing(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/seam/utils/beans/DomFactoryContextVariable", "isProcessing"));
        }
        Boolean isProcessing = (Boolean)context.getUserData(IS_PROCESSING_VAR_TYPE);
        return isProcessing != null && isProcessing != false;
    }

    private static boolean isSelfReference(ELExpression expression, String myName) {
        if (expression == null) {
            return false;
        }
        if (expression.getText().equals(myName)) {
            return true;
        }
        PsiElement firstChild = expression.getFirstChild();
        ELVariable var = null;
        if (firstChild instanceof ELVariable) {
            var = (ELVariable)firstChild;
        }
        if (firstChild instanceof ELSelectExpression) {
            var = ((ELSelectExpression)firstChild).getField();
        }
        return var != null && var.getText().equals(myName);
    }
}

