/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopParameterReferenceTarget;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointcutContext {
    private final Map<String, AopReferenceTarget> myMap = new THashMap();

    public PointcutContext() {
    }

    public PointcutContext(@Nullable PsiPointcutExpression expression) {
        this(expression == null ? null : AopPointcutUtil.getHolder(expression).getAopModel().getPointcutMethod());
    }

    public PointcutContext(@Nullable PsiMethod method) {
        if (method != null) {
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                String paramName = parameter.getName();
                if (paramName == null) continue;
                this.addParameter(paramName, new AopParameterReferenceTarget(parameter));
            }
        }
    }

    private AopReferenceTarget getParameter(String paramName) {
        return this.myMap.get(paramName);
    }

    public void addParameter(@NotNull String paramName, AopReferenceTarget holder) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/intellij/aop/psi/PointcutContext", "addParameter"));
        }
        this.myMap.put(paramName, holder);
    }

    @NotNull
    public AopReferenceTarget resolve(@NotNull AopReferenceHolder pattern) {
        AopReferenceTarget target;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/aop/psi/PointcutContext", "resolve"));
        }
        AopTypeExpression typeExpression = pattern.getTypeExpression();
        if (typeExpression instanceof AopReferenceExpression && (target = this.getParameter(pattern.getText())) != null) {
            AopReferenceTarget aopReferenceTarget = target;
            if (aopReferenceTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PointcutContext", "resolve"));
            }
            return aopReferenceTarget;
        }
        AopReferenceHolder aopReferenceHolder = pattern;
        if (aopReferenceHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PointcutContext", "resolve"));
        }
        return aopReferenceHolder;
    }
}

