/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiAtPointcutDesignator;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAtArgsExpression
extends AopElementBase
implements PsiPointcutExpression,
PsiAtPointcutDesignator {
    public PsiAtArgsExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/PsiAtArgsExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "PsiAtArgsExpression";
    }

    @Nullable
    public AopParameterList getParameterList() {
        return (AopParameterList)((Object)this.findChildByClass(AopParameterList.class));
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        if (!(member instanceof PsiMethod)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiAtArgsExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        AopParameterList list = this.getParameterList();
        if (list == null) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiAtArgsExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = list.matches(context, ((PsiMethod)member).getParameterList(), new AopParameterList.TypeArgumentMatcher(){

            @Override
            public PointcutMatchDegree matches(PsiParameter psiParameter, AopReferenceTarget holder) {
                PsiType actualType = psiParameter.getType();
                return actualType instanceof PsiClassType ? PsiAtArgsExpression.canHaveAnnotation(((PsiClassType)actualType).resolve(), holder, PointcutMatchDegree.TRUE, PointcutMatchDegree.MAYBE) : PointcutMatchDegree.FALSE;
            }
        });
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiAtArgsExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        List<AopPsiTypePattern> list = Arrays.asList(AopPsiTypePattern.TRUE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiAtArgsExpression", "getPatterns"));
        }
        return list;
    }

    public static PointcutMatchDegree canHaveAnnotation(@Nullable PsiClass psiClass, @Nullable AopReferenceHolder holder, PointcutContext context, PointcutMatchDegree maybeTrue, PointcutMatchDegree maybeFalse) {
        if (holder == null) {
            return PointcutMatchDegree.FALSE;
        }
        return PsiAtArgsExpression.canHaveAnnotation(psiClass, context.resolve(holder), maybeTrue, maybeFalse);
    }

    public static PointcutMatchDegree canHaveAnnotation(@Nullable PsiClass psiClass, @NotNull AopReferenceTarget holder, PointcutMatchDegree maybeTrue, PointcutMatchDegree maybeFalse) {
        boolean hasAnno;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/aop/psi/PsiAtArgsExpression", "canHaveAnnotation"));
        }
        if (psiClass == null) {
            return PointcutMatchDegree.FALSE;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return PointcutMatchDegree.FALSE;
        }
        String annoName = holder.getQualifiedName();
        PsiClass annoClass = holder.findClass();
        if (annoClass == null || !annoClass.isAnnotationType()) {
            return PointcutMatchDegree.FALSE;
        }
        PsiModifierList annoModifierList = annoClass.getModifierList();
        boolean isInheritedAnno = annoModifierList != null && annoModifierList.findAnnotation("java.lang.annotation.Inherited") != null;
        boolean isFinal = modifierList.hasModifierProperty("final");
        boolean bl = hasAnno = modifierList.findAnnotation(annoName) != null;
        if (hasAnno) {
            return isFinal || isInheritedAnno ? PointcutMatchDegree.TRUE : maybeTrue;
        }
        if (isFinal) {
            return PointcutMatchDegree.FALSE;
        }
        if (!isInheritedAnno) {
            return maybeFalse;
        }
        if (psiClass.isInterface()) {
            return maybeFalse;
        }
        THashSet visited = new THashSet();
        visited.add(psiClass);
        while (!visited.contains(psiClass = psiClass.getSuperClass())) {
            visited.add(psiClass);
            if (psiClass == null) break;
            modifierList = psiClass.getModifierList();
            if (modifierList == null || modifierList.findAnnotation(annoName) == null) continue;
            return PointcutMatchDegree.TRUE;
        }
        return maybeFalse;
    }
}

