/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.SpringDataParserUtil;
import com.intellij.spring.data.commons.util.parser.domain.OrderBySource;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.spring.data.utils.SpringDataBundle;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataMethodInconsistencyInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (!SpringDataUtil.hasQueryAnnotation(psiMethod)) {
            SpringDataMethodInconsistencyInspection.checkMethodName(holder, psiMethod, module, typePair);
        }
    }

    private static void checkMethodName(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkMethodName"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkMethodName"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkMethodName"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkMethodName"));
        }
        String methodName = psiMethod.getName();
        PsiClass domainClass = (PsiClass)typePair.getFirst();
        PartTree partTree = new PartTree(methodName, domainClass);
        SpringDataMethodInconsistencyInspection.checkParts(holder, psiMethod, partTree);
        SpringDataMethodInconsistencyInspection.checkOrderBy(holder, psiMethod, domainClass, partTree);
    }

    private static void checkParts(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull PartTree partTree) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkParts"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkParts"));
        }
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkParts"));
        }
        List<Part> parts = partTree.getParts();
        if (parts.size() == 1 && StringUtil.isEmptyOrSpaces((String)parts.get(0).getSource())) {
            return;
        }
        for (Part part : parts) {
            for (PropertyPath property : part.getProperty()) {
                PsiIdentifier psiIdentifier;
                PsiType type = property.getType();
                if (type != null || (psiIdentifier = psiMethod.getNameIdentifier()) == null) continue;
                String propertyName = property.getSegment();
                if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                    SpringDataMethodInconsistencyInspection.addEmptyPropertyProblem(holder, psiMethod.getName(), partTree, part, psiIdentifier);
                    continue;
                }
                TextRange range = SpringDataMethodInconsistencyInspection.getTextRange(partTree, property);
                if (range == null) continue;
                holder.registerProblem((PsiElement)psiIdentifier, range, SpringDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkOrderBy(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, PsiClass domainClass, PartTree partTree) {
        PsiIdentifier identifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkOrderBy"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "checkOrderBy"));
        }
        OrderBySource source = partTree.getOrderBySource();
        if (source != null && (identifier = psiMethod.getNameIdentifier()) != null) {
            for (Map.Entry<Sort.Order, TextRange> entry : SpringDataParserUtil.getSortTextRanges(partTree).entrySet()) {
                Sort.Order order = entry.getKey();
                for (PropertyPath property : order.getPropertyPath()) {
                    PsiType type = property.getType();
                    if (type != null) continue;
                    String propertyName = property.getSegment();
                    if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                        String msg = SpringDataMethodInconsistencyInspection.getEmptyPropertyMessage(psiMethod.getName(), entry.getValue());
                        holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
                        continue;
                    }
                    TextRange range = SpringDataMethodInconsistencyInspection.getOrderByRange(partTree, property);
                    if (range == null) continue;
                    holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), range, SpringDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static void addEmptyPropertyProblem(@NotNull ProblemsHolder holder, String methodName, PartTree partTree, Part part, PsiIdentifier psiIdentifier) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "addEmptyPropertyProblem"));
        }
        if (methodName.equals(partTree.getSubject().getExpression())) {
            return;
        }
        Map<Part, TextRange> textRanges = SpringDataParserUtil.getPartTextRanges(partTree);
        TextRange range = textRanges.get(part);
        if (range != null) {
            if (range.getStartOffset() == range.getEndOffset()) {
                String msg = SpringDataMethodInconsistencyInspection.getEmptyPropertyMessage(methodName, range);
                holder.registerProblem((PsiElement)psiIdentifier, SpringDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
            } else {
                holder.registerProblem((PsiElement)psiIdentifier, range, SpringDataBundle.message("empty.property", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    private static String getEmptyPropertyMessage(String methodName, TextRange range) {
        String string = methodName.substring(0, range.getStartOffset()) + "<EMPTY_PROPERTY>" + methodName.substring(range.getEndOffset());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getEmptyPropertyMessage"));
        }
        return string;
    }

    @Nullable
    private static TextRange getTextRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getTextRange"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getTextRange"));
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Part, TextRange> textRanges = SpringDataParserUtil.getPartTextRanges(partTree);
        for (Map.Entry<Part, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getProperty()) {
                int startOffset;
                if (!path.equals(property) || (startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset())) < 0) continue;
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getOrderByRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partTree", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getOrderByRange"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getOrderByRange"));
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Sort.Order, TextRange> textRanges = SpringDataParserUtil.getSortTextRanges(partTree);
        for (Map.Entry<Sort.Order, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getPropertyPath()) {
                if (!path.equals(property)) continue;
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset());
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataMethodInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/inspections/SpringDataMethodInconsistencyInspection", "getShortName"));
        }
        return "SpringDataMethodInconsistencyInspection";
    }
}

