/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.parser.domain;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Sort
implements Iterable<Order>,
Serializable {
    private static final long serialVersionUID = 5737186511678863905L;
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private final List<Order> orders;

    public Sort(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public Sort(@NotNull List<Order> orders) {
        if (orders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orders", "com/intellij/spring/data/commons/util/parser/domain/Sort", "<init>"));
        }
        this.orders = orders;
    }

    public Sort(String ... properties) {
        this(DEFAULT_DIRECTION, properties);
    }

    public Sort(Direction direction, String ... properties) {
        this(direction, properties == null ? new ArrayList() : Arrays.asList(properties));
    }

    public Sort(Direction direction, List<String> properties) {
        this.orders = new ArrayList<Order>(properties.size());
        for (String property : properties) {
            this.orders.add(new Order(direction, property, property));
        }
    }

    public Sort and(Sort sort) {
        if (sort == null) {
            return this;
        }
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return new Sort(these);
    }

    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        return this.orders.equals(that.orders);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    public String toString() {
        return StringUtil.join(this.orders, (String)",");
    }

    public static class Order
    implements Serializable {
        private static final long serialVersionUID = 1522511010900108987L;
        private static final boolean DEFAULT_IGNORE_CASE = false;
        private final Direction direction;
        private final String property;
        private final boolean ignoreCase;
        private final NullHandling nullHandling;
        private PropertyPath myPath;
        private String myPropertySource;
        private String mySortExpression;

        public Order(Direction direction, String property, String sortExpression) {
            this(direction, property, false, null, sortExpression);
        }

        public Order(Direction direction, String property, NullHandling nullHandlingHint) {
            this(direction, property, false, nullHandlingHint, property);
        }

        public Order(String property) {
            this(DEFAULT_DIRECTION, property, property);
        }

        private Order(Direction direction, @NotNull String property, boolean ignoreCase, NullHandling nullHandling, String sortExpression) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/data/commons/util/parser/domain/Sort$Order", "<init>"));
            }
            if (StringUtil.isEmptyOrSpaces((String)property)) {
                // empty if block
            }
            this.mySortExpression = sortExpression;
            this.direction = direction == null ? DEFAULT_DIRECTION : direction;
            this.property = property;
            this.ignoreCase = ignoreCase;
            this.nullHandling = nullHandling == null ? NullHandling.NATIVE : nullHandling;
        }

        public Order(Direction direction, PropertyPath path, String propertySource, String sortExpression) {
            this(direction, path.toDotPath(), sortExpression);
            this.myPath = path;
            this.myPropertySource = propertySource;
        }

        public String getSortExpression() {
            return this.mySortExpression;
        }

        public PropertyPath getPropertyPath() {
            return this.myPath;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public String getPropertySourceExpression() {
            return this.myPropertySource;
        }

        public boolean isAscending() {
            return this.direction.equals((Object)Direction.ASC);
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public Order with(Direction order) {
            return new Order(order, this.property, this.nullHandling);
        }

        public Sort withProperties(String ... properties) {
            return new Sort(this.direction, properties);
        }

        public Order ignoreCase() {
            return new Order(this.direction, this.property, true, this.nullHandling, this.property);
        }

        public Order with(NullHandling nullHandling) {
            return new Order(this.direction, this.property, this.ignoreCase, nullHandling, this.property);
        }

        public Order nullsFirst() {
            return this.with(NullHandling.NULLS_FIRST);
        }

        public Order nullsLast() {
            return this.with(NullHandling.NULLS_LAST);
        }

        public Order nullsNative() {
            return this.with(NullHandling.NATIVE);
        }

        public NullHandling getNullHandling() {
            return this.nullHandling;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.direction.hashCode();
            result = 31 * result + this.property.hashCode();
            result = 31 * result + (this.ignoreCase ? 1 : 0);
            result = 31 * result + this.nullHandling.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Order)) {
                return false;
            }
            Order that = (Order)obj;
            return this.direction.equals((Object)that.direction) && this.property.equals(that.property) && this.ignoreCase == that.ignoreCase && this.nullHandling.equals((Object)that.nullHandling);
        }

        public String toString() {
            String result = String.format("%s: %s", new Object[]{StringUtil.isEmptyOrSpaces((String)this.property) ? "<empty>" : this.property, this.direction});
            if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
                result = result + ", " + (Object)((Object)this.nullHandling);
            }
            if (this.ignoreCase) {
                result = result + ", ignoring case";
            }
            return result;
        }
    }

    public static enum NullHandling {
        NATIVE,
        NULLS_FIRST,
        NULLS_LAST;

    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction fromString(String value) {
            return Direction.valueOf(value.toUpperCase(Locale.US));
        }

        public static Direction fromStringOrNull(String value) {
            return Direction.fromString(value);
        }
    }
}

