/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlStackTraceFilterProvider
implements ConsoleFilterProvider {
    @NonNls
    static final Pattern PATTERN = Pattern.compile(".*(line ([0-9]+), column ([0-9]+)(,)? in (template )?([^ ]*[^\\.\\]]))((\\.\n)|(\\]\n)|(\n)|( .*\n))");

    @NotNull
    public Filter[] getDefaultFilters(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/FtlStackTraceFilterProvider", "getDefaultFilters"));
        }
        final ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Filter[] filterArray = new Filter[]{new Filter(){

            public Filter.Result applyFilter(String line, int entireLength) {
                if (!line.contains("line (") || !line.contains(", column (")) {
                    return null;
                }
                Matcher matcher = PATTERN.matcher(line);
                if (!matcher.matches()) {
                    return null;
                }
                try {
                    int l = Integer.parseInt(matcher.group(2));
                    int c = Integer.parseInt(matcher.group(3));
                    VirtualFile vFile = FtlStackTraceFilterProvider.findOffendingFile(rootManager, FtlStackTraceFilterProvider.getFileName(matcher), project);
                    if (vFile == null) {
                        return null;
                    }
                    int start = entireLength - line.length();
                    return new Filter.Result(matcher.start(1) + start, matcher.end(1) + start, (HyperlinkInfo)new OpenFileHyperlinkInfo(project, vFile, l - 1, c - 1));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlStackTraceFilterProvider", "getDefaultFilters"));
        }
        return filterArray;
    }

    public static String getFileName(Matcher matcher) {
        return matcher.group(6);
    }

    @Nullable
    private static VirtualFile findOffendingFile(ProjectRootManager rootManager, String fileName, Project project) {
        VirtualFile file;
        GlobalSearchScope filter = GlobalSearchScope.projectScope((Project)project);
        THashSet result = new THashSet();
        for (FtlFile file2 : FtlFile.getImplicitlyIncludedFiles(project, filter)) {
            FtlFileReferenceDirective.collectFtlRoots((PsiFile)file2, (Collection<PsiFileSystemItem>)result);
        }
        for (PsiFileSystemItem item : result) {
            VirtualFile file3 = FtlStackTraceFilterProvider.getRelativeFile(item.getVirtualFile(), fileName);
            if (file3 == null) continue;
            return file3;
        }
        Collection usualFiles = FileBasedIndex.getInstance().getContainingFiles(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.USUAL_FILE, filter);
        for (VirtualFile file3 : usualFiles) {
            if (!fileName.equals(file3.getName())) continue;
            THashSet items = new THashSet();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file3);
            if (psiFile != null) {
                items.addAll(FtlFileReferenceDirective.getDefinedFtlRoots(PsiManager.getInstance((Project)project), psiFile));
            }
            if (!items.isEmpty()) continue;
            return file3;
        }
        for (VirtualFile root : rootManager.getContentSourceRoots()) {
            file = FtlStackTraceFilterProvider.getRelativeFile(root, fileName);
            if (file == null) continue;
            return file;
        }
        for (VirtualFile root : rootManager.getContentRoots()) {
            file = FtlStackTraceFilterProvider.getRelativeFile(root, fileName);
            if (file == null) continue;
            return file;
        }
        for (VirtualFile file4 : usualFiles) {
            if (!fileName.equals(file4.getName())) continue;
            return file4;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@Nullable VirtualFile root, String fileName) {
        if (root == null) {
            return null;
        }
        VirtualFile file = root.findFileByRelativePath(fileName);
        if (file != null) {
            return file;
        }
        return null;
    }
}

