/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.psi.AbstractFtlExpression;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBinaryExpression
extends AbstractFtlExpression {
    public FtlBinaryExpression(ASTNode node) {
        super(node);
    }

    @Nullable
    public FtlExpression getLeftOperand() {
        return this.getExpression(0);
    }

    @Nullable
    public FtlExpression getRightOperand() {
        return this.getExpression(1);
    }

    @NotNull
    public FtlTokenType getOperationSign() {
        ASTNode node = this.getNode().findChildByType(FtlElementTypes.OPERATIONS);
        assert (node != null) : this.getText();
        FtlTokenType ftlTokenType = (FtlTokenType)node.getElementType();
        if (ftlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlBinaryExpression", "getOperationSign"));
        }
        return ftlTokenType;
    }

    @Override
    public FtlType getType() {
        FtlExpression lOperand = this.getLeftOperand();
        FtlExpression rOperand = this.getRightOperand();
        if (lOperand == null || rOperand == null) {
            return null;
        }
        FtlTokenType i = this.getOperationSign();
        if (i == FtlElementTypes.PLUS) {
            FtlType rType = rOperand.getType();
            if (FtlPsiUtil.asInstanceOf(rType, FtlCollectionType.class) != null) {
                return rType;
            }
            PsiType type2 = FtlBinaryExpression.getPsiType(rType);
            if (type2 == null) {
                return null;
            }
            if (type2.equalsToText("java.lang.String") || FtlBuiltInDescriptor.HashBuiltIn.isHash(rType) || FtlListDirective.isCollectionType(rType)) {
                return rType;
            }
            PsiType type1 = FtlBinaryExpression.getPsiType(lOperand.getType());
            if (type1 == null) {
                return null;
            }
            if (type1.equalsToText("java.lang.String")) {
                return lOperand.getType();
            }
            return FtlPsiType.wrap(TypeConversionUtil.unboxAndBalanceTypes((PsiType)type1, (PsiType)type2));
        }
        if (i == FtlElementTypes.MINUS || i == FtlElementTypes.ASTERISK || i == FtlElementTypes.PERCENT) {
            PsiType type2 = FtlBinaryExpression.getPsiType(rOperand.getType());
            PsiType type1 = FtlBinaryExpression.getPsiType(lOperand.getType());
            if (type1 == null && type2 == null) {
                return null;
            }
            return FtlPsiType.wrap(TypeConversionUtil.unboxAndBalanceTypes((PsiType)type1, (PsiType)type2));
        }
        if (i == FtlElementTypes.DIVIDE) {
            PsiType type2 = FtlBinaryExpression.getPsiType(rOperand.getType());
            PsiType type1 = FtlBinaryExpression.getPsiType(lOperand.getType());
            if (type1 == null && type2 == null) {
                return null;
            }
            return new FtlPsiType((PsiType)PsiType.DOUBLE);
        }
        if (i == FtlElementTypes.EQ || i == FtlElementTypes.NEQ || i == FtlElementTypes.LT || i == FtlElementTypes.GT || i == FtlElementTypes.LTE || i == FtlElementTypes.GTE || i == FtlElementTypes.OR || i == FtlElementTypes.AND) {
            return new FtlPsiType((PsiType)PsiType.BOOLEAN);
        }
        throw new AssertionError((Object)i);
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Nullable
    private static PsiType getPsiType(FtlType type) {
        return type instanceof FtlPsiType ? ((FtlPsiType)type).getPsiType() : null;
    }
}

