/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlDataModelVariable;
import com.intellij.freemarker.psi.variables.FtlHashType;
import com.intellij.freemarker.psi.variables.FtlHashVariable;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlCustomVariable
extends FakePsiElement
implements FtlHashVariable,
FtlDataModelVariable {
    private final String myName;
    private final PsiElement myParent;
    private final Map<String, FtlVariable> mySubVariables;

    public FtlCustomVariable(@NotNull @NonNls String name, @NotNull PsiElement parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/variables/FtlCustomVariable", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/freemarker/psi/variables/FtlCustomVariable", "<init>"));
        }
        this.mySubVariables = new THashMap();
        this.myName = name;
        this.myParent = parent;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlCustomVariable", "getName"));
        }
        return string;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public <T extends FtlVariable> T addSubVariable(T variable) {
        this.mySubVariables.put(variable.getName(), variable);
        return variable;
    }

    @Override
    public FtlType getType() {
        return new FtlHashType(this);
    }

    public boolean processSubVariables(@NotNull PsiScopeProcessor processor, ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/variables/FtlCustomVariable", "processSubVariables"));
        }
        for (FtlVariable variable : this.mySubVariables.values()) {
            if (processor.execute((PsiElement)variable, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlCustomVariable", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public Collection<? extends FtlVariable> getSubVariables() {
        return this.mySubVariables.values();
    }
}

