/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.ElContextProviderEx;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringElContextProvider
extends ElContextProviderEx {
    protected final PsiElement myHost;

    public SpringElContextProvider(PsiElement host) {
        this.myHost = host;
    }

    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        PsiElement psiElement = this.myHost instanceof PsiFile ? ((PsiFile)this.myHost).getOriginalFile() : this.myHost;
        return nameHint == null ? this.getAllVariables(psiElement).iterator() : this.getVariable(nameHint, psiElement);
    }

    @NotNull
    public Collection<PsiMethod> getRootMethods(@Nullable String nameHint) {
        PsiElement psiElement = this.myHost instanceof PsiFile ? ((PsiFile)this.myHost).getOriginalFile() : this.myHost;
        Collection<PsiMethod> collection = this.getAllRootMethods(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getRootMethods"));
        }
        return collection;
    }

    @NotNull
    protected Iterator<? extends PsiVariable> getVariable(@NotNull String nameHint, @NotNull PsiElement psiElement) {
        if (nameHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameHint", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getVariable"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getVariable"));
        }
        PsiVariable contextVariable = this.findVariable(nameHint, psiElement);
        Iterator iterator = ContainerUtil.createMaybeSingletonSet((Object)contextVariable).iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getVariable"));
        }
        return iterator;
    }

    @Nullable
    protected PsiVariable findVariable(@NotNull String nameHint, PsiElement psiElement) {
        if (nameHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameHint", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "findVariable"));
        }
        for (SpringElContextsExtension extension : SpringElContextsExtension.getProviders()) {
            PsiVariable contextVariable = extension.findContextVariable(psiElement, nameHint);
            if (contextVariable == null) continue;
            return contextVariable;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiVariable> getAllVariables(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getAllVariables"));
        }
        List vars = ContainerUtil.newSmartList();
        for (SpringElContextsExtension elContextsExtension : SpringElContextsExtension.getProviders()) {
            vars.addAll(elContextsExtension.getContextVariables(psiElement));
        }
        List list = vars;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getAllVariables"));
        }
        return list;
    }

    @NotNull
    protected Collection<PsiMethod> getAllRootMethods(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getAllRootMethods"));
        }
        List vars = ContainerUtil.newSmartList();
        for (SpringElContextsExtension elContextsExtension : SpringElContextsExtension.getProviders()) {
            vars.addAll(elContextsExtension.getRootMethods(psiElement));
        }
        List list = vars;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/contextProviders/SpringElContextProvider", "getAllRootMethods"));
        }
        return list;
    }

    public boolean acceptsGetMethodForLastReference(PsiMethod getter) {
        return true;
    }

    public boolean acceptsSetMethodForLastReference(PsiMethod setter) {
        return true;
    }

    public boolean acceptsNonPropertyMethodForLastReference(PsiMethod method) {
        return true;
    }

    public boolean shouldProcessFields() {
        return true;
    }
}

