/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ObjectKind
implements Comparable<ObjectKind> {
    public static final ObjectKind NONE = new ObjectKind("NONE", 0);
    public static final ObjectKind ROOT = new ObjectKind("ROOT", 1);
    public static final ObjectKind DATABASE = new ObjectKind("DATABASE", 2);
    public static final ObjectKind SCHEMA = new ObjectKind("SCHEMA", 3);
    public static final ObjectKind SEQUENCE = new ObjectKind("SEQUENCE", 4);
    public static final ObjectKind CLUSTER = new ObjectKind("CLUSTER", 5);
    public static final ObjectKind OBJECT_TYPE = new ObjectKind("OBJECT TYPE", 6);
    public static final ObjectKind COLLECTION_TYPE = new ObjectKind("COLLECTION TYPE", 7);
    public static final ObjectKind TABLE = new ObjectKind("TABLE", 8);
    public static final ObjectKind MAT_VIEW = new ObjectKind("MATERIALIZED VIEW", 9);
    public static final ObjectKind VIEW = new ObjectKind("VIEW", 10);
    public static final ObjectKind PACKAGE = new ObjectKind("PACKAGE", 11);
    public static final ObjectKind BODY = new ObjectKind("BODY", 12);
    public static final ObjectKind TABLE_TYPE = new ObjectKind("TABLE TYPE", 13);
    public static final ObjectKind ALIAS_TYPE = new ObjectKind("ALIAS TYPE", 14);
    public static final ObjectKind ROUTINE = new ObjectKind("ROUTINE", 15);
    public static final ObjectKind OPERATOR = new ObjectKind("OPERATOR", 16);
    public static final ObjectKind OBJECT_ATTRIBUTE = new ObjectKind("OBJECT ATTRIBUTE", 17);
    public static final ObjectKind COLUMN = new ObjectKind("COLUMN", 18);
    public static final ObjectKind INDEX = new ObjectKind("INDEX", 19);
    public static final ObjectKind KEY = new ObjectKind("KEY", 20);
    public static final ObjectKind FOREIGN_KEY = new ObjectKind("FOREIGN KEY", 21);
    public static final ObjectKind CHECK = new ObjectKind("CHECK", 22);
    public static final ObjectKind RULE = new ObjectKind("RULE", 23);
    public static final ObjectKind TRIGGER = new ObjectKind("TRIGGER", 24);
    public static final ObjectKind ARGUMENT = new ObjectKind("ARGUMENT", 25);
    public static final ObjectKind VARIABLE = new ObjectKind("VARIABLE", 26);
    public static final ObjectKind COMMENT = new ObjectKind("COMMENT", 27);
    public static final ObjectKind SYNONYM = new ObjectKind("SYNONYM", 28);
    public static final ObjectKind DB_LINK = new ObjectKind("DBLINK", 29);
    public static final ObjectKind VIRTUAL_TABLE = new ObjectKind("VIRTUAL TABLE", 30);
    public static final ObjectKind COLLATION = new ObjectKind("COLLATION", 31);
    public static final ObjectKind UNKNOWN_OBJECT = new ObjectKind("UNKNOWN OBJECT", Integer.MAX_VALUE);
    private final String myName;
    private final int myOrderNum;
    private static final AtomicInteger ourOrderNumCounter = new AtomicInteger(100);
    public static final Map<String, ObjectKind> ourKinds;

    public ObjectKind(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/ObjectKind", "<init>"));
        }
        this(name, ourOrderNumCounter.incrementAndGet());
    }

    private ObjectKind(@NotNull String name, int orderNum) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/ObjectKind", "<init>"));
        }
        assert (name.length() > 0);
        assert (orderNum >= 0);
        this.myName = name;
        this.myOrderNum = orderNum;
    }

    public String name() {
        return this.myName;
    }

    public String code() {
        return this.myName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
    }

    public int getOrder() {
        return this.myOrderNum;
    }

    public String toString() {
        return this.code();
    }

    @Override
    public int compareTo(@NotNull ObjectKind that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/database/model/ObjectKind", "compareTo"));
        }
        if (this == that) {
            return 0;
        }
        if (this.myOrderNum < that.myOrderNum) {
            return -1;
        }
        if (this.myOrderNum > that.myOrderNum) {
            return 1;
        }
        throw new IllegalStateException(String.format("Uncomparable object kinds: %s and %s", this.code(), that.code()));
    }

    static {
        ObjectKind[] theKinds = new ObjectKind[]{NONE, ROOT, DATABASE, SCHEMA, SEQUENCE, CLUSTER, TABLE, MAT_VIEW, VIEW, OBJECT_TYPE, COLLECTION_TYPE, PACKAGE, BODY, TABLE_TYPE, ALIAS_TYPE, ROUTINE, OPERATOR, OBJECT_ATTRIBUTE, COLUMN, INDEX, KEY, FOREIGN_KEY, CHECK, RULE, TRIGGER, ARGUMENT, VARIABLE, COMMENT, SYNONYM, DB_LINK, VIRTUAL_TABLE, COLLATION, UNKNOWN_OBJECT};
        LinkedHashMap m = new LinkedHashMap(40);
        for (ObjectKind kind : theKinds) {
            m.put((Object)kind.code(), (Object)kind);
        }
        ourKinds = Collections.unmodifiableMap(m);
    }
}

