/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findDecompiledDeclaration", "builtInsSearchScope", "findInScope", "isLocal", "", "descriptor", "idea-core"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor, @Nullable GlobalSearchScope builtInsSearchScope) {
        BinaryModuleInfo binaryInfo;
        BinaryModuleInfo binaryModuleInfo;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)referencedDescriptor, (String)"referencedDescriptor");
        if (ErrorUtils.isError(referencedDescriptor)) {
            return null;
        }
        if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
            return null;
        }
        if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
            return null;
        }
        ModuleInfo moduleInfo = DescriptorUtilsKt.getModule(referencedDescriptor).getCapability(ModuleInfo.Companion.getCapability());
        if (!(moduleInfo instanceof BinaryModuleInfo)) {
            moduleInfo = null;
        }
        if ((binaryModuleInfo = (binaryInfo = (BinaryModuleInfo)moduleInfo)) != null && (binaryModuleInfo = binaryModuleInfo.binariesScope()) != null) {
            BinaryModuleInfo binaryModuleInfo2;
            BinaryModuleInfo it = binaryModuleInfo2 = binaryModuleInfo;
            return FindDecompiledDeclarationKt.findInScope(referencedDescriptor, (GlobalSearchScope)it);
        }
        if (KotlinBuiltIns.isBuiltIn(referencedDescriptor)) {
            Object object;
            GlobalSearchScope globalSearchScope;
            GlobalSearchScope it;
            Object object2 = builtInsSearchScope;
            if (object2 == null || (object2 = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, it = (globalSearchScope = object2))) == null) {
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"GlobalSearchScope.allScope(project)");
                object2 = object = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope2);
            }
            if (object2 == null) {
                object = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, (GlobalSearchScope)new EverythingGlobalScope(project));
            }
            return object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration findInScope(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2) {
        void $receiver$iv;
        Project project;
        Project project2 = scope2.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(referencedDescriptor, KotlinSourceFilterScope.Companion.libraryClassFiles(scope2, project3), project);
        Collection destination$iv = new LinkedHashSet();
        void $receiver$iv$iv = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDecompiledFile ktDecompiledFile;
            KtDeclaration it;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            KtDeclaration ktDeclaration = it = (KtDeclaration)element$iv;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if (!(object instanceof KtDecompiledFile)) {
                object = null;
            }
            if ((KtDecompiledFile)object == null) continue;
            KtDecompiledFile it$iv = ktDecompiledFile;
            destination$iv.add(it$iv);
        }
        LinkedHashSet decompiledFiles = (LinkedHashSet)destination$iv;
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), (Function1)((Function1)new Function1<KtDecompiledFile, KtDeclaration>(referencedDescriptor){
            final /* synthetic */ DeclarationDescriptor $referencedDescriptor;

            @Nullable
            public final KtDeclaration invoke(@NotNull KtDecompiledFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                return ByDescriptorIndexer.INSTANCE.getDeclarationForDescriptor$idea_core(this.$referencedDescriptor, file2);
            }
            {
                this.$referencedDescriptor = declarationDescriptor;
                super(1);
            }
        })));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        boolean bl;
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            bl = FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        } else {
            bl = DescriptorUtils.isLocal(descriptor2);
        }
        return bl;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2, Project project) {
        Collection<KtDeclaration> collection;
        Substitutable<CallableDescriptor> substitutable;
        CallableMemberDescriptor callableMemberDescriptor;
        ClassDescriptor containingClass = DescriptorUtils.getParentOfType(referencedDescriptor, ClassDescriptor.class, false);
        if (containingClass != null) {
            Collection<KtDeclaration> collection2 = KotlinFullClassNameIndex.getInstance().get(DescriptorUtilsKt.getFqNameSafe(containingClass).asString(), project, scope2);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"KotlinFullClassNameIndex\u2026String(), project, scope)");
            return collection2;
        }
        DeclarationDescriptor declarationDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, PropertyDescriptor.class, false);
        if (declarationDescriptor == null) {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, TypeAliasConstructorDescriptor.class, false);
            declarationDescriptor = callableMemberDescriptor = (DeclarationDescriptor)(typeAliasConstructorDescriptor != null ? typeAliasConstructorDescriptor.getTypeAliasDescriptor() : null);
        }
        if (declarationDescriptor == null) {
            callableMemberDescriptor = substitutable = DescriptorUtils.getParentOfType(referencedDescriptor, FunctionDescriptor.class, false);
        }
        if (callableMemberDescriptor == null) {
            substitutable = DescriptorUtils.getParentOfType(referencedDescriptor, TypeAliasDescriptor.class, false);
        }
        if (substitutable == null) {
            return CollectionsKt.emptyList();
        }
        PropertyDescriptor topLevelDeclaration = substitutable;
        if (!DescriptorUtils.isTopLevelDeclaration(topLevelDeclaration)) {
            return CollectionsKt.emptyList();
        }
        String fqName2 = DescriptorUtilsKt.getFqNameSafe(topLevelDeclaration).asString();
        PropertyDescriptor propertyDescriptor = topLevelDeclaration;
        if (propertyDescriptor instanceof FunctionDescriptor) {
            Collection<KtNamedFunction> collection3 = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(fqName2, project, scope2);
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"KotlinTopLevelFunctionFq\u2026t(fqName, project, scope)");
        } else if (propertyDescriptor instanceof PropertyDescriptor) {
            Collection<KtProperty> collection4 = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(fqName2, project, scope2);
            collection = collection4;
            Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"KotlinTopLevelPropertyFq\u2026t(fqName, project, scope)");
        } else if (propertyDescriptor instanceof TypeAliasDescriptor) {
            KotlinTopLevelTypeAliasFqNameIndex kotlinTopLevelTypeAliasFqNameIndex = KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance();
            String string = fqName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName");
            collection = kotlinTopLevelTypeAliasFqNameIndex.get(string, project, scope2);
        } else {
            String string = "Referenced non local declaration that is not inside top level function, property, class or typealias:\n " + referencedDescriptor;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return collection;
    }
}

