/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.EntryChunk;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessor;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.LiteralChunk;
import org.jetbrains.kotlin.idea.editor.NewLineChunk;
import org.jetbrains.kotlin.idea.editor.TemplateChunk;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J2\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "idea"})
public final class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed = false;
        String fileText = ((KtFile)file2).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        int n = 0;
        int n2 = startOffsets.length;
        while (n < n2) {
            int blockSelectionPadding;
            int elTp2;
            int n3;
            void i;
            if (i > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i], endOffsets[i]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                String string;
                TextRange inter;
                int n4;
                Object tpEntry;
                PsiElement element3 = file2.findElementAt(givenTextOffset);
                if (element3 == null) {
                    String string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileText, (String)"fileText");
                    n3 = fileRange.getEndOffset();
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(givenTextOffset, n3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    buffer.append(string4);
                    break;
                }
                ASTNode aSTNode = element3.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                IElementType elTp2 = aSTNode.getElementType();
                if (Intrinsics.areEqual((Object)elTp2, (Object)((Object)KtTokens.ESCAPE_SEQUENCE)) && fileRange.contains(FixersUtilKt.getRange(element3))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange$p(element3);
                    if (textRange != null) {
                        if (textRange.contains(fileRange)) {
                            PsiElement psiElement2 = element3.getParent();
                            if (psiElement2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                            }
                            tpEntry = (KtEscapeStringTemplateEntry)psiElement2;
                            changed = true;
                            buffer.append(((KtEscapeStringTemplateEntry)tpEntry).getUnescapedValue());
                            givenTextOffset = PsiUtilsKt.getEndOffset(element3);
                            continue;
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)elTp2, (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) || Intrinsics.areEqual((Object)elTp2, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START))) {
                    String string5;
                    TextRange inter2;
                    tpEntry = element3.getParent();
                    PsiElement psiElement3 = tpEntry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"tpEntry");
                    if (fileRange.intersection(FixersUtilKt.getRange(psiElement3)) == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileText, (String)"fileText");
                    TextRange textRange = inter2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"inter");
                    n4 = textRange.getStartOffset();
                    int n5 = inter2.getEndOffset();
                    String string6 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n4, n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    buffer.append(string7);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                if (fileRange.intersection(FixersUtilKt.getRange(element3)) == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fileText, (String)"fileText");
                TextRange textRange = inter;
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"inter");
                int n6 = textRange.getStartOffset();
                n4 = inter.getEndOffset();
                String string8 = string;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n6, n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                buffer.append(string9);
                givenTextOffset = inter.getEndOffset();
            }
            if ((elTp2 = 0) <= (n3 = (blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength()) - 1)) {
                while (true) {
                    void j;
                    buffer.append(' ');
                    if (j == n3) break;
                    ++j;
                }
            }
            ++i;
        }
        return changed ? buffer.toString() : null;
    }

    @NotNull
    public String preprocessOnPaste(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull String text2, @Nullable RawText rawText) {
        SelectionModel selectionModel;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        if (!(file2 instanceof KtFile)) {
            return text2;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        SelectionModel selectionModel2 = selectionModel = editor.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"selectionModel");
        KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file2, selectionModel2.getSelectionStart());
        if (ktStringTemplateExpression == null) {
            return text2;
        }
        KtStringTemplateExpression beginTp = ktStringTemplateExpression;
        KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file2, selectionModel.getSelectionEnd());
        if (ktStringTemplateExpression2 == null) {
            return text2;
        }
        KtStringTemplateExpression endTp = ktStringTemplateExpression2;
        if (KtPsiUtilKt.isSingleQuoted(beginTp) != KtPsiUtilKt.isSingleQuoted(endTp)) {
            return text2;
        }
        if (KtPsiUtilKt.isSingleQuoted(beginTp)) {
            String string;
            StringBuilder res2 = new StringBuilder();
            String lineBreak = "\\n\"+\n \"";
            boolean endsInLineBreak = false;
            Sequence $receiver$iv = new TemplateTokenSequence(text2);
            for (Object element$iv : $receiver$iv) {
                TemplateChunk it = (TemplateChunk)element$iv;
                TemplateChunk templateChunk = it;
                if (templateChunk instanceof LiteralChunk) {
                    StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)"$\"", (StringBuilder)res2);
                } else if (templateChunk instanceof EntryChunk) {
                    res2.append(((EntryChunk)it).getText());
                } else if (templateChunk instanceof NewLineChunk) {
                    res2.append(lineBreak);
                }
                endsInLineBreak = it instanceof NewLineChunk;
            }
            if (endsInLineBreak) {
                string = ((Object)StringsKt.removeSuffix((CharSequence)res2, (CharSequence)lineBreak)).toString() + "\\n";
            } else {
                String string2 = res2.toString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"res.toString()");
            }
            return string;
        }
        Regex tripleQuoteRe = new Regex("[\"]{3,}");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)new TemplateTokenSequence(text2), (Function1)((Function1)new Function1<TemplateChunk, String>(tripleQuoteRe){
            final /* synthetic */ Regex $tripleQuoteRe;

            @NotNull
            public final String invoke(@NotNull TemplateChunk chunk) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
                TemplateChunk templateChunk = chunk;
                if (templateChunk instanceof LiteralChunk) {
                    String string2;
                    String escapedDollar = string2 = StringsKt.replace$default((String)((LiteralChunk)chunk).getText(), (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
                    string = this.$tripleQuoteRe.replace((CharSequence)escapedDollar, (Function1)preprocessOnPaste.1.1.INSTANCE);
                } else if (templateChunk instanceof EntryChunk) {
                    string = ((EntryChunk)chunk).getText();
                } else if (templateChunk instanceof NewLineChunk) {
                    string = "\n";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }
            {
                this.$tripleQuoteRe = regex;
                super(1);
            }
        })), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

