/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a8\u0006\u000e"}, d2={"getDefaultLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "module", "Lcom/intellij/openapi/module/Module;", "explicitVersion", "", "getLibraryLanguageLevel", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "targetPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "getRuntimeLibraryVersion", "getRuntimeLibraryVersions", "", "idea-core"})
public final class KotlinVersionInfoProviderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<String> getRuntimeLibraryVersions(@NotNull Module module, @Nullable ModuleRootModel rootModel, @NotNull TargetPlatformKind<?> targetPlatform) {
        Collection collection;
        Object v1;
        block3: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull(targetPlatform, (String)"targetPlatform");
            Object[] objectArray = KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KotlinVersionInfoProvide\u2026              .extensions");
            Object $receiver$iv = objectArray;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                KotlinVersionInfoProvider kotlinVersionInfoProvider = (KotlinVersionInfoProvider)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Collection<String> collection3 = it.getLibraryVersions(module, targetPlatform, rootModel);
                collection2.add(collection3);
            }
            $receiver$iv = (List)destination$iv$iv;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                Collection it = (Collection)element$iv;
                Collection collection4 = it;
                if (!(!collection4.isEmpty())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((collection = (Collection)v1) == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @NotNull
    public static final LanguageVersion getLibraryLanguageLevel(@NotNull Module module, @Nullable ModuleRootModel rootModel, @Nullable TargetPlatformKind<?> targetPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        TargetPlatformKind<?> targetPlatformKind = targetPlatform;
        if (targetPlatformKind == null) {
            targetPlatformKind = TargetPlatformKind.Companion.getDEFAULT_PLATFORM();
        }
        Iterable iterable = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, targetPlatformKind);
        Comparator comparator = VersionComparatorUtil.COMPARATOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"VersionComparatorUtil.COMPARATOR");
        String minVersion = (String)CollectionsKt.minWith((Iterable)iterable, (Comparator)comparator);
        return KotlinVersionInfoProviderKt.getDefaultLanguageLevel(module, minVersion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LanguageVersion getDefaultLanguageLevel(@NotNull Module module, @Nullable String explicitVersion) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = explicitVersion;
        if (string == null) {
            void $receiver$iv$iv;
            Object[] objectArray = KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KotlinVersionInfoProvider.EP_NAME.extensions");
            Object[] $receiver$iv = objectArray;
            Object[] objectArray2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
                String string2;
                void element$iv$iv$iv = $receiver$iv$iv$iv[i];
                void element$iv$iv = element$iv$iv$iv;
                KotlinVersionInfoProvider it = (KotlinVersionInfoProvider)element$iv$iv;
                if (it.getCompilerVersion(module) == null) continue;
                String it$iv$iv = string2;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            Comparator comparator = VersionComparatorUtil.COMPARATOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"VersionComparatorUtil.COMPARATOR");
            string = (String)CollectionsKt.minWith((Iterable)iterable, (Comparator)comparator);
        }
        if (string == null) {
            return LanguageVersion.LATEST_STABLE;
        }
        String libVersion = string;
        return StringsKt.startsWith$default((String)libVersion, (String)"1.3", (boolean)false, (int)2, null) ? LanguageVersion.KOTLIN_1_3 : (StringsKt.startsWith$default((String)libVersion, (String)"1.2", (boolean)false, (int)2, null) ? LanguageVersion.KOTLIN_1_2 : (StringsKt.startsWith$default((String)libVersion, (String)"1.1", (boolean)false, (int)2, null) ? LanguageVersion.KOTLIN_1_1 : (StringsKt.startsWith$default((String)libVersion, (String)"1.0", (boolean)false, (int)2, null) ? LanguageVersion.KOTLIN_1_0 : LanguageVersion.LATEST_STABLE)));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LanguageVersion getDefaultLanguageLevel$default(Module module, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return KotlinVersionInfoProviderKt.getDefaultLanguageLevel(module, string);
    }

    @Nullable
    public static final String getRuntimeLibraryVersion(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        TargetPlatformKind<?> targetPlatform = KotlinFacetSettingsProvider.Companion.getInstance(project).getInitializedSettings(module).getTargetPlatformKind();
        TargetPlatformKind<?> targetPlatformKind = targetPlatform;
        if (targetPlatformKind == null) {
            targetPlatformKind = TargetPlatformKind.Companion.getDEFAULT_PLATFORM();
        }
        Collection<String> versions = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, null, targetPlatformKind);
        return (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)versions));
    }
}

