/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.util.jar.Attributes;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"detectLibraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "detectLibraryKindFromJarContents", "jarRoot", "getCommonRuntimeLibraryVersion", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "getLibraryJarVersion", "jarPattern", "Ljava/util/regex/Pattern;", "getLibraryPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "idea-core"})
public final class LibraryKindsKt {
    @NotNull
    public static final TargetPlatform getLibraryPlatform(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Library library3 = library2;
        if (!(library3 instanceof LibraryEx)) {
            library3 = null;
        }
        if ((LibraryEx)library3 == null) {
            return JvmPlatform.INSTANCE;
        }
        if (((LibraryEx)library2).isDisposed()) {
            return JvmPlatform.INSTANCE;
        }
        PersistentLibraryKind persistentLibraryKind = ((LibraryEx)library2).getKind();
        return Intrinsics.areEqual((Object)persistentLibraryKind, (Object)((Object)JSLibraryKind.INSTANCE)) ? (TargetPlatform)JsPlatform.INSTANCE : (Intrinsics.areEqual((Object)persistentLibraryKind, (Object)((Object)CommonLibraryKind.INSTANCE)) ? (TargetPlatform)TargetPlatform.Common.INSTANCE : (TargetPlatform)JvmPlatform.INSTANCE);
    }

    @Nullable
    public static final PersistentLibraryKind<?> detectLibraryKind(@NotNull VirtualFile[] roots) {
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])roots);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile jarFile = virtualFile2;
        if (jarFile.getFileSystem() instanceof JarFileSystem) {
            return LibraryKindsKt.detectLibraryKindFromJarContents(jarFile);
        }
        String string = jarFile.getExtension();
        return Intrinsics.areEqual((Object)string, (Object)"js") || Intrinsics.areEqual((Object)string, (Object)"kjsm") ? (PersistentLibraryKind)JSLibraryKind.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)MetadataPackageFragment.Companion.getMETADATA_FILE_EXTENSION()) ? (PersistentLibraryKind)CommonLibraryKind.INSTANCE : null);
    }

    /*
     * WARNING - void declaration
     */
    private static final PersistentLibraryKind<?> detectLibraryKindFromJarContents(VirtualFile jarRoot) {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        VfsUtil.visitChildrenRecursively((VirtualFile)jarRoot, (VirtualFileVisitor)new VirtualFileVisitor<PersistentLibraryKind<?>>((Ref.ObjectRef)result2, new VirtualFileVisitor.Option[0]){
            final /* synthetic */ Ref.ObjectRef $result;

            public boolean visitFile(@NotNull VirtualFile file2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                String string = file2.getExtension();
                if (Intrinsics.areEqual((Object)string, (Object)"class")) {
                    bl = false;
                } else if (Intrinsics.areEqual((Object)string, (Object)"kjsm")) {
                    this.$result.element = JSLibraryKind.INSTANCE;
                    bl = false;
                } else if (Intrinsics.areEqual((Object)string, (Object)MetadataPackageFragment.Companion.getMETADATA_FILE_EXTENSION())) {
                    this.$result.element = CommonLibraryKind.INSTANCE;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$result = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
        return (PersistentLibraryKind)result2.element;
    }

    @Nullable
    public static final String getLibraryJarVersion(@NotNull Library library2, @NotNull Pattern jarPattern) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)jarPattern, (String)"jarPattern");
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        for (int i = 0; i < virtualFileArray.length; ++i) {
            VirtualFile file2;
            VirtualFile virtualFile2 = file2 = virtualFileArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
            if (!jarPattern.matcher(virtualFile2.getName()).matches()) continue;
            return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static final String getCommonRuntimeLibraryVersion(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return LibraryKindsKt.getLibraryJarVersion(library2, PathUtil.INSTANCE.getKOTLIN_STDLIB_COMMON_JAR_PATTERN());
    }
}

