/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor$WhenMappings;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "highlightAnnotation", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "textAttributesKeyForClass", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "visitSimpleNameExpression", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "idea-core"})
public final class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtSuperExpression || parent2 instanceof KtThisExpression) {
            return;
        }
        if (NameHighlighter.INSTANCE.getNamesHighlightingEnabled()) {
            DeclarationDescriptor referenceTarget = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
            if (referenceTarget instanceof ConstructorDescriptor) {
                NavigatablePsiElement callElement2;
                NavigatablePsiElement navigatablePsiElement;
                boolean strict$iv;
                PsiElement $receiver$iv;
                PsiElement psiElement2 = (PsiElement)expression2;
                boolean bl = true;
                Function1 branch$iv = visitSimpleNameExpression.callElement.1.INSTANCE;
                PsiElement $receiver$iv$iv = $receiver$iv;
                PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallExpression.class, (boolean)strict$iv);
                KtCallExpression ktCallExpression = (KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, $receiver$iv, branch$iv) : null);
                if (ktCallExpression != null) {
                    navigatablePsiElement = ktCallExpression;
                } else {
                    $receiver$iv = (PsiElement)expression2;
                    strict$iv = true;
                    branch$iv = visitSimpleNameExpression.callElement.2.INSTANCE;
                    $receiver$iv$iv = $receiver$iv;
                    PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtSuperTypeCallEntry.class, (boolean)strict$iv);
                    navigatablePsiElement = callElement2 = (NavigatablePsiElement)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, $receiver$iv, branch$iv) : null);
                }
                if (callElement2 == null) {
                    referenceTarget = ((ConstructorDescriptor)referenceTarget).getContainingDeclaration();
                }
            }
            if (referenceTarget instanceof ClassDescriptor) {
                if (Intrinsics.areEqual((Object)((Object)((ClassDescriptor)referenceTarget).getKind()), (Object)((Object)ClassKind.ANNOTATION_CLASS))) {
                    this.highlightAnnotation(expression2);
                } else {
                    HighlightingVisitor.highlightName$default((HighlightingVisitor)this, (PsiElement)expression2, this.textAttributesKeyForClass((ClassDescriptor)referenceTarget), null, 4, null);
                }
            } else if (referenceTarget instanceof TypeParameterDescriptor) {
                PsiElement psiElement5 = (PsiElement)expression2;
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"TYPE_PARAMETER");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement5, textAttributesKey, null, 4, null);
            }
        }
    }

    private final void highlightAnnotation(KtSimpleNameExpression expression2) {
        PsiElement atSymbol;
        TextRange range = expression2.getTextRange();
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtAnnotationEntry.class, (boolean)false, (Class[])new Class[]{KtValueArgumentList.class});
        if (annotationEntry2 != null && (atSymbol = annotationEntry2.getAtSymbol()) != null) {
            TextRange textRange = atSymbol.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"atSymbol.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = expression2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"expression.textRange");
            range = new TextRange(n, textRange2.getEndOffset());
        }
        TextRange textRange = range;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"ANNOTATION");
        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, textRange, textAttributesKey, null, 4, null);
    }

    @Override
    public void visitTypeParameter(@NotNull KtTypeParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 != null) {
            PsiElement psiElement3;
            PsiElement it;
            PsiElement psiElement4 = it = (psiElement3 = psiElement2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"TYPE_PARAMETER");
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement4, textAttributesKey, null, 4, null);
        }
        super.visitTypeParameter(parameter);
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        PsiElement identifier2 = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get(BindingContext.CLASS, classOrObject);
        if (identifier2 != null && classDescriptor != null) {
            if (this.applyHighlighterExtensions(identifier2, classDescriptor)) {
                return;
            }
            HighlightingVisitor.highlightName$default((HighlightingVisitor)this, identifier2, this.textAttributesKeyForClass(classDescriptor), null, 4, null);
        }
        super.visitClassOrObject(classOrObject);
    }

    @Override
    public void visitDynamicType(@NotNull KtDynamicType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
    }

    private final TextAttributesKey textAttributesKeyForClass(ClassDescriptor descriptor2) {
        TextAttributesKey textAttributesKey;
        switch (TypeKindHighlightingVisitor$WhenMappings.$EnumSwitchMapping$0[descriptor2.getKind().ordinal()]) {
            case 1: {
                TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.TRAIT;
                textAttributesKey = textAttributesKey2;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"TRAIT");
                break;
            }
            case 2: {
                TextAttributesKey textAttributesKey3 = KotlinHighlightingColors.ANNOTATION;
                textAttributesKey = textAttributesKey3;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey3, (String)"ANNOTATION");
                break;
            }
            case 3: {
                TextAttributesKey textAttributesKey4 = KotlinHighlightingColors.OBJECT;
                textAttributesKey = textAttributesKey4;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey4, (String)"OBJECT");
                break;
            }
            case 4: {
                TextAttributesKey textAttributesKey5 = KotlinHighlightingColors.ENUM_ENTRY;
                textAttributesKey = textAttributesKey5;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey5, (String)"ENUM_ENTRY");
                break;
            }
            default: {
                TextAttributesKey textAttributesKey6 = descriptor2.getModality() == Modality.ABSTRACT ? KotlinHighlightingColors.ABSTRACT_CLASS : KotlinHighlightingColors.CLASS;
                textAttributesKey = textAttributesKey6;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey6, (String)"if (descriptor.modality \u2026ABSTRACT_CLASS else CLASS");
            }
        }
        return textAttributesKey;
    }

    public TypeKindHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

