/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedLambdaExpressionBodyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "returnsFunction", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "used", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "RemoveEqTokenFromFunctionDeclarationFix", "idea"})
public final class UnusedLambdaExpressionBodyInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ UnusedLambdaExpressionBodyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
                if (UnusedLambdaExpressionBodyInspection.access$used(this.this$0, expression2, context)) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
                if (!UnusedLambdaExpressionBodyInspection.access$returnsFunction(this.this$0, (CallableDescriptor)((Object)descriptor2))) {
                    return;
                }
                SourceElement sourceElement = descriptor2.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
                PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
                if (!(psiElement2 instanceof KtFunction)) {
                    psiElement2 = null;
                }
                KtFunction ktFunction = (KtFunction)psiElement2;
                if (ktFunction == null) {
                    return;
                }
                KtFunction function2 = ktFunction;
                if (function2.hasBlockBody() || !(function2.getBodyExpression() instanceof KtLambdaExpression)) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)expression2, "Unused return value of a function with lambda expression body", new LocalQuickFix[]{new RemoveEqTokenFromFunctionDeclarationFix(function2)});
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean used(@NotNull KtExpression $receiver, BindingContext context) {
        Boolean bl = (Boolean)context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        return bl != null ? bl : true;
    }

    private final boolean returnsFunction(@NotNull CallableDescriptor $receiver) {
        KotlinType kotlinType = $receiver.getReturnType();
        return kotlinType != null ? FunctionTypesKt.isFunctionType(kotlinType) : false;
    }

    public static final /* synthetic */ boolean access$used(UnusedLambdaExpressionBodyInspection $this, @NotNull KtExpression $receiver, @NotNull BindingContext context) {
        return $this.used($receiver, context);
    }

    public static final /* synthetic */ boolean access$returnsFunction(UnusedLambdaExpressionBodyInspection $this, @NotNull CallableDescriptor $receiver) {
        return $this.returnsFunction($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedLambdaExpressionBodyInspection$RemoveEqTokenFromFunctionDeclarationFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "isSpace", "", "Lcom/intellij/psi/PsiElement;", "idea"})
    public static final class RemoveEqTokenFromFunctionDeclarationFix
    implements LocalQuickFix {
        @NotNull
        private final KtFunction function;

        @NotNull
        public String getName() {
            return "Remove '=' token from function declaration";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block3: {
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.function)) {
                    return;
                }
                PsiElement psiElement3 = this.function.getEqualsToken();
                if (psiElement3 == null) break block3;
                PsiElement $receiver = psiElement2 = psiElement3;
                PsiElement psiElement4 = $receiver.getPrevSibling();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"prevSibling");
                if (this.isSpace(psiElement4)) {
                    PsiElement psiElement5 = $receiver.getNextSibling();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"nextSibling");
                    if (this.isSpace(psiElement5)) {
                        $receiver.getPrevSibling().delete();
                    }
                }
                $receiver.delete();
            }
        }

        private final boolean isSpace(@NotNull PsiElement $receiver) {
            return Intrinsics.areEqual((Object)$receiver.getText(), (Object)" ");
        }

        @NotNull
        public final KtFunction getFunction() {
            return this.function;
        }

        public RemoveEqTokenFromFunctionDeclarationFix(@NotNull KtFunction function2) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            this.function = function2;
        }
    }
}

