/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u000b*\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J$\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToConcatenatedStringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "isTripleQuoted", "str", "", "needsParenthesis", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isFinalEntry", "isStringExpression", "quote", "toSeparateString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "convertExplicitly", "idea"})
public final class ConvertToConcatenatedStringIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            PsiElement psiElement2 = element3.getLastChild();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.lastChild");
            ASTNode aSTNode = psiElement2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.lastChild.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.CLOSING_QUOTE)) ^ true) {
                return false;
            }
            KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntryArray, (String)"element.entries");
            Object[] $receiver$iv = ktStringTemplateEntryArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
                if (!(it instanceof KtStringTemplateEntryWithExpression)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean tripleQuoted;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = element3.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String quote = (tripleQuoted = this.isTripleQuoted(string)) ? "\"\"\"" : "\"";
        KtStringTemplateEntry[] entries2 = element3.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)entries2, (String)"entries");
        Object[] objectArray = entries2;
        void var8_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv$iv;
            if (it instanceof KtStringTemplateEntryWithExpression && ((KtStringTemplateEntryWithExpression)it).getExpression() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void index2;
            void entry;
            int n = index$iv$iv++;
            KtStringTemplateEntry $i$a$1$filterNot = (KtStringTemplateEntry)item$iv$iv;
            int $i$f$filterNotTo = n;
            Collection collection = destination$iv$iv;
            void v2 = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"entry");
            String string2 = this.toSeparateString((KtStringTemplateEntry)v2, quote, index2 == false, index2 == ArraysKt.getLastIndex((Object[])entries2));
            collection.add(string2);
        }
        String text2 = StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"+", null, null, (int)0, null, null, (int)62, null), (String)("" + quote + '+' + quote), (String)"", (boolean)false, (int)4, null);
        KtExpression replacement = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression(text2);
        element3.replace((PsiElement)replacement);
    }

    private final boolean isTripleQuoted(String str) {
        return StringsKt.startsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null);
    }

    private final String toSeparateString(@NotNull KtStringTemplateEntry $receiver, String quote, boolean convertExplicitly, boolean isFinalEntry) {
        String string;
        String text2;
        KtExpression expression2;
        if (!($receiver instanceof KtStringTemplateEntryWithExpression)) {
            String string2 = $receiver.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
            return this.quote(string2, quote);
        }
        KtExpression ktExpression = ((KtStringTemplateEntryWithExpression)$receiver).getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression2 = expression2 = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression");
        String string3 = text2 = this.needsParenthesis(ktExpression2, isFinalEntry) ? "(" + expression2.getText() + ")" : expression2.getText();
        if (convertExplicitly && !this.isStringExpression(expression2)) {
            string = text2 + ".toString()";
        } else {
            String string4 = text2;
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"text");
        }
        return string;
    }

    private final boolean needsParenthesis(KtExpression expression2, boolean isFinalEntry) {
        KtExpression ktExpression = expression2;
        return ktExpression instanceof KtBinaryExpression ? true : (ktExpression instanceof KtIfExpression ? !(((KtIfExpression)expression2).getElse() instanceof KtBlockExpression) && !isFinalEntry : false);
    }

    private final String quote(@NotNull String $receiver, String quote) {
        return quote + $receiver + quote;
    }

    private final boolean isStringExpression(@NotNull KtExpression $receiver) {
        return KotlinBuiltIns.isString(ResolutionUtils.analyze$default($receiver, null, 1, null).getType($receiver));
    }

    public ConvertToConcatenatedStringIntention() {
        super(KtStringTemplateExpression.class, "Convert template to concatenated string", null, 4, null);
    }
}

