/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.query.ComponentShowingQuery;
import org.fest.util.Preconditions;

public final class JMenuItemLocation {
    private Component parentOrInvoker;
    private JPopupMenu parentPopup;
    private final boolean inMenuBar;

    @RunsInCurrentThread
    public JMenuItemLocation(@Nonnull JMenuItem menuItem) {
        if (menuItem == null) {
            JMenuItemLocation.$$$reportNull$$$0(0);
        }
        this.parentOrInvoker = menuItem.getParent();
        if (this.parentOrInvoker instanceof JPopupMenu) {
            this.parentPopup = (JPopupMenu)this.parentOrInvoker;
            this.parentOrInvoker = (Component)Preconditions.checkNotNull((Object)this.parentPopup.getInvoker());
        }
        this.inMenuBar = this.parentOrInvoker instanceof JMenuBar;
    }

    public boolean inMenuBar() {
        return this.inMenuBar;
    }

    @RunsInEDT
    public boolean isParentAMenu() {
        if (!(this.parentOrInvoker instanceof JMenuItem)) {
            return false;
        }
        return this.parentPopup == null || !ComponentShowingQuery.isShowing(this.parentPopup);
    }

    @Nonnull
    public Component parentOrInvoker() {
        Component component = this.parentOrInvoker;
        if (component == null) {
            JMenuItemLocation.$$$reportNull$$$0(1);
        }
        return component;
    }

    @Nullable
    public JPopupMenu parentPopup() {
        return this.parentPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menuItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JMenuItemLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JMenuItemLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parentOrInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

