/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import java.applet.Applet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.launcher.AppletParameter;
import org.fest.swing.launcher.NewAppletViewerQuery;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public class AppletLauncher {
    private final Applet applet;
    private final Map<String, String> parameters;

    @Nonnull
    @RunsInEDT
    public static AppletLauncher applet(@Nonnull String appletType) {
        if (appletType == null) {
            AppletLauncher.$$$reportNull$$$0(0);
        }
        Preconditions.checkNotNullOrEmpty((String)appletType);
        Class<?> type = AppletLauncher.load(appletType);
        if (!Applet.class.isAssignableFrom(type)) {
            String msg = String.format("The given type is not a subclass of %s", Applet.class.getName());
            throw new IllegalArgumentException(msg);
        }
        AppletLauncher appletLauncher = AppletLauncher.instantiate(type);
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(1);
        }
        return appletLauncher;
    }

    @Nonnull
    @RunsInEDT
    private static Class<?> load(@Nonnull String typeName) {
        Class<?> clazz;
        if (typeName == null) {
            AppletLauncher.$$$reportNull$$$0(2);
        }
        try {
            clazz = Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
        if (clazz == null) {
            AppletLauncher.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    private static UnexpectedException cannotLoadType(String typeName, Exception e) {
        String msg = String.format("Unable to load class %s", typeName);
        throw new UnexpectedException(msg, e);
    }

    @Nonnull
    @RunsInEDT
    public static AppletLauncher applet(@Nonnull Class<? extends Applet> appletType) {
        if (appletType == null) {
            AppletLauncher.$$$reportNull$$$0(4);
        }
        AppletLauncher appletLauncher = AppletLauncher.instantiate((Class)Preconditions.checkNotNull(appletType));
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(5);
        }
        return appletLauncher;
    }

    @Nonnull
    private static AppletLauncher instantiate(final @Nonnull Class<?> appletType) {
        AppletLauncher appletLauncher;
        if (appletType == null) {
            AppletLauncher.$$$reportNull$$$0(6);
        }
        try {
            Object applet = GuiActionRunner.execute(new GuiQuery<Object>(){

                @Override
                @Nullable
                protected Object executeInEDT() throws Exception {
                    return appletType.newInstance();
                }
            });
            appletLauncher = AppletLauncher.launcherFor((Applet)Preconditions.checkNotNull((Object)((Applet)applet)));
        }
        catch (Exception e) {
            String msg = String.format("Unable to create a new instance of %s", appletType.getName());
            throw new UnexpectedException(msg, e);
        }
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(7);
        }
        return appletLauncher;
    }

    @Nonnull
    public static AppletLauncher launcherFor(@Nonnull Applet applet) {
        if (applet == null) {
            AppletLauncher.$$$reportNull$$$0(8);
        }
        AppletLauncher appletLauncher = new AppletLauncher(applet);
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(9);
        }
        return appletLauncher;
    }

    private AppletLauncher(@Nonnull Applet applet) {
        if (applet == null) {
            AppletLauncher.$$$reportNull$$$0(10);
        }
        this.parameters = Maps.newHashMap();
        this.applet = (Applet)Preconditions.checkNotNull((Object)applet);
    }

    @Nonnull
    public AppletLauncher withParameters(@Nonnull Map<String, String> newParameters) {
        if (newParameters == null) {
            AppletLauncher.$$$reportNull$$$0(11);
        }
        this.parameters.clear();
        this.parameters.putAll((Map)Preconditions.checkNotNull(newParameters));
        AppletLauncher appletLauncher = this;
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(12);
        }
        return appletLauncher;
    }

    @Nonnull
    public AppletLauncher withParameters(AppletParameter ... newParameters) {
        if (newParameters == null) {
            AppletLauncher.$$$reportNull$$$0(13);
        }
        Preconditions.checkNotNull((Object)newParameters);
        this.parameters.clear();
        for (AppletParameter parameter : newParameters) {
            this.add((AppletParameter)Preconditions.checkNotNull((Object)parameter));
        }
        AppletLauncher appletLauncher = this;
        if (appletLauncher == null) {
            AppletLauncher.$$$reportNull$$$0(14);
        }
        return appletLauncher;
    }

    private void add(@Nonnull AppletParameter parameter) {
        if (parameter == null) {
            AppletLauncher.$$$reportNull$$$0(15);
        }
        this.parameters.put(parameter.name, parameter.value);
    }

    @Nonnull
    public AppletViewer start() {
        AppletViewer appletViewer = NewAppletViewerQuery.showAppletViewerWith(this.applet, this.parameters);
        if (appletViewer == null) {
            AppletLauncher.$$$reportNull$$$0(16);
        }
        return appletViewer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appletType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/launcher/AppletLauncher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applet";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/launcher/AppletLauncher";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "applet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "launcherFor";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applet";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "launcherFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

