/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.monitor.Windows;

class WindowVisibilityMonitor
extends WindowAdapter
implements ComponentListener {
    private final Windows windows;

    WindowVisibilityMonitor(@Nonnull Windows windows) {
        if (windows == null) {
            WindowVisibilityMonitor.$$$reportNull$$$0(0);
        }
        this.windows = windows;
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Window)) {
            return;
        }
        this.windows.markAsShowing((Window)source);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Window)) {
            return;
        }
        this.windows.markAsHidden((Window)source);
    }

    @Override
    @RunsInEDT
    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        w.removeComponentListener(this);
        w.removeWindowListener(this);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "windows", "org/fest/swing/monitor/WindowVisibilityMonitor", "<init>"));
    }
}

